/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.hyades.internal.execution.local.control.Application;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.security.internal.util.BaseConnectUtil;
import org.eclipse.hyades.security.internal.util.IConnectUtilUI;
import org.eclipse.hyades.security.internal.util.NullConnectUtilUI;
import org.eclipse.tptp.platform.execution.client.core.ACPathInfo;
import org.eclipse.tptp.platform.execution.client.core.IAgentController;
import org.eclipse.tptp.platform.execution.client.core.internal.AgentController;
import org.eclipse.tptp.platform.execution.util.internal.AgentControllerPool;
import org.osgi.framework.Bundle;

public class AgentControllerProbe
implements Application {
    private String userid;
    private Application app;

    public AgentControllerProbe(String userid, Application app) {
        this.userid = userid;
        this.app = app == null ? this : app;
    }

    public Result runProbe(String host, int port) {
        AgentController ac;
        Node legacyNode = this.connectLegacy(host, port);
        boolean legacy = legacyNode != null;
        tribool secured = tribool.UNKNOWN;
        if (legacy) {
            tribool tribool2 = secured = legacyNode.getSecurityParameters() != null ? tribool.TRUE : tribool.FALSE;
        }
        if ((ac = (AgentController)this.connectNew(host, port)) != null) {
            try {
                if (!ac.isAgentPathSupported()) {
                    Result result = new Result(host, port, true, secured, false, tribool.UNKNOWN, null);
                    return result;
                }
                ACPathInfo acPath = ac.queryACPath();
                String acHome = acPath.getAcPath();
                Result result = new Result(host, port, true, secured, false, this.isIAC(acHome) ? tribool.TRUE : tribool.FALSE, acHome);
                return result;
            }
            catch (Exception exception) {
                Result result = new Result(host, port, true, secured, false, tribool.UNKNOWN, null);
                return result;
            }
            finally {
                ac.disconnect();
            }
        }
        return new Result(host, port, legacy, secured, legacy, legacy ? tribool.FALSE : tribool.UNKNOWN, null);
    }

    private Node connectLegacy(String hostName, int port) {
        BaseConnectUtil hyadesUtil = new BaseConnectUtil(hostName, "" + port, this.userid, this.app);
        hyadesUtil.setConnectionUI((IConnectUtilUI)new NullConnectUtilUI());
        int result = hyadesUtil.connect("password", false);
        if (result != 0 && 7 != result && 6 != result) {
            return null;
        }
        return hyadesUtil.getNode();
    }

    private IAgentController connectNew(String hostName, int port) {
        try {
            return AgentControllerPool.getInstance().getConnection(hostName, port, true);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isIAC(String home) {
        Bundle iacAdmin = Platform.getBundle((String)"org.eclipse.tptp.platform.iac.administrator");
        String iacHome = Platform.getStateLocation((Bundle)iacAdmin).toString().replace('/', File.separatorChar);
        return home.equals(iacHome);
    }

    public String getName() {
        return this.getClass().getName();
    }

    public static class Result {
        public final String host;
        public final int port;
        public final boolean running;
        public final tribool secure;
        public final boolean legacyOnly;
        public final tribool isIac;
        public final String acHome;

        public Result(String host, int port, boolean running, tribool secure, boolean legacyOnly, tribool isIac, String acHome) {
            this.host = host;
            this.port = port;
            this.running = running;
            this.secure = secure;
            this.legacyOnly = legacyOnly;
            this.isIac = isIac;
            this.acHome = acHome;
        }

        public String toString() {
            return "running=" + this.running + ", secure=" + (Object)((Object)this.secure) + ", legacyOnly=" + this.legacyOnly + ", isIac=" + (Object)((Object)this.isIac) + ", acHome=" + this.acHome;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum tribool {
        UNKNOWN,
        FALSE,
        TRUE;


        public String yesno() {
            switch (this) {
                case TRUE: {
                    return "Yes";
                }
                case FALSE: {
                    return "No";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            throw new IllegalArgumentException("Incomplete switch statement");
        }
    }
}

