/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import com.ibm.icu.text.DateFormat;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentFactory;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.SaveUtil;
import org.eclipse.hyades.models.util.ModelDebugger;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.ProfileUIManager;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.launcher.TraceArguments;
import org.eclipse.hyades.trace.ui.internal.piclient.PIAttachListener;
import org.eclipse.hyades.trace.ui.internal.piclient.PIProcessListener;
import org.eclipse.hyades.trace.ui.internal.piclient.XMLTraceDataProcessor;
import org.eclipse.hyades.trace.ui.internal.util.AttachConfigurationDetail;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.ProcessProxyAdapter;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.HyadesUIPlugin;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.tptp.platform.execution.client.agent.IAgent;
import org.eclipse.tptp.platform.execution.client.core.internal.IProcessListener;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.PIDelegateHelper;
import org.eclipse.tptp.trace.ui.provisional.launcher.AgentSelection;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class PDCoreUtil
extends org.eclipse.tptp.platform.common.ui.trace.internal.util.PDCoreUtil {
    public static final byte PI_MODE_CONTROLLED = 1;
    public static final byte PI_MODE_APPLICATION = 2;
    public static final byte PI_MODE_STANDALONE = 3;
    public static final byte PI_MODE_ENABLED = 4;

    public static final Vector attach(AttachConfigurationDetail configurationDetail) {
        if (configurationDetail.isSwitchPerspective()) {
            PDCoreUtil.switchPerspective();
        }
        String hostName = configurationDetail.getHostName();
        try {
            Node fnode = NodeFactory.createNode((String)hostName);
            hostName = fnode.getInetAddress().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(configurationDetail.getProject()));
        TRCMonitor monitor = PDCoreUtil.createMonitor((IContainer)container, (String)configurationDetail.getMonitor());
        TRCNode node = PDCoreUtil.createNode((TRCMonitor)monitor, (String)hostName, (String)configurationDetail.getPortNumber());
        Vector<TRCAgentProxy> trcAgentList = new Vector<TRCAgentProxy>();
        Vector agents = configurationDetail.getAgents();
        int idx = 0;
        while (idx < agents.size()) {
            block14: {
                IAgent newAgent;
                Agent oldAgent;
                block13: {
                    block12: {
                        oldAgent = null;
                        newAgent = null;
                        if (!(agents.elementAt(idx) instanceof Agent)) break block12;
                        oldAgent = (Agent)agents.elementAt(idx);
                        break block13;
                    }
                    if (!(agents.elementAt(idx) instanceof IAgent)) break block14;
                    newAgent = (IAgent)agents.elementAt(idx);
                }
                final ProcessAdapter adapter = new ProcessAdapter(oldAgent == null ? newAgent.getProcess() : oldAgent.getProcess(), configurationDetail.getLaunch(), true, 0);
                UIPlugin.getDefault().registerLaunchProcess(adapter);
                if (oldAgent == null) {
                    newAgent.getProcess().addProcessListener(new IProcessListener(){

                        public void processLaunched(org.eclipse.tptp.platform.execution.client.core.IProcess arg0) {
                        }

                        public void processExited(org.eclipse.tptp.platform.execution.client.core.IProcess arg0) {
                            PDCoreUtil.notifyProcessExit(adapter);
                        }
                    });
                } else {
                    oldAgent.getProcess().addProcessListener(new ProcessListener(){

                        public void processLaunched(Process arg0) {
                        }

                        public void processExited(Process arg0) {
                            PDCoreUtil.notifyProcessExit(adapter);
                        }
                    });
                }
                TRCProcessProxy process = null;
                if (oldAgent != null) {
                    PDCoreUtil.configureAgent(configurationDetail, oldAgent);
                }
                process = PDCoreUtil.createProcess((TRCNode)node, (Object)(oldAgent == null ? newAgent.getProcess() : oldAgent.getProcess()));
                LauncherUtility.addLaunchConfigId(process, "org.eclipse.hyades.trace.ui.internal.launcher.localJavaProcess");
                process.eAdapters().add((Object)new ProcessProxyAdapter());
                ProcessMap.put(process, adapter);
                try {
                    TRCAgentProxy agentProxy = oldAgent == null ? PDCoreUtil.attachToAgent(process, newAgent, configurationDetail.getOptions(), true) : PDCoreUtil.attachToAgent(process, oldAgent, configurationDetail.getOptions(), true);
                    trcAgentList.add(agentProxy);
                }
                catch (Exception e) {
                    UIPlugin.getDefault().log(e);
                }
            }
            ++idx;
        }
        return trcAgentList;
    }

    private static void configureAgent(AttachConfigurationDetail configurationDetail, Agent agent) {
        Vector options;
        String profileFile;
        AgentConfiguration ac = agent.getConfiguration();
        if (ac == null) {
            agent.setConfiguration(new AgentConfiguration());
        }
        if (configurationDetail.isForceAgentConfClear()) {
            agent.getConfiguration().clear();
        }
        agent.setProfileFile((profileFile = configurationDetail.getProfileFile()) == null || profileFile.trim().length() <= 0 ? "" : profileFile);
        if (configurationDetail.getFilters() != null) {
            PDCoreUtil.addDefaultProfileData(agent, configurationDetail.getFilters());
        }
        if ((options = configurationDetail.getOptions()) == null) {
            options = new Vector();
        }
        PDCoreUtil.addDefaultOptionsData(agent, options);
    }

    private static void notifyProcessExit(IProcess adapter) {
        UIPlugin.getDefault().deregisterLaunchProcess(adapter);
        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)adapter, 8)});
    }

    public static TRCAgentProxy attachToAgent(TRCProcessProxy process, Agent agent) throws InactiveAgentException, InactiveProcessException {
        return PDCoreUtil.attachToAgent(process, agent, null, false);
    }

    public static TRCAgentProxy attachToAgent(TRCProcessProxy process, Object agent, Vector options, boolean mayNeedPolling) throws InactiveAgentException, InactiveProcessException {
        TRCAgentProxy agentProxy = PDCoreUtil.createUniqueAgent(process, agent);
        PDCoreUtil.activate((TRCAgentProxy)agentProxy);
        final ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource((Object)agentProxy);
        event.setType(4);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                UIPlugin.getDefault().notifyProfileEventListener(event);
            }
        });
        return agentProxy;
    }

    public static final void detachAgent(TRCAgentProxy agent) throws InactiveAgentException, InactiveProcessException {
        PDCoreUtil.detachAgent(agent, true);
    }

    public static final void detachAgent(TRCAgentProxy agent, boolean deregistrate) throws InactiveAgentException, InactiveProcessException {
        XMLTraceDataProcessor processor;
        Object instance;
        TRCProcessProxy process = agent.getProcessProxy();
        String hostName = process.getNode().getName();
        Node node = PDCoreUtil.profileConnect((String)hostName, (String)String.valueOf(process.getNode().getPort()));
        if (node != null && (instance = LoadersUtils.locateAgentInstance((TRCAgentProxy)agent)) != null && instance instanceof Agent) {
            Agent a = (Agent)instance;
            AgentListener al = (AgentListener)LoadersUtils.locateAgentListener((TRCAgentProxy)agent);
            a.removeAgentListener(al);
            if (a.isAttached()) {
                a.detach();
            }
        }
        agent.setMonitored(false);
        agent.setAttached(false);
        LoadersUtils.deregisterDataProcessor((TRCAgentProxy)agent);
        if (deregistrate) {
            LoadersUtils.deregisterAgentProxyContext((TRCAgentProxy)agent);
        }
        if (agent.isToProfileFile() && (processor = (XMLTraceDataProcessor)LoadersUtils.locateDataProcessor((TRCAgentProxy)agent)) != null) {
            processor.endTrace(processor.getWriter());
            processor.setProfileFileName(null);
            processor.setWriter(null);
        }
    }

    public static void doAttach(Agent agent, TRCAgentProxy agentProxy) throws InactiveAgentException, InactiveProcessException {
        PDCoreUtil.doAttach(null, agentProxy, agent, null, null);
    }

    public static void doAttach(TRCProcessProxy trcProcessProxy, TRCAgentProxy agentProxy, Agent agent, Vector options, ILaunchConfiguration configuration) throws InactiveAgentException, InactiveProcessException {
        PIProcessListener processListener = (PIProcessListener)LoadersUtils.locateAgentListener((TRCAgentProxy)agentProxy);
        if (processListener == null) {
            processListener = new PIAttachListener(agentProxy.getProcessProxy().getNode(), agentProxy.getProcessProxy());
            LoadersUtils.registerAgentListener((TRCAgentProxy)agentProxy, (Object)processListener);
        }
        if (trcProcessProxy != null && (options != null || configuration != null)) {
            String[] pollingOptions = new String[3];
            if (options != null) {
                AgentConfigurationEntry[] confEntries = PIDelegateHelper.PeriodicPoll.getOption(options, new String[]{IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ});
                int i = 0;
                while (i < confEntries.length) {
                    pollingOptions[i] = confEntries[i] == null ? null : confEntries[i].getValue();
                    ++i;
                }
            } else if (configuration != null) {
                try {
                    pollingOptions[0] = String.valueOf(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW, false));
                    pollingOptions[1] = String.valueOf(configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ_MODE, true));
                    int pollingFrequency = configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_EXEC_POLLING_FREQ, -1);
                    pollingOptions[2] = pollingFrequency < 0 ? null : String.valueOf(pollingFrequency);
                }
                catch (CoreException e) {
                    UIPlugin.getDefault().log(e);
                }
            }
            PIDelegateHelper.PeriodicPoll periodicPolling = PIDelegateHelper.PeriodicPoll.createInstance(pollingOptions, trcProcessProxy, processListener, agent);
            if (periodicPolling != null) {
                periodicPolling.start();
            }
        }
        processListener.monitor(true);
        processListener.setLaunchMode(0);
        agent.addAgentListener((AgentListener)processListener);
        agent.attach();
    }

    public static void addProcessParameters(Process lprocess, ProcessParameters parameters, boolean switchPerspective) throws CoreException {
        if (switchPerspective) {
            PDCoreUtil.switchPerspective();
        }
        try {
            String appParam;
            String execParam;
            String paramStr = parameters.getApplicationName();
            if (paramStr == null) {
                paramStr = "";
            }
            if (PDCoreUtil.isValidString(execParam = parameters.getExecutableParametersStr())) {
                paramStr = String.valueOf(execParam) + " " + paramStr;
            }
            if (PDCoreUtil.isValidString(appParam = parameters.getApplicationParametersStr())) {
                paramStr = String.valueOf(paramStr) + " " + appParam;
            }
            lprocess.setParameters(paramStr);
        }
        catch (Exception e) {
            throw LauncherUtility.createCoreException(4, e.getMessage(), e);
        }
    }

    private static boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    public static Agent createAgent(Process lprocess, ArrayList filters, Vector options, TRCProcessProxy trcProcessProxy, String agentName, String agentType) {
        Agent a = AgentFactory.createAgent((Process)lprocess, (String)agentName, (String)agentType);
        a.setAutoAttach(true);
        AgentConfiguration ac = a.getConfiguration();
        if (ac == null) {
            a.setConfiguration(new AgentConfiguration());
        }
        a.getConfiguration().clear();
        PDCoreUtil.addDefaultProfileData(a, filters);
        PDCoreUtil.addDefaultOptionsData(a, options);
        return a;
    }

    public static Agent createAgent(Process lprocess, ArrayList filters, Vector options, TRCProcessProxy trcProcessProxy) {
        return PDCoreUtil.createAgent(lprocess, filters, options, trcProcessProxy, "Java Profiling Agent", "Profiler");
    }

    public static final boolean launchTrace(TraceArguments trace, ArrayList filters, Vector options, String selectedProject, String selectedMonitor, ILaunch launch) {
        return PDCoreUtil.launchTrace(trace, filters, options, selectedProject, selectedMonitor, launch, true);
    }

    public static final boolean launchTrace(TraceArguments trace, ArrayList filters, Vector options, String selectedProject, String selectedMonitor, ILaunch launch, boolean switchPerspective) {
        Node lhost;
        String nodeName;
        IPreferenceStore store;
        block17: {
            store = UIPlugin.getDefault().getPreferenceStore();
            if (switchPerspective) {
                PDCoreUtil.switchPerspective();
            }
            nodeName = trace.getHostName();
            lhost = PDCoreUtil.profileConnect((String)nodeName, (String)String.valueOf(trace.getPortNumber()));
            if (lhost != null) break block17;
            return false;
        }
        try {
            nodeName = lhost.getName();
            IContainer container = PDCoreUtil.createContainer((IPath)new Path(selectedProject));
            TRCMonitor monitor = PDCoreUtil.createMonitor((IContainer)container, (String)selectedMonitor);
            TRCNode node = PDCoreUtil.createNode((TRCMonitor)monitor, (String)nodeName, (String)String.valueOf(trace.getPortNumber()));
            PIProcessListener listener = new PIProcessListener(node);
            listener.monitor(true);
            Process lprocess = ProcessFactory.createProcess((Node)lhost);
            if (ConnectUtil.isLocalHost((String)nodeName)) {
                lprocess.setLocation(trace.getLocation());
            } else {
                lprocess.setLocation(null);
            }
            lprocess.addProcessListener((ProcessListener)listener);
            listener.setLaunchMode(1);
            listener.setAutoMonitoring(trace.isAutoMonitoring());
            boolean hasProfAgents = false;
            if (store.getBoolean("prof_option")) {
                hasProfAgents = true;
                Agent a = AgentFactory.createAgent((Process)lprocess, (String)"Java Profiling Agent", (String)"Profiler");
                a.addAgentListener((AgentListener)listener);
                a.setAutoAttach(true);
                AgentConfiguration ac = a.getConfiguration();
                if (ac == null) {
                    a.setConfiguration(new AgentConfiguration());
                }
                a.getConfiguration().clear();
                if (trace.isToProfileFile()) {
                    a.setProfileFile(trace.getProfileFile());
                }
                PDCoreUtil.addDefaultProfileData(a, filters);
                PDCoreUtil.addDefaultOptionsData(a, options);
            }
            String exec = trace.getClassName();
            if (trace.getVMArguments() != null && !trace.getVMArguments().equals("")) {
                exec = String.valueOf(trace.getVMArguments()) + " " + exec;
            }
            if (trace.getParameters() != null && !trace.getParameters().equals("")) {
                exec = String.valueOf(exec) + " " + trace.getParameters();
            }
            String param = "";
            if (!hasProfAgents) {
                param = exec;
            }
            if (hasProfAgents) {
                lprocess.setExecutable("java.exe");
                param = "-XrunpiAgent:server=controlled " + exec;
            } else {
                lprocess.setExecutable("java.exe");
                param = exec;
            }
            lprocess.setParameters(param);
            lprocess.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar((String)trace.getClassPath())));
            lprocess.addEnvironmentVariable(new Variable("UICLASSPATH", trace.getClassPath()));
            listener.getProcessVariableList().add(new Variable("UICLASSPATH", trace.getClassPath()));
            PDCoreUtil.setEnvironmentVariable(lprocess, trace.getEnvironmentVariable(), listener);
            try {
                lprocess.launch();
                final ProcessAdapter adapter = new ProcessAdapter(lprocess, launch, true, 1);
                UIPlugin.getDefault().registerLaunchProcess(adapter);
                lprocess.addProcessListener(new ProcessListener(){

                    public void processLaunched(Process p) {
                    }

                    public void processExited(Process p) {
                        UIPlugin.getDefault().deregisterLaunchProcess(adapter);
                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)adapter, 8)});
                    }
                });
                int pID = Integer.parseInt(lprocess.getProcessId());
                for (TRCProcessProxy proxy : node.getProcessProxies()) {
                    if (pID != proxy.getPid() || !proxy.isActive()) continue;
                    ProcessMap.put(proxy, adapter);
                    break;
                }
            }
            catch (Exception e) {
                String text = TraceMessages.PLERR_INFO_;
                final String msg = NLS.bind((String)TraceMessages.PL_ERROR_, (Object)trace.getClassName());
                final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
                HyadesUIPlugin.logError((Throwable)e);
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)TraceMessages.TRC_MSGT, (String)msg, (IStatus)err);
                    }
                });
                return false;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return false;
        }
        return true;
    }

    public static Enumeration getNodeConfiguration(String nodeName, int portNumber, boolean showErrorMsgs) {
        Node node;
        block3: {
            try {
                node = PDCoreUtil.profileConnect((String)nodeName, (String)String.valueOf(portNumber), (boolean)showErrorMsgs);
                if (node != null) break block3;
                return null;
            }
            catch (NotConnectedException exc2) {
                exc2.printStackTrace();
                return null;
            }
        }
        return node.listProcesses();
    }

    public static Agent getAgentInstance(String hostName, int portNumber, TRCAgentProxy trcAgent) {
        Enumeration processes = PDCoreUtil.getNodeConfiguration(hostName, portNumber, false);
        if (processes != null) {
            while (processes.hasMoreElements()) {
                Object p = processes.nextElement();
                if (p == null || !(p instanceof Process)) continue;
                Enumeration agents = ((Process)p).listAgents();
                while (agents.hasMoreElements()) {
                    Object a = agents.nextElement();
                    if (a == null || !(a instanceof Agent) || !((Agent)a).getUUID().equals(trcAgent.getRuntimeId())) continue;
                    return (Agent)a;
                }
            }
        }
        return null;
    }

    public static Enumeration getNodeConfiguration(String nodeName, int portNumber) {
        return PDCoreUtil.getNodeConfiguration(nodeName, portNumber, true);
    }

    protected static TRCAgentProxy createAgentNoCheck(TRCProcessProxy process, Agent agent, String sessionId) {
        return PDCoreUtil.createAgentNoCheck(process, (Object)agent, sessionId);
    }

    protected static TRCAgentProxy createAgentNoCheck(TRCProcessProxy process, IAgent agent, String sessionId) {
        return PDCoreUtil.createAgentNoCheck(process, (Object)agent, sessionId);
    }

    protected static TRCAgentProxy createAgentNoCheck(TRCProcessProxy process, Object agent, String sessionId) {
        String timestamp;
        Agent oldAgent = null;
        IAgent newAgent = null;
        if (agent instanceof Agent) {
            oldAgent = (Agent)agent;
        } else if (agent instanceof IAgent) {
            newAgent = (IAgent)agent;
        } else {
            return null;
        }
        String agentName = oldAgent == null ? newAgent.getName() : oldAgent.getName();
        String agentType = oldAgent == null ? null : oldAgent.getType();
        String profileFile = oldAgent == null ? null : oldAgent.getProfileFile();
        String rID = timestamp = DateFormat.getDateTimeInstance((int)0, (int)0).format(new Date());
        rID = TString.change((String)rID, (String)" ", (String)"");
        rID = TString.change((String)rID, (String)":", (String)"");
        String qualifiedAgentName = new StringBuffer(process.getNode().getMonitor().getName()).append("_").append(process.getNode().getName()).append("_").append(process.getPid()).append("_").append(rID).append("_").append(sessionId).append("_").append(agentName).toString();
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = ModelDebugger.INSTANCE.debugDatabaseResourcePostfix != null && ModelDebugger.INSTANCE.debugDatabaseResourcePostfix.length() > 1 ? String.valueOf(qualifiedAgentName) + ModelDebugger.INSTANCE.debugDatabaseResourcePostfix : String.valueOf(qualifiedAgentName) + "." + "trcaxmi";
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = SaveUtil.createURI((String)(String.valueOf(filePath.toString()) + "#")).trimFragment();
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        TRCAgentProxy agentProxy = factory.createTRCAgentProxy();
        agentProxy.setName(agentName);
        if (agentType != null) {
            agentProxy.setType(agentType);
        }
        agentProxy.setProcessProxy(process);
        agentProxy.setProfileFile(profileFile);
        TRCAgent iAgent = factory.createTRCAgent();
        iAgent.setAgentProxy(agentProxy);
        agExt.add((Object)iAgent);
        PDCoreUtil.markModifiedResources((EObject)iAgent, (boolean)true);
        if (oldAgent != null) {
            PDCoreUtil.addAnalysisType(factory, oldAgent, agentProxy);
        }
        if (oldAgent != null && agentProxy.getType().equals("Profiler")) {
            PDCoreUtil.computeCollectionMode(factory, oldAgent, agentProxy);
        }
        if (agentProxy.getAgent() != null) {
            agentProxy.getAgent().setCollectionMode(agentProxy.getCollectionMode());
        }
        iAgent.setName(agentProxy.getName());
        iAgent.setRuntimeId(agentProxy.getRuntimeId());
        iAgent.setType(agentProxy.getType());
        iAgent.setCollectionMode(agentProxy.getCollectionMode());
        return agentProxy;
    }

    private static void computeCollectionMode(HierarchyFactory factory, Agent agent, TRCAgentProxy agentProxy) {
        if (agentProxy.getName().equals("J2EE Request Profiler")) {
            agentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
            return;
        }
        TRCConfiguration config = factory.createTRCConfiguration();
        config.setName(PDCoreUtil.getFilterSetName(agent));
        config.setActive(true);
        config.setAgentProxy(agentProxy);
        agentProxy.getConfigurations().add((Object)config);
        AgentConfiguration aconfig = agent.getConfiguration();
        boolean collectHeapInfo = false;
        boolean collectHeapInstanceLevelInfo = false;
        boolean collectExecInfo = false;
        boolean collectExecInstanceLevelInfo = false;
        boolean showExecutionFlowFull = false;
        if (aconfig != null) {
            int idx = 0;
            while (idx < aconfig.size()) {
                TRCOption opt;
                AgentConfigurationEntry entry = aconfig.getEntryAt(idx);
                if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXECUTION_FLOW)) {
                    opt = factory.createTRCOption();
                    opt.setKey(entry.getName());
                    opt.setValue(entry.getValue());
                    opt.setConfiguration(config);
                    showExecutionFlowFull = entry.getValue().equalsIgnoreCase("true");
                } else if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES)) {
                    collectExecInstanceLevelInfo = entry.getValue().equalsIgnoreCase("true");
                } else if (entry.getName().equals(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES)) {
                    collectHeapInstanceLevelInfo = entry.getValue().equalsIgnoreCase("true");
                } else if (entry.getType().equals("SETFILTER")) {
                    TRCFilter filter = factory.createTRCFilter();
                    filter.setMode(entry.getValue());
                    filter.setOperation("");
                    filter.setPattern(entry.getName());
                    filter.setType(entry.getValue());
                    filter.setActive(new Boolean(entry.isEnabled()));
                    filter.setConfiguration(config);
                } else if (entry.getType().equals("SETMETHODFILTER")) {
                    String criteria = entry.getName();
                    int offset = criteria.indexOf(32);
                    if (offset > 0) {
                        TRCFilter filter = factory.createTRCFilter();
                        filter.setMode(entry.getValue());
                        filter.setPattern(criteria.substring(0, offset));
                        filter.setOperation(criteria.substring(offset + 1, criteria.length()));
                        filter.setType(entry.getValue());
                        filter.setActive(new Boolean(entry.isEnabled()));
                        filter.setConfiguration(config);
                    }
                } else if (entry.getType().equals("SETOPTION")) {
                    opt = factory.createTRCOption();
                    opt.setKey(entry.getName());
                    opt.setValue(entry.getValue());
                    opt.setConfiguration(config);
                    if (entry.getName().equals("TRACE_MODE")) {
                        boolean bl = collectHeapInfo = !entry.getValue().equals("none") && !entry.getValue().equals("noObjectCorrelation");
                    }
                    if (entry.getName().equals("STACK_INFORMATION")) {
                        collectExecInfo = !entry.getValue().equals("none");
                    }
                }
                ++idx;
            }
        }
        if (collectExecInfo) {
            if (collectHeapInfo) {
                if (collectHeapInstanceLevelInfo) {
                    if (showExecutionFlowFull) {
                        agentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
                    } else {
                        agentProxy.setCollectionMode(TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                    }
                } else if (showExecutionFlowFull) {
                    if (collectExecInstanceLevelInfo) {
                        agentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
                    } else {
                        agentProxy.setCollectionMode(TRCCollectionMode.HEAP_STATISTICS_AND_EXECUTION_NO_INSTANCES_LITERAL);
                    }
                } else {
                    agentProxy.setCollectionMode(TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
                }
            } else if (!showExecutionFlowFull) {
                agentProxy.setCollectionMode(TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL);
            } else if (collectExecInstanceLevelInfo) {
                agentProxy.setCollectionMode(TRCCollectionMode.EXECUTION_FULL_LITERAL);
            } else {
                agentProxy.setCollectionMode(TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL);
            }
        } else if (collectHeapInstanceLevelInfo) {
            agentProxy.setCollectionMode(TRCCollectionMode.HEAP_FULL_LITERAL);
        } else {
            agentProxy.setCollectionMode(TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);
        }
    }

    private static void addAnalysisType(HierarchyFactory factory, Agent agent, TRCAgentProxy agentProxy) {
        AgentConfiguration agentConfiguration = agent.getConfiguration();
        int agentConfigurationCount = agentConfiguration == null ? 0 : agentConfiguration.size();
        TRCConfiguration agentProxyConfiguration = null;
        int i = 0;
        while (i < agentConfigurationCount) {
            AgentConfigurationEntry agentConfigurationEntry = agentConfiguration.getEntryAt(i);
            String configuraitonEntryName = agentConfigurationEntry.getName();
            if (configuraitonEntryName != null && configuraitonEntryName.startsWith(LauncherConstants.ANALYSIS_TYPE_ASSOCIATION) && "SETOPTION".equals(agentConfigurationEntry.getType())) {
                TRCOption agentProxyConfigurationEntry = factory.createTRCOption();
                agentProxyConfigurationEntry.setKey(configuraitonEntryName);
                agentProxyConfigurationEntry.setValue(agentConfigurationEntry.getValue());
                if (agentProxyConfiguration == null) {
                    agentProxyConfiguration = factory.createTRCConfiguration();
                    agentProxyConfiguration.setName("SETOPTION");
                    agentProxyConfiguration.setActive(true);
                    agentProxyConfiguration.setAgentProxy(agentProxy);
                    agentProxy.getConfigurations().add((Object)agentProxyConfiguration);
                }
                agentProxyConfigurationEntry.setConfiguration(agentProxyConfiguration);
            }
            ++i;
        }
    }

    private static void addDefaultOptionsData(Agent a, Vector optionsList) {
        AgentConfiguration config = a.getConfiguration();
        int idx = 0;
        while (idx < optionsList.size()) {
            config.addEntry((AgentConfigurationEntry)optionsList.elementAt(idx));
            ++idx;
        }
    }

    private static void addDefaultProfileData(Agent a, ArrayList filtersList) {
        AgentConfiguration config = a.getConfiguration();
        int idx = 0;
        while (idx < filtersList.size()) {
            FilterTableElement elem = (FilterTableElement)filtersList.get(idx);
            AgentConfigurationEntry entry = new AgentConfigurationEntry();
            if (elem.getMethod().equals("")) {
                entry.setName(elem.getText());
                entry.setType("SETFILTER");
            } else {
                entry.setName(String.valueOf(elem.getText()) + ' ' + elem.getMethod());
                entry.setType("SETMETHODFILTER");
            }
            entry.setValue(elem.getVisibility().equals(TraceMessages.INCLUDE) ? "INCLUDE" : "EXCLUDE");
            entry.setEnabled(true);
            config.addEntry(entry);
            ++idx;
        }
    }

    public static void setEnvironmentVariable(Process process, String[] envVariables, PIProcessListener listener) {
        if (envVariables != null && process != null) {
            int i = 0;
            while (i < envVariables.length) {
                try {
                    int equalInx;
                    int n = equalInx = envVariables[i] == null ? -1 : envVariables[i].indexOf(61);
                    if (equalInx != -1) {
                        String name = envVariables[i].substring(0, equalInx);
                        String value = envVariables[i].substring(equalInx + 1);
                        process.addEnvironmentVariable(new Variable(name, value));
                        listener.getProcessVariableList().add(new Variable(name, value));
                    }
                }
                catch (Exception e) {
                    CommonPlugin.logError((Throwable)e);
                }
                ++i;
            }
        }
    }

    public static void copyAgentProperties(TRCAgentProxy fAgentOld, TRCAgentProxy fAgent) {
        fAgent.setCollectionMode(fAgentOld.getCollectionMode());
        fAgent.setProfileFile(fAgentOld.getProfileFile());
        fAgent.getConfigurations().clear();
        for (TRCConfiguration configuration : fAgentOld.getConfigurations()) {
            fAgent.getConfigurations().add((Object)((TRCConfiguration)EcoreUtil.copy((EObject)configuration)));
        }
        TRCProcessProxy process = fAgent.getProcessProxy();
        TRCNode node = process.getNode();
        PDCoreUtil.sendConfigurationToAgent(fAgent, node.getName(), process.getPid());
    }

    private static void sendConfigurationToAgent(TRCAgentProxy agent, String host, int processId) {
        Node node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(agent.getProcessProxy().getNode().getPort()));
        if (node == null) {
            return;
        }
        Process p = node.getProcess(String.valueOf(processId));
        if (p != null) {
            try {
                Agent a = p.getAgent(agent.getName());
                a.setProfileFile(agent.getProfileFile());
                PDCoreUtil.setAgentConfiguration((TRCAgentProxy)agent, (Agent)a);
                if (a != null && a.isActive()) {
                    a.publishConfiguration();
                    CustomCommand command = new CustomCommand();
                    command.setData("APPLYFILTERS");
                    a.invokeCustomCommand(command);
                }
            }
            catch (InactiveAgentException inactiveAgentException) {}
        }
    }

    private static void switchPerspective() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    boolean shouldSwitch = CommonUIPlugin.getDefault().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", CommonUIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", TraceWizardMessages.CONFIRM_PSWITCH);
                    if (shouldSwitch) {
                        UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                    }
                    if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
                        PDProjectExplorer nav = (PDProjectExplorer)UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                        nav.getViewer().refresh();
                    }
                }
                catch (Exception exc) {
                    CommonPlugin.logError((Throwable)exc);
                }
            }
        });
    }

    private static String getFilterSetName(Agent a) {
        AgentConfiguration conf = a.getConfiguration();
        int i = 0;
        while (i < conf.size()) {
            AgentConfigurationEntry e = conf.getEntryAt(i);
            if (IProfileLaunchConfigurationConstants.ATTR_FILTER_SET.equals(e.getName())) {
                Object obj;
                Map filterSets = ProfilingSetsManager.instance().getFilterSets();
                Object v0 = obj = e.getValue() == null ? null : filterSets.get(e.getValue());
                if (obj != null) {
                    FilterSetElement elem = obj;
                    return elem.getDisplayName();
                }
            }
            ++i;
        }
        return UIPlugin.getResourceString(TraceConstants.DEFAULT_FILTER_SET);
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy process, Agent a) {
        TRCAgentProxy agentProxy = PDCoreUtil.createAgent(process, a, "");
        return agentProxy;
    }

    public static TRCAgentProxy createAgent(TRCProcessProxy processProxy, Agent agent, String sessionId) {
        TRCAgentProxy agentProxy = PDCoreUtil.getCorrespondingAgent((TRCProcessProxy)processProxy, (Agent)agent, (boolean)false);
        if (agentProxy != null) {
            return agentProxy;
        }
        return PDCoreUtil.createAgentNoCheck(processProxy, agent, sessionId);
    }

    public static TRCAgentProxy createUniqueAgent(TRCProcessProxy processProxy, Object agent) {
        long timeStamp = new Date().getTime();
        double time = (double)timeStamp / 1000.0;
        TRCAgentProxy agentProxy = PDCoreUtil.createAgentNoCheck(processProxy, agent, String.valueOf(timeStamp));
        LoadersUtils.registerAgentInstance((TRCAgentProxy)agentProxy, (Object)agent);
        LoadersUtils.setSessionStartTime((double)time, (TRCAgentProxy)agentProxy);
        return agentProxy;
    }

    public static void monitorAgents(AgentSelection[] selection, ILaunchConfiguration configuration, boolean monitor) {
        if (selection == null) {
            return;
        }
        int i = 0;
        while (i < selection.length) {
            block6: {
                TRCAgentProxy agentProxy = selection[i].getAgentProxy();
                try {
                    PDCoreUtil.doAttach(agentProxy.getProcessProxy(), agentProxy, (Agent)selection[i].getAgent(), null, configuration);
                }
                catch (InactiveAgentException e) {
                    UIPlugin.getDefault().log(e);
                    break block6;
                }
                catch (InactiveProcessException e) {
                    UIPlugin.getDefault().log(e);
                    break block6;
                }
                if (monitor) {
                    ProfileUIManager.getInstance().startMonitoring(agentProxy);
                }
            }
            ++i;
        }
    }

    public static boolean isTBFFile(byte[] magic) {
        if (magic.length < 4) {
            return false;
        }
        return magic[1] == 84 && magic[2] == 66 && magic[3] == 70;
    }

    public static boolean isTBFFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[4];
        if (readStream.read(magic) > 1) {
            return PDCoreUtil.isTBFFile(magic);
        }
        return false;
    }

    public static boolean isTBFFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = PDCoreUtil.isTBFFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }

    public static boolean isXMLFile(byte[] magic) {
        if (magic.length < 5) {
            return false;
        }
        return magic[0] == 60 && magic[1] == 63 && magic[2] == 120 && magic[3] == 109 && magic[4] == 108;
    }

    public static boolean isXMLFile(InputStream readStream) throws IOException {
        byte[] magic = new byte[5];
        if (readStream.read(magic) > 1) {
            return PDCoreUtil.isXMLFile(magic);
        }
        return false;
    }

    public static boolean isXMLFile(String fileName) throws IOException {
        FileInputStream readStream = new FileInputStream(fileName);
        boolean ret = PDCoreUtil.isXMLFile(readStream);
        readStream.close();
        readStream = null;
        return ret;
    }
}

