/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.ui.internal.util.ErrorItem;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ProcessTreeItem
implements IAdaptable {
    private Object _adapter;
    private Object _data;
    private ProcessTreeItem _parent;
    private ProcessTreeItem[] _children;

    public ProcessTreeItem(Object data, ProcessTreeItem parent) {
        this._data = data;
        this._parent = parent;
        this._children = null;
    }

    public Object getData() {
        return this._data;
    }

    public ProcessTreeItem getParent() {
        return this._parent;
    }

    public void setChildren(ProcessTreeItem[] children) {
        this._children = children;
    }

    public ProcessTreeItem[] getChildren() {
        return this._children;
    }

    public Object getAdapter(Class adapter) {
        return this._adapter;
    }

    public void setAdapter(Object adapter) {
        this._adapter = adapter;
    }

    public String getLabelText() {
        if (this._data == null) {
            return "";
        }
        if (this._data instanceof Process) {
            String label = ((Process)this._data).getName();
            if (label == null) {
                label = ((Process)this._data).getExecutable();
            }
            String text = NLS.bind((String)TraceMessages.PRC_SHRT, (Object)label);
            try {
                text = NLS.bind((String)TraceMessages.PRC_SHRT, (Object[])new Object[]{label, String.valueOf(((Process)this._data).getProcessId())});
            }
            catch (InactiveProcessException inactiveProcessException) {
                return label;
            }
            return text;
        }
        if (this._data instanceof Agent) {
            return ((Agent)this._data).getName();
        }
        if (this._data instanceof ErrorItem) {
            return ((ErrorItem)this._data).getMessage();
        }
        return "";
    }

    public Image getImage() {
        if (this._data == null) {
            return null;
        }
        if (this._data instanceof Process) {
            return PDPluginImages.getImage("process_obj.gif");
        }
        if (this._data instanceof Agent) {
            return PDPluginImages.getImage("agent_detach_obj.gif");
        }
        if (this._data instanceof ErrorItem) {
            return PDPluginImages.getImage("error_tsk.gif");
        }
        return null;
    }

    public String getProcessId() {
        Process process = null;
        if (this._data instanceof Process) {
            process = (Process)this._data;
        } else if (this._data instanceof Agent) {
            process = (Process)this.getParent().getData();
        }
        if (process != null) {
            try {
                return process.getProcessId();
            }
            catch (InactiveProcessException inactiveProcessException) {}
        }
        return null;
    }
}

