/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceFiltersExtractor {
    public static ArrayList<FilterTableElement> extractFilters(IProject project, IWorkingSet[] workingSets) throws CoreException {
        HashSet<String> included = new HashSet<String>();
        WorkspaceFiltersExtractor.addProjectFilters(project, included, false);
        IProject[] dependencies = project.getReferencedProjects();
        if (dependencies != null && dependencies.length > 0) {
            Set<String> dependenciesScope = WorkspaceFiltersExtractor.getDependenciesScope(workingSets);
            Set<String> dependentIncluded = new HashSet<String>();
            int j = 0;
            while (j < dependencies.length) {
                WorkspaceFiltersExtractor.addProjectFilters(dependencies[j], dependentIncluded, false);
                ++j;
            }
            dependentIncluded = WorkspaceFiltersExtractor.excludeDependenciesFilters(dependentIncluded, dependenciesScope);
            included.addAll(dependentIncluded);
        }
        return WorkspaceFiltersExtractor.createFilters(included);
    }

    private static ArrayList<FilterTableElement> createFilters(Set<String> methodNameFilters) {
        ArrayList<FilterTableElement> result = new ArrayList<FilterTableElement>();
        for (String methodNameFilter : methodNameFilters) {
            result.add(new FilterTableElement(String.valueOf(methodNameFilter) + "*", "*", TraceMessages.INCLUDE));
        }
        return result;
    }

    private static void addProjectFilters(IProject project, Set<String> filters, boolean isVerbose) throws CoreException {
        if (!project.isAccessible()) {
            return;
        }
        IResource[] members = project.members();
        int i = 0;
        while (i < members.length) {
            WorkspaceFiltersExtractor.addResourceFilters(members[i], filters, isVerbose);
            ++i;
        }
    }

    private static void addResourceFilters(IResource resourse, Set<String> filters, boolean isVerbose) throws CoreException {
        if (resourse.isDerived()) {
            return;
        }
        if (resourse.getType() == 1) {
            WorkspaceFiltersExtractor.addFileFilters((IFile)resourse, filters, isVerbose);
        } else if (resourse.getType() == 2) {
            WorkspaceFiltersExtractor.addFolderFilters((IFolder)resourse, filters, isVerbose);
        }
    }

    private static void addFolderFilters(IFolder folder, Set<String> filters, boolean isVerbose) throws CoreException {
        IResource[] members = folder.members();
        int j = 0;
        while (j < members.length) {
            WorkspaceFiltersExtractor.addResourceFilters(members[j], filters, isVerbose);
            ++j;
        }
    }

    private static void addFileFilters(IFile file, Set<String> filters, boolean isVerbose) throws CoreException {
        IJavaElement element = JavaCore.create((IFile)file);
        if (element != null) {
            WorkspaceFiltersExtractor.addJavaElementFilter(element, filters, isVerbose);
        }
    }

    private static void addJavaElementFilter(IJavaElement element, Set<String> filters, boolean isVerbose) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                WorkspaceFiltersExtractor.addProjectFilters(((IJavaProject)element).getProject(), filters, isVerbose);
                break;
            }
            case 3: {
                WorkspaceFiltersExtractor.addPackageFragmentRootFilters((IPackageFragmentRoot)element, filters, isVerbose);
                break;
            }
            case 4: {
                WorkspaceFiltersExtractor.addPackageFragmentFilters((IPackageFragment)element, filters, isVerbose);
                break;
            }
            case 5: {
                WorkspaceFiltersExtractor.addCompilationUnitFilters((ICompilationUnit)element, filters, isVerbose);
                break;
            }
            case 6: {
                WorkspaceFiltersExtractor.addClassFileFilters((IClassFile)element, filters, isVerbose);
                break;
            }
            case 7: {
                WorkspaceFiltersExtractor.addTypeFilters((IType)element, filters, isVerbose);
                break;
            }
        }
    }

    private static void addPackageFragmentRootFilters(IPackageFragmentRoot root, Set<String> filters, boolean isVerbose) throws CoreException {
        IJavaElement[] children = root.getChildren();
        int i = 0;
        while (i < children.length) {
            WorkspaceFiltersExtractor.addJavaElementFilter(children[i], filters, isVerbose);
            ++i;
        }
    }

    private static void addClassFileFilters(IClassFile file, Set<String> filters, boolean isVerbose) throws JavaModelException {
        WorkspaceFiltersExtractor.addTypeFilters(file.getType(), filters, isVerbose);
    }

    private static void addTypeFilters(IType type, Set<String> filters, boolean isVerbose) {
        IPackageFragment pack = type.getPackageFragment();
        if (!pack.isDefaultPackage()) {
            if (isVerbose) {
                filters.add(String.valueOf(pack.getElementName()) + "." + type.getElementName());
            } else {
                filters.add(pack.getElementName());
            }
        } else {
            filters.add(type.getTypeQualifiedName());
        }
    }

    private static void addCompilationUnitFilters(ICompilationUnit unit, Set<String> filters, boolean isVerbose) throws JavaModelException {
        try {
            IType[] elements = unit.getAllTypes();
            int i = 0;
            while (i < elements.length) {
                WorkspaceFiltersExtractor.addTypeFilters(elements[i], filters, isVerbose);
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private static void addPackageFragmentFilters(IPackageFragment fragment, Set<String> filters, boolean isVerbose) throws JavaModelException {
        if (!fragment.hasSubpackages() && !isVerbose) {
            filters.add(fragment.getElementName());
        }
        ICompilationUnit[] children = fragment.getCompilationUnits();
        int i = 0;
        while (i < children.length) {
            WorkspaceFiltersExtractor.addCompilationUnitFilters(children[i], filters, isVerbose);
            ++i;
        }
    }

    private static Set<String> getDependenciesScope(IWorkingSet[] workingSets) throws CoreException {
        HashSet<String> result = new HashSet<String>();
        if (workingSets == null || workingSets.length == 0) {
            return result;
        }
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IJavaElement javaElement = (IJavaElement)elements[j].getAdapter(IJavaElement.class);
                if (javaElement != null) {
                    WorkspaceFiltersExtractor.addJavaElementFilter(javaElement, result, true);
                } else {
                    IResource resource = (IResource)elements[j].getAdapter(IResource.class);
                    if (resource != null) {
                        WorkspaceFiltersExtractor.addResourceFilters(resource, result, true);
                    }
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Set<String> excludeDependenciesFilters(Set<String> included, Set<String> scope) {
        if (scope.isEmpty()) {
            return included;
        }
        HashSet<String> result = new HashSet<String>();
        for (String element : included) {
            if (scope.contains(element)) {
                result.add(element);
                continue;
            }
            result.addAll(WorkspaceFiltersExtractor.getContainingSubstring(scope, element));
        }
        return result;
    }

    private static List<String> getContainingSubstring(Set<String> scope, String substring) {
        ArrayList<String> result = new ArrayList<String>();
        for (String element : scope) {
            if (!element.startsWith(substring)) continue;
            result.add(element);
        }
        return result;
    }
}

