/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspacePluginAppExtractor {
    private static List<String> parsePDEProjectList(String s) {
        ArrayList<String> result = new ArrayList<String>();
        String[] rawProjectArray = s.split(",");
        int x = 0;
        while (x < rawProjectArray.length) {
            String str;
            int c = rawProjectArray[x].indexOf("@");
            if (c != -1 && (str = rawProjectArray[x].substring(0, c)).trim().length() != 0) {
                result.add(str);
            }
            ++x;
        }
        return result;
    }

    private static List<IJavaProject> convertStringListToJavaProjectList(List<String> l) {
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
        for (String name : l) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
            IJavaProject element = JavaCore.create((IProject)project);
            if (!(element instanceof IJavaProject)) continue;
            result.add(element);
        }
        return result;
    }

    public static List<IJavaProject> getJavaProjectList(ILaunchConfiguration configuration, boolean restrictResultsToWorkspacePlugins) {
        ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
        try {
            boolean useDefault = configuration.getAttribute("default", true);
            if (useDefault) {
                IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
                if (model != null) {
                    IJavaProject[] projects;
                    IJavaProject[] iJavaProjectArray = projects = model.getJavaProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaProject p = iJavaProjectArray[n2];
                        result.add(p);
                        ++n2;
                    }
                }
            } else {
                String selectedFromPDE = restrictResultsToWorkspacePlugins ? configuration.getAttribute("selected_workspace_plugins", "") : configuration.getAttribute("selected_target_plugins", "");
                List<String> selProjList = WorkspacePluginAppExtractor.parsePDEProjectList(selectedFromPDE);
                result.addAll(WorkspacePluginAppExtractor.convertStringListToJavaProjectList(selProjList));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

