/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.hyades.execution.local.CommunicationDebug;
import org.eclipse.hyades.loaders.util.BinaryLoader;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.util.provisional.ITraceModelInteraction;
import org.eclipse.hyades.models.util.provisional.TraceModelInteraction;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.PDProjectViewer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceLocationUI;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceFilterUI;
import org.eclipse.hyades.trace.ui.internal.wizard.ImportTraceRangeUI;
import org.eclipse.hyades.trace.ui.internal.wizard.TraceWizardMessages;
import org.eclipse.hyades.ui.util.GridUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.platform.common.ui.internal.CommonUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportTracePage1
extends WizardDataTransferPage
implements Listener,
ModifyListener,
SelectionListener,
IRunnableWithProgress {
    protected Button sourceBrowseButton;
    protected String fError;
    protected String fInputLog = "";
    protected TRCMonitor fMonitor;
    protected Text sourceNameField;
    protected TraceLocationUI _location;
    protected double fStartPercentage;
    protected double fStopPercentage;
    private Shell shell;
    private long logLength;
    private int collectionMode = 0;
    protected TabFolder details;
    protected TabItem rangeTab;
    protected ImportTraceRangeUI rangeUI;
    protected TabItem filterTab;
    protected ImportTraceFilterUI filterUI;
    private boolean rootElementRequired;
    private final Object importJobLock = new Object();

    public ImportTracePage1(IWorkbench aWorkbench, IStructuredSelection selection) {
        super("xmlTraceFileImportPage1");
        this.setTitle(TraceMessages.IMP_XMLPT);
        this.setDescription(TraceMessages.IMP_XMLPD);
        this.setImageDescriptor(PDPluginImages.getImageDescriptor("import_profilefile_wiz.gif"));
        this.shell = aWorkbench.getActiveWorkbenchWindow().getShell();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createSourceGroup(composite);
        this.createSpacer(composite);
        this.createBoldLabel(composite, TraceMessages.IMP_XML_SRC);
        this._location = new TraceLocationUI();
        this._location.createControl(composite);
        this._location.getLocationLabel().setText(TraceMessages.IMP_FLD);
        this.createSpacer(composite);
        this.details = new TabFolder(composite, 0);
        GridData data = GridUtil.createFill();
        this.details.setLayoutData((Object)data);
        this.details.addSelectionListener((SelectionListener)this);
        this.rangeTab = new TabItem(this.details, 0);
        this.rangeTab.setText(TraceMessages.IM_TRRAN);
        this.rangeUI = new ImportTraceRangeUI((WizardPage)this);
        this.rangeTab.setControl((Control)this.rangeUI.createControl((Composite)this.details));
        this.filterTab = new TabItem(this.details, 0);
        this.filterTab.setText(TraceMessages.IM_TRFIL);
        this.filterUI = new ImportTraceFilterUI(this.getFilterScope());
        this.filterTab.setControl((Control)this.filterUI.createControl((Composite)this.details));
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
        PDProjectExplorer projectExplorer = null;
        PDProjectViewer projectViewer = null;
        IWorkbenchPage page = UIPlugin.getActiveWorkbenchWindow().getActivePage();
        if (page != null && page.getPerspective().getId().equals("org.eclipse.hyades.trace.internal.ui.tracePerspective")) {
            projectExplorer = UIPlugin.getDefault().getViewer();
        }
        IProject selectionProject = null;
        TRCMonitor selectionMonitor = null;
        if (projectExplorer != null) {
            projectViewer = (PDProjectViewer)projectExplorer.getViewer();
        }
        if (projectViewer != null) {
            selectionProject = projectViewer.getSelectionProject();
            selectionMonitor = projectViewer.getSelectionMonitor();
        }
        this._location.getLocation().addModifyListener((ModifyListener)this);
        this._location.getMonitor().addModifyListener((ModifyListener)this);
        this.sourceNameField.addModifyListener((ModifyListener)this);
        if (selectionProject != null) {
            this._location.setLocation(selectionProject.getName());
        }
        if (selectionMonitor != null) {
            this._location.setMonitor(selectionMonitor.getName());
        }
        this.rangeUI.getshowHeapStatistic().addSelectionListener((SelectionListener)this);
        this.rangeUI.getshowExecStatistic().addSelectionListener((SelectionListener)this);
        this.rangeUI.getshowExecFlow().addSelectionListener((SelectionListener)this);
        this.rangeUI.getWholeFileBtn().addSelectionListener((SelectionListener)this);
        this.rangeUI.getInRangeBtn().addSelectionListener((SelectionListener)this);
        this.rangeUI.getstartText().addModifyListener((ModifyListener)this);
        this.rangeUI.getstopText().addModifyListener((ModifyListener)this);
    }

    private String getFilterScope() {
        return "ImportTraceScope";
    }

    public boolean finish() {
        this.fInputLog = this.sourceNameField.getText().trim();
        File log = new File(this.sourceNameField.getText().trim());
        if (!log.exists()) {
            this.fError = NLS.bind((String)TraceMessages.ERR_XMLNF, (Object)this.fInputLog);
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            return false;
        }
        if (!log.canRead()) {
            this.fError = NLS.bind((String)TraceMessages.ERR_XMLRD, (Object)this.fInputLog);
            Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            return false;
        }
        this.fError = null;
        if (this.rangeUI.getInRangeSelection()) {
            this.fStartPercentage = this.rangeUI.getStartRange();
            this.fStopPercentage = this.rangeUI.getStopRange();
        } else {
            this.fStartPercentage = 0.0;
            this.fStopPercentage = 100.0;
        }
        return this.loadXMLTrace();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
    }

    public void modifyText(ModifyEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    private void prepareAndImport(IProgressMonitor mon, File log, InputStream checkStream, InputStream readStream, String fullFilename) throws IOException {
        byte[] magic = new byte[10];
        if (checkStream.read(magic) < 0) {
            throw new IOException("Empty or invalid file - no magic exists");
        }
        XMLLoader processor = null;
        if (PDCoreUtil.isTBFFile(magic)) {
            this.logLength = log.length();
            processor = this.getNewProcessor(true);
            processor.setCollectionMode(this.collectionMode);
            this.importFile(mon, processor, log, readStream, fullFilename, true);
        } else if (PDCoreUtil.isXMLFile(magic)) {
            this.logLength = log.length();
            processor = this.getNewProcessor(false);
            processor.setCollectionMode(this.collectionMode);
            this.importFile(mon, processor, log, readStream, fullFilename, false);
        } else {
            throw new IOException("Invalid trace file format. Supported formats are XML and TBF (binary)");
        }
        if (CommunicationDebug.INSTANCE.debugUseEventMode) {
            processor.cleanUp();
        }
    }

    public void run(IProgressMonitor mon) {
        Display d = Display.getDefault();
        d.syncExec(new Runnable(){

            public void run() {
                if (ImportTracePage1.this.rangeUI.getshowHeapStatistic().getSelection()) {
                    ImportTracePage1.this.collectionMode = 0;
                } else if (ImportTracePage1.this.rangeUI.getshowThreadStatistic().getSelection()) {
                    ImportTracePage1.this.collectionMode = 6;
                } else if (ImportTracePage1.this.rangeUI.getshowExecStatistic().getSelection()) {
                    ImportTracePage1.this.collectionMode = 3;
                } else if (ImportTracePage1.this.rangeUI.getshowExecFlow().getSelection()) {
                    ImportTracePage1.this.collectionMode = 2;
                }
            }
        });
        try {
            File log = new File(this.fInputLog);
            if (PDCoreUtil.isZipFile((String)this.fInputLog)) {
                ZipFile zf = new ZipFile(log);
                Enumeration<? extends ZipEntry> entries = zf.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry zipEntry = entries.nextElement();
                    this.logLength = zipEntry.getSize();
                    if (this.logLength < log.length()) {
                        this.logLength = Long.MAX_VALUE;
                    }
                    this.prepareAndImport(mon, log, zf.getInputStream(zipEntry), zf.getInputStream(zipEntry), zipEntry.getName());
                }
            } else {
                this.prepareAndImport(mon, log, new BufferedInputStream(new FileInputStream(log)), new BufferedInputStream(new FileInputStream(log)), log.getAbsolutePath());
            }
        }
        catch (IOException e) {
            this.fError = NLS.bind((String)TraceMessages.IMP_IOEXC, (Object)e.getMessage());
        }
    }

    private XMLLoader getNewProcessor(boolean binary) {
        BinaryLoader processor = null;
        if (binary) {
            processor = new BinaryLoader(this.fMonitor);
            processor.setLoadXml(false);
        } else {
            processor = new XMLLoader(this.fMonitor);
        }
        if (this.filterUI.getSelectedFilter() != null) {
            processor.getContext().setImportFilter(this.filterUI.getSelectedFilter());
            processor.getContext().getFilterEngine().init();
        }
        return processor;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected boolean allowNewContainerName() {
        return true;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        GridData data = new GridData(256);
        data.widthHint = this.convertHorizontalDLUsToPixels(63);
        button.setLayoutData((Object)data);
        button.setData((Object)new Integer(id));
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        button.setFont(parent.getFont());
        return button;
    }

    protected void createSourceGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        new Label(sourceContainerGroup, 0).setText(TraceMessages.IMP_XML_SR);
        this.sourceNameField = new Text(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(TraceMessages.BROWSE4);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceNameField.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(UIPlugin.getPluginId()) + ".xmli0000");
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        FileDialog dlg = new FileDialog(this.sourceNameField.getShell());
        dlg.setFilterPath(currentSource);
        dlg.setFilterExtensions(new String[]{"*.trcxml", "*.trcbin", "*.*"});
        dlg.open();
        String fileName = dlg.getFileName();
        if (fileName != null && !fileName.equals("")) {
            this.sourceNameField.setText(String.valueOf(dlg.getFilterPath()) + File.separator + fileName);
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected boolean validateOptionsGroup() {
        return !this._location.getLocation().getText().trim().equals("") && !this._location.getMonitor().getText().trim().equals("") && (this.rangeUI.getWholeFileSelection() || this.rangeUI.getInRangeSelection() && this.rangeUI.checkRegionValue() == null);
    }

    protected boolean validateSourceGroup() {
        return !this.sourceNameField.getText().trim().equals("");
    }

    private String createModel(TRCMonitor monitor, String inputLog) {
        this.fMonitor = monitor;
        this.fInputLog = inputLog;
        try {
            this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return "";
        }
        catch (InvocationTargetException e) {
            return e.getTargetException().getMessage();
        }
        return this.fError;
    }

    private void handleOutOfMemoryError() {
        String text = TraceMessages.IOUTMEM_ERRT;
        if (this.shell != null) {
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            this.shell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)ImportTracePage1.this.shell, (String)TraceMessages.TRC_MSGT, (String)TraceMessages.OUTMEM_ERRT, (IStatus)err);
                }
            });
        }
    }

    /*
     * Exception decompiling
     */
    private void importFile(IProgressMonitor mon, XMLLoader processor, File log, InputStream readStream, String entryName, boolean binary) throws OutOfMemoryError {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK], 5[TRYBLOCK]], but top level block is 42[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean loadLine(int line, double position, double startLength, double endLength) {
        if (line <= 7) {
            return true;
        }
        return position >= startLength && position <= endLength;
    }

    private boolean loadXMLTrace() {
        IContainer res;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        boolean shouldSwitch = CommonUIPlugin.getDefault().openPerspectiveSwitchDialog(window.getShell(), "org.eclipse.hyades.trace.internal.ui.tracePerspective", CommonUIPlugin.getDefault().getPreferenceStore(), "switch_to_perspective", TraceWizardMessages.CONFIRM_PSWITCH);
        if (shouldSwitch) {
            UIPlugin.getActivePage();
        }
        if ("org.eclipse.hyades.trace.internal.ui.tracePerspective".equals(window.getActivePage().getPerspective().getId())) {
            try {
                PDProjectExplorer nav = (PDProjectExplorer)UIPlugin.getActivePage().showView("org.eclipse.hyades.trace.internal.ui.PDProjectExplorer");
                nav.getViewer().refresh();
            }
            catch (Exception e) {
                CommonPlugin.logError((Throwable)e);
            }
        }
        if ((res = PDCoreUtil.createContainer((IPath)new Path(this._location.getLocation().getText().trim()))) == null) {
            return false;
        }
        TRCMonitor mon = PDCoreUtil.createMonitor((IContainer)res, (String)this._location.getMonitor().getText().trim());
        this.fError = this.createModel(mon, this.sourceNameField.getText().trim());
        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource(null);
        event.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        if (this.fError != null) {
            if (!this.fError.equals("")) {
                Status err1 = new Status(2, "org.eclipse.core.resources", 566, this.fError, null);
                ErrorDialog.openError((Shell)this.getShell(), (String)TraceMessages.TRC_MSGT, (String)TraceMessages.ERR_LXML, (IStatus)err1);
            }
            return false;
        }
        ITraceModelInteraction[] contributors = TraceModelInteraction.getContributors();
        if (contributors != null && contributors.length > 0) {
            ITraceModelInteraction[] iTraceModelInteractionArray = contributors;
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ITraceModelInteraction contributor = iTraceModelInteractionArray[n2];
                contributor.traceModelLoad(mon.eResource());
                ++n2;
            }
        }
        return true;
    }

    public void setTraceFile(String fullPath) {
        this.sourceNameField.setText(fullPath);
    }

    static final class FileInfo {
        InputStream inputStream;
        long fileLength;

        FileInfo() {
        }
    }
}

