/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.List;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileOverviewUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSet;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage1;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage2;
import org.eclipse.hyades.trace.ui.internal.wizard.ProfileSetWizardPage3;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbench;

public abstract class ProfileSetWizard
extends Wizard {
    private ProfileSetWizardPage1 wizPage1;
    private ProfileSetWizardPage2 wizPage2;
    private ProfileSetWizardPage3 wizPage3;
    private ProfilingSetsManagerCopy original;
    private ProfilingSetsManagerCopy copy;
    private String _name;
    private ProfilingSet set;
    private TraceProfileOverviewUI _overviewUI;

    public ProfileSetWizard(TraceProfileOverviewUI overviewUI) {
        this.original = overviewUI.getManagerCopy();
        this.copy = this.original.createCopy();
        this._overviewUI = overviewUI;
    }

    public void initializeSet(ProfilingSet profilingSet) {
        this.set = profilingSet;
        this.copy.setDefaultSet(this.set);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected abstract String getSetId();

    public boolean profileNameExists(String name) {
        if (this._name != null && name.equals(this._name.trim())) {
            return false;
        }
        for (ProfilingSet next : this.copy.getProfilingSets().values()) {
            if (this.set != null && (this.set == null || this.set.getId().equals(next.getId())) || !name.equals(next.getDisplayName().trim())) continue;
            return true;
        }
        return false;
    }

    public void setProfileSetName(String name) {
        if (!this.set.getDisplayName().equals(name)) {
            this.set.setName(name);
        }
    }

    public void setProfileSetDescription(String description) {
        if (!this.set.getDisplayDescription().equals(description)) {
            this.set.setDescription(description);
        }
    }

    public void setNameToPages() {
        this.wizPage2.setProfilingSetName(this.set.getDisplayName());
    }

    public boolean performFinish() {
        if (!this.validateFilterPatterns(this.copy.getDefaultFilterSet().getChildren())) {
            return false;
        }
        this.original.resetFrom(this.copy);
        this.original.applyChanges();
        this._overviewUI.dataChanged();
        this._overviewUI.getTableViewer().refresh(true);
        this._overviewUI.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)this.set));
        return true;
    }

    public ProfilingSetsManagerCopy getProfilingSetsManagerCopy() {
        return this.copy;
    }

    public void addPages() {
        super.addPages();
        this.wizPage1 = new ProfileSetWizardPage1("name", this.set.getDisplayName(), this.set.getDisplayDescription(), this.copy);
        this.wizPage1.setTitle(TraceMessages.APRFS_ND);
        this.wizPage1.setDescription(TraceMessages.APRFS_N);
        this.addPage((IWizardPage)this.wizPage1);
        this.wizPage2 = new ProfileSetWizardPage2("profilingTypes", this.set.getDisplayName(), this.copy, this._overviewUI);
        this.wizPage2.setTitle(TraceMessages.EPRFS_D);
        this.wizPage2.setDescription(TraceMessages.EPRF_D);
        this.addPage((IWizardPage)this.wizPage2);
        this.wizPage3 = new ProfileSetWizardPage3("filters", this._overviewUI);
        this.wizPage3.setTitle(TraceMessages.EFS);
        this.wizPage3.setDescription(TraceMessages.EFS_DE);
        this.addPage((IWizardPage)this.wizPage3);
    }

    private boolean isBadFilterPattern(String filterStr) {
        if (filterStr.length() <= 1) {
            return false;
        }
        if (filterStr.indexOf(42) != filterStr.lastIndexOf(42)) {
            return true;
        }
        return filterStr.substring(1, filterStr.length() - 1).indexOf(42) >= 0;
    }

    private boolean validateFilterPatterns(List filterList) {
        String badFilters = "";
        String nl = System.getProperty("line.separator");
        if (filterList != null) {
            int i = 0;
            while (i < filterList.size()) {
                FilterTableElement fte = (FilterTableElement)filterList.get(i);
                if (this.isBadFilterPattern(fte.getText())) {
                    badFilters = String.valueOf(badFilters) + fte.getText() + nl;
                }
                if (this.isBadFilterPattern(fte.getMethod())) {
                    badFilters = String.valueOf(badFilters) + fte.getMethod() + nl;
                }
                ++i;
            }
        }
        if ("".equals(badFilters)) {
            return true;
        }
        String message = TraceMessages.ST_FLTPW;
        message = String.valueOf(message) + nl + nl + badFilters;
        message = String.valueOf(message) + nl + TraceMessages.ST_FLTPWC;
        String[] buttons = new String[]{UIPlugin.getResourceString(TraceMessages.ST_FLTPWY), UIPlugin.getResourceString(TraceMessages.ST_FLTPWN)};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), TraceMessages.ST_FLTPWT, null, message, 4, buttons, 0);
        messageDialog.create();
        return messageDialog.open() == 0;
    }
}

