/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.control.provider.application;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;

public class AgentDiscovererControlProvider
extends AbstractAgentControlProvider {
    private IAgentStateModifier agentStateModifier = new LogAgentStateModifier();

    public IAgentStateModifier getAgentStateModifier() {
        return this.agentStateModifier;
    }

    protected IControlItem createAttachControlItem() {
        return null;
    }

    protected IControlItem createDetachControlItem() {
        return null;
    }

    protected IControlItem createPropertiesControlItem() {
        return null;
    }

    protected static class LogAgentStateModifier
    implements IAgentStateModifier {
        private StructuredSelection input;

        protected LogAgentStateModifier() {
        }

        public void detach() throws CoreException {
        }

        public void attach() throws CoreException {
        }

        public void startMonitoring() throws CoreException {
            this.changeAgentState(true);
        }

        private void changeAgentState(boolean monitor) {
            Iterator agents = this.input.iterator();
            while (agents.hasNext()) {
                this.doAction((TRCAgentProxy)agents.next(), monitor);
            }
        }

        private void doAction(TRCAgentProxy agentProxy, boolean monitor) {
            agentProxy.setMonitored(monitor);
            agentProxy.setAttached(true);
            agentProxy.setActive(true);
            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
            event.setSource((Object)agentProxy);
            if (monitor) {
                event.setType(1);
            } else {
                event.setType(2);
            }
            UIPlugin.getDefault().notifyProfileEventListener(event);
        }

        public void pauseMonitoring() throws CoreException {
            this.changeAgentState(false);
        }

        public boolean canAttach() {
            return false;
        }

        public boolean canDetach() {
            return false;
        }

        public boolean canPause() {
            return this.isOptionEnabled(true);
        }

        public boolean canResume() {
            return this.isOptionEnabled(false);
        }

        private boolean isOptionEnabled(boolean monitor) {
            boolean isEnabled = true;
            Iterator agents = this.input.iterator();
            while (isEnabled && agents.hasNext()) {
                TRCAgentProxy agentProxy;
                Object element = agents.next();
                boolean bl = isEnabled = isEnabled && element instanceof TRCAgentProxy && (agentProxy = (TRCAgentProxy)element).isActive() && agentProxy.isMonitored() == monitor;
            }
            return isEnabled;
        }

        public void setInput(StructuredSelection input) {
            this.input = input;
        }
    }
}

