/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.util.AbstractChangeable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tptp.platform.common.ui.trace.internal.CommonUITraceImages;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.application.IDiscovererLaunchConfConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class AgentDiscovererConfiguration
extends AbstractConfiguration {
    public static final int DEFAULT_FREQUENCY = 500;
    public static final String DEFAULT_FILTERS = ".*,1";

    public AgentDiscovererConfiguration() {
        super(new Class[]{AgentDiscovererConfPage.class});
    }

    public static AgentDiscovererFilterEntry[] unserializeFilters(String filtersStr) {
        StringTokenizer filters = new StringTokenizer(filtersStr, ";");
        Vector<AgentDiscovererFilterEntry> filtersContainer = new Vector<AgentDiscovererFilterEntry>();
        while (filters.hasMoreTokens()) {
            StringTokenizer filterTokens = new StringTokenizer(filters.nextToken(), ",");
            if (filterTokens.countTokens() != 2) continue;
            filtersContainer.add(new AgentDiscovererFilterEntry(filterTokens.nextToken(), filterTokens.nextToken().equals("1")));
        }
        AgentDiscovererFilterEntry[] entries = new AgentDiscovererFilterEntry[filtersContainer.size()];
        filtersContainer.toArray(entries);
        return entries;
    }

    public static class AgentDiscovererConfPage
    extends AbstractChangeable
    implements AbstractConfiguration.IExtendedConfigurationPage,
    SelectionListener {
        private ILaunchConfiguration launchConfiguration;
        private Spinner frequencyValue;
        private Table filterTable;
        private CheckboxTableViewer tableViewer;
        private Button removeButton;
        private Button upButton;
        private Button downButton;
        private FilterList filterList;
        private static final String IMG_ITEM_PROP = "0";
        private static final String LOG_AGENT_PROP = "1";
        private static final String VISIBILITY_PROP = "2";

        public void reset(ILaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
        }

        public void createControl(Composite parent) {
            Composite optionComposite = new Composite(parent, 0);
            optionComposite.setLayout((Layout)new GridLayout());
            optionComposite.setLayoutData((Object)new GridData(4, -1, true, false));
            Group optionGroup = this.createGroup(optionComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_DISC_TITLE);
            this.createOptions(optionGroup);
            Composite filterGroupComposite = new Composite(parent, 0);
            GridLayout gl = new GridLayout();
            gl.marginTop = 30;
            filterGroupComposite.setLayout((Layout)gl);
            filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false));
            Group filterGroup = this.createGroup(filterGroupComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_DISC_DESC);
            this.createFilters(filterGroup);
            this.setButtonStatus(false);
        }

        private Group createGroup(Composite parent, String text) {
            Group group = new Group(parent, 0);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(4, -1, true, false));
            group.setText(text);
            return group;
        }

        private void createOptions(Group optionGroup) {
            int freqVal;
            Composite optionComposite = new Composite((Composite)optionGroup, 0);
            optionComposite.setLayout((Layout)new GridLayout(2, false));
            optionComposite.setLayoutData((Object)new GridData(4, -1, true, false));
            Label frequencyLabel = new Label(optionComposite, 0);
            frequencyLabel.setLayoutData((Object)new GridData(4, -1, true, false));
            frequencyLabel.setText(LauncherMessages.CONFIGURATION_LOG_AGENT_FREQUENCY);
            this.frequencyValue = new Spinner(optionComposite, 2048);
            GridData gd = new GridData(-1, -1, false, false);
            gd.widthHint = 100;
            this.frequencyValue.setLayoutData((Object)gd);
            this.frequencyValue.setIncrement(100);
            this.frequencyValue.setMaximum(20000000);
            this.frequencyValue.setMinimum(100);
            this.frequencyValue.setDigits(0);
            try {
                freqVal = this.launchConfiguration.getAttribute(IDiscovererLaunchConfConstants.ATTR_OPT_FREQUENCY, -1);
            }
            catch (CoreException coreException) {
                freqVal = 500;
            }
            if (freqVal < 0) {
                freqVal = 500;
            }
            this.frequencyValue.setSelection(freqVal);
            this.frequencyValue.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AgentDiscovererConfPage.this.changed();
                }
            });
        }

        private void createTable(Composite parent) {
            this.filterTable = new Table(parent, 68354);
            this.filterTable.setLinesVisible(true);
            GridData tableGD = new GridData(4, 4, true, true);
            tableGD.widthHint = 360;
            tableGD.heightHint = 70;
            this.filterTable.setLayoutData((Object)tableGD);
        }

        private void createColumns() {
            TableLayout layout = new TableLayout();
            this.filterTable.setLayout((Layout)layout);
            this.filterTable.setVisible(true);
            this.filterTable.addSelectionListener((SelectionListener)this);
            String[] headers = new String[]{"", UIPlugin.getResourceString(LauncherMessages.CONFIGURATION_LOG_AGENT_NAME), UIPlugin.getResourceString(LauncherMessages.CONFIGURATION_LOG_AGENT_VIS)};
            ColumnLayoutData[] layouts = new ColumnLayoutData[]{new ColumnPixelData(20, true), new ColumnPixelData(200, true), new ColumnPixelData(70, true)};
            TableColumn[] columns = new TableColumn[headers.length];
            int i = 0;
            while (i < headers.length) {
                layout.addColumnData(layouts[i]);
                TableColumn tc = new TableColumn(this.filterTable, 0, i);
                tc.setResizable(layouts[i].resizable);
                tc.setText(headers[i]);
                columns[i] = tc;
                ++i;
            }
        }

        private void setTableCellEditors() {
            CellEditor[] editors = new CellEditor[this.filterTable.getColumnCount()];
            editors[0] = new TextCellEditor((Composite)this.filterTable);
            editors[1] = new TextCellEditor((Composite)this.filterTable);
            editors[2] = new ComboBoxCellEditor((Composite)this.filterTable, new String[]{LauncherMessages.CONFIGURATION_LOG_AGENT_EXCLUDE, LauncherMessages.CONFIGURATION_LOG_AGENT_INCLUDE});
            this.tableViewer.setCellEditors(editors);
        }

        private void setTableCellModifier() {
            this.tableViewer.setCellModifier(new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return !property.equals(AgentDiscovererConfPage.IMG_ITEM_PROP);
                }

                public Object getValue(Object element, String property) {
                    TableItem[] tableItem = AgentDiscovererConfPage.this.filterTable.getSelection();
                    if (tableItem == null || tableItem.length != 1) {
                        return null;
                    }
                    if (property.equals(AgentDiscovererConfPage.LOG_AGENT_PROP)) {
                        return tableItem[0].getText(1);
                    }
                    if (property.equals(AgentDiscovererConfPage.VISIBILITY_PROP)) {
                        String tableItemTxt = tableItem[0].getText(2);
                        if (tableItemTxt.equals(LauncherMessages.CONFIGURATION_LOG_AGENT_EXCLUDE)) {
                            return new Integer(0);
                        }
                        if (tableItemTxt.equals(LauncherMessages.CONFIGURATION_LOG_AGENT_INCLUDE)) {
                            return new Integer(1);
                        }
                    }
                    return null;
                }

                public void modify(Object element, String property, Object value) {
                    TableItem[] tableItem = AgentDiscovererConfPage.this.filterTable.getSelection();
                    if (tableItem == null || tableItem.length != 1) {
                        return;
                    }
                    AgentDiscovererFilterEntry entry = (AgentDiscovererFilterEntry)AgentDiscovererConfPage.this.filterList.getFilterList().get(AgentDiscovererConfPage.this.filterTable.indexOf(tableItem[0]));
                    if (property.equals(AgentDiscovererConfPage.LOG_AGENT_PROP)) {
                        entry.setPattern((String)value);
                        tableItem[0].setText(1, (String)value);
                    } else if (property.equals(AgentDiscovererConfPage.VISIBILITY_PROP)) {
                        int visibility = (Integer)value;
                        entry.setVisibility(visibility == 1);
                        if (visibility == 0) {
                            tableItem[0].setText(2, LauncherMessages.CONFIGURATION_LOG_AGENT_EXCLUDE);
                        } else if (visibility == 1) {
                            tableItem[0].setText(2, LauncherMessages.CONFIGURATION_LOG_AGENT_INCLUDE);
                        }
                    }
                    AgentDiscovererConfPage.this.changed();
                }
            });
        }

        private void initializeTable(Composite parent) {
            this.createTable(parent);
            this.tableViewer = new CheckboxTableViewer(this.filterTable);
            this.createColumns();
            this.tableViewer.setContentProvider((IContentProvider)new ADContentProvider());
            this.tableViewer.setLabelProvider((IBaseLabelProvider)new ADLabelProvider());
            this.filterList = new FilterList();
            this.tableViewer.setInput((Object)this.filterList);
            this.setTableCellEditors();
            this.setTableCellModifier();
            this.tableViewer.setColumnProperties(new String[]{IMG_ITEM_PROP, LOG_AGENT_PROP, VISIBILITY_PROP});
            this.populateTable();
            this.tableViewer.refresh();
        }

        private void createFilters(Group filterGroup) {
            Composite filterComposite = new Composite((Composite)filterGroup, 0);
            filterComposite.setLayout((Layout)new GridLayout(2, false));
            filterComposite.setLayoutData((Object)new GridData(4, -1, true, false));
            this.initializeTable(filterComposite);
            Composite buttonComposite = new Composite(filterComposite, 0);
            buttonComposite.setLayout((Layout)new GridLayout());
            buttonComposite.setLayoutData((Object)new GridData(4, -1, true, false));
            this.createButton(buttonComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_ADD, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AgentDiscovererConfPage.this.createTableItem(".*", true, 0);
                    AgentDiscovererConfPage.this.updateButtons();
                    AgentDiscovererConfPage.this.changed();
                }
            });
            this.removeButton = this.createButton(buttonComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_REMOVE, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TableItem[] selectedItems = AgentDiscovererConfPage.this.filterTable.getSelection();
                    Object[] remainEntries = AgentDiscovererConfPage.this.filterList.getFilterList().toArray();
                    int indexOfFirstElement = -1;
                    if (selectedItems.length > 0) {
                        indexOfFirstElement = AgentDiscovererConfPage.this.filterTable.indexOf(selectedItems[0]);
                    }
                    int i = 0;
                    while (i < selectedItems.length) {
                        remainEntries[((AgentDiscovererConfPage)AgentDiscovererConfPage.this).filterTable.indexOf((TableItem)selectedItems[i])] = null;
                        ++i;
                    }
                    i = 0;
                    while (i < selectedItems.length) {
                        AgentDiscovererConfPage.this.filterTable.remove(AgentDiscovererConfPage.this.filterTable.indexOf(selectedItems[i]));
                        ++i;
                    }
                    AgentDiscovererConfPage.this.filterList.getFilterList().clear();
                    i = 0;
                    while (i < remainEntries.length) {
                        if (remainEntries[i] != null) {
                            AgentDiscovererConfPage.this.filterList.getFilterList().add((AgentDiscovererFilterEntry)remainEntries[i]);
                        }
                        ++i;
                    }
                    AgentDiscovererConfPage.this.tableViewer.refresh();
                    if (AgentDiscovererConfPage.this.filterTable.getItemCount() <= 0) {
                        AgentDiscovererConfPage.this.setButtonStatus(false);
                    }
                    if (indexOfFirstElement >= 0 && indexOfFirstElement < AgentDiscovererConfPage.this.filterTable.getItemCount()) {
                        AgentDiscovererConfPage.this.filterTable.setSelection(indexOfFirstElement);
                    }
                    AgentDiscovererConfPage.this.changed();
                    AgentDiscovererConfPage.this.updateButtons();
                }
            });
            this.upButton = this.createButton(buttonComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_UP, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AgentDiscovererConfPage.this.moveItem(true);
                }
            });
            this.downButton = this.createButton(buttonComposite, LauncherMessages.CONFIGURATION_LOG_AGENT_DOWN, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AgentDiscovererConfPage.this.moveItem(false);
                }
            });
            if (this.filterTable.getItemCount() <= 0) {
                this.setButtonStatus(false);
            }
        }

        private void setButtonStatus(boolean status) {
            this.removeButton.setEnabled(status);
            this.upButton.setEnabled(status);
            this.downButton.setEnabled(status);
        }

        private void moveItem(boolean upward) {
            TableItem[] selectedItems = this.filterTable.getSelection();
            int i = 0;
            while (i < selectedItems.length) {
                AgentDiscovererFilterEntry top;
                int inx = this.filterTable.indexOf(selectedItems[i]);
                if (upward) {
                    if (inx <= 0) {
                        return;
                    }
                    top = (AgentDiscovererFilterEntry)this.filterList.getFilterList().get(inx - 1);
                    this.filterList.getFilterList().remove(inx - 1);
                    this.filterList.getFilterList().add(inx, top);
                } else {
                    if (inx >= this.filterTable.getItemCount() - 1) {
                        return;
                    }
                    top = (AgentDiscovererFilterEntry)this.filterList.getFilterList().get(inx);
                    this.filterList.getFilterList().remove(inx);
                    this.filterList.getFilterList().add(inx + 1, top);
                }
                this.tableViewer.refresh();
                this.updateButtons();
                ++i;
            }
        }

        private Button createButton(Composite parent, String text, SelectionAdapter listener) {
            Button button = new Button(parent, 0);
            button.setLayoutData((Object)new GridData(4, -1, true, false));
            button.setText(text);
            button.addSelectionListener((SelectionListener)listener);
            return button;
        }

        private void populateTable() {
            String filtersStr = null;
            try {
                filtersStr = this.launchConfiguration.getAttribute(IDiscovererLaunchConfConstants.ATTR_FILTER, null);
            }
            catch (CoreException coreException) {}
            if (filtersStr == null || filtersStr.length() <= 0) {
                filtersStr = AgentDiscovererConfiguration.DEFAULT_FILTERS;
            }
            AgentDiscovererFilterEntry[] filters = AgentDiscovererConfiguration.unserializeFilters(filtersStr);
            int i = 0;
            while (i < filters.length) {
                this.filterList.getFilterList().add(filters[i]);
                ++i;
            }
        }

        private AgentDiscovererFilterEntry createTableItem(String logAgentName, boolean visibility, int inx) {
            AgentDiscovererFilterEntry entry = new AgentDiscovererFilterEntry(logAgentName, visibility);
            this.filterList.getFilterList().add(entry);
            this.tableViewer.refresh();
            return entry;
        }

        private AgentDiscovererFilterEntry createTableItem(String logAgentName, boolean visibility) {
            return this.createTableItem(logAgentName, visibility, this.filterTable.getItemCount());
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            String filters;
            int frequency = this.frequencyValue.getSelection();
            if (frequency > 0) {
                configurationWC.setAttribute(IDiscovererLaunchConfConstants.ATTR_OPT_FREQUENCY, frequency);
            }
            if ((filters = this.serializeFilters()) != null) {
                configurationWC.setAttribute(IDiscovererLaunchConfConstants.ATTR_FILTER, filters);
            }
            return true;
        }

        private String serializeFilters() {
            TableItem[] tableItems = this.filterTable.getItems();
            String filterStr = "";
            int i = 0;
            while (i < tableItems.length) {
                if (this.errorInFilterItem(tableItems[i]) == null) {
                    filterStr = String.valueOf(filterStr) + tableItems[i].getText(1) + "," + (tableItems[i].getText(2).equals(LauncherMessages.CONFIGURATION_LOG_AGENT_EXCLUDE) ? IMG_ITEM_PROP : LOG_AGENT_PROP) + ";";
                }
                ++i;
            }
            return filterStr;
        }

        public Vector getAttributes() {
            return null;
        }

        public String getPageName() {
            return this.getClass().getName();
        }

        public String getTitle() {
            return LauncherMessages.CONFIGURATION_LOG_AGENT_DISC_TITLE;
        }

        public ImageDescriptor getWizardBanner() {
            return TraceUIImages.INSTANCE.getImageDescriptor("log_wiz_ban.gif");
        }

        public String getDescription() {
            return LauncherMessages.CONFIGURATION_LOG_AGENT_DISC_DESC;
        }

        public void addErrorListener(final IStatusListener statusListener) {
            if (statusListener != null) {
                super.addListener(new Listener(){

                    public void handleEvent(Event event) {
                        String error = null;
                        if (AgentDiscovererConfPage.this.frequencyValue.getSelection() <= 0) {
                            statusListener.handleErrorEvent(LauncherMessages.ERROR_LOG_DISCOVER_FREQUENCY);
                        } else if (AgentDiscovererConfPage.this.filterTable.getItemCount() <= 0) {
                            statusListener.handleErrorEvent(LauncherMessages.ERROR_LOG_DISCOVER_NO_FILTER);
                        } else {
                            error = AgentDiscovererConfPage.this.errorInFilters();
                            if (error != null) {
                                statusListener.handleErrorEvent(error);
                            } else {
                                statusListener.handleOKEvent();
                            }
                        }
                    }
                });
            }
        }

        private String errorInFilters() {
            TableItem[] tableItems = this.filterTable.getItems();
            String error = null;
            int i = 0;
            while (i < tableItems.length) {
                error = this.errorInFilterItem(tableItems[i]);
                if (error != null) {
                    return error;
                }
                ++i;
            }
            return null;
        }

        private String errorInFilterItem(TableItem filterItem) {
            String agentName = filterItem.getText(1);
            String visibility = filterItem.getText(2);
            if (!this.validString(agentName) || !this.validString(visibility)) {
                return LauncherMessages.ERROR_LOG_DISCOVER_FILTER;
            }
            try {
                Pattern.compile(agentName);
            }
            catch (Exception e) {
                String exceptionMsg = e.getMessage();
                return String.valueOf(LauncherMessages.ERROR_LOG_DISCOVER_FILTER) + (exceptionMsg != null && exceptionMsg.length() > 0 ? " [" + exceptionMsg + "]" : "");
            }
            return null;
        }

        private boolean validString(String text) {
            return text != null && text.length() > 0 && text.indexOf(";") == -1 && text.indexOf(",") == -1;
        }

        public void updateButtons() {
            TableItem[] selectedItems = this.filterTable.getSelection();
            int minIndex = Integer.MAX_VALUE;
            int maxIndex = -1;
            if (selectedItems.length == 0) {
                this.setButtonStatus(false);
                return;
            }
            int i = 0;
            while (i < selectedItems.length) {
                int inx = this.filterTable.indexOf(selectedItems[i]);
                if (inx < minIndex) {
                    minIndex = inx;
                }
                if (inx > maxIndex) {
                    maxIndex = inx;
                }
                ++i;
            }
            this.setButtonStatus(true);
            if (minIndex == 0) {
                this.upButton.setEnabled(false);
            }
            if (maxIndex == this.filterTable.getItemCount() - 1) {
                this.downButton.setEnabled(false);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.updateButtons();
        }

        public class ADContentProvider
        implements IStructuredContentProvider {
            private CheckboxTableViewer fViewer;
            protected AgentDiscovererFilterEntry fChangedElement;

            public ADContentProvider() {
                this.fViewer = AgentDiscovererConfPage.this.tableViewer;
            }

            public Object[] getElements(Object inputElement) {
                return ((FilterList)inputElement).getFilterList().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }

        public class ADLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return CommonUITraceImages.INSTANCE.getImage("agent_obj.gif");
                }
                return null;
            }

            public Image getColumnImage(Viewer viewer, Object element, int columnIndex) {
                return this.getColumnImage(element, columnIndex);
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 0) {
                    return "";
                }
                if (columnIndex == 1) {
                    return ((AgentDiscovererFilterEntry)element).getAgentName();
                }
                if (columnIndex == 2) {
                    return ((AgentDiscovererFilterEntry)element).getVisibility() ? LauncherMessages.CONFIGURATION_LOG_AGENT_INCLUDE : LauncherMessages.CONFIGURATION_LOG_AGENT_EXCLUDE;
                }
                return "";
            }

            public String getColumnText(Viewer viewer, Object element, int columnIndex) {
                return this.getColumnText(element, columnIndex);
            }
        }

        private class FilterList {
            private List fList = new ArrayList();

            private FilterList() {
            }

            public List getFilterList() {
                return this.fList;
            }
        }
    }

    public static class AgentDiscovererFilterEntry {
        public static final int INCLUDE = 0;
        public static final int EXCLUDE = 1;
        public static final int INDETERMINATE = 2;
        private String logAgentName;
        private Pattern logAgentNamePattern;
        private boolean visibility;

        public AgentDiscovererFilterEntry(String logAgName, boolean vis) {
            try {
                this.logAgentNamePattern = Pattern.compile(logAgName);
                this.logAgentName = logAgName;
                this.visibility = vis;
            }
            catch (Exception exception) {
                this.logAgentNamePattern = null;
            }
        }

        public void setPattern(String logAgName) {
            try {
                this.logAgentNamePattern = Pattern.compile(logAgName);
                this.logAgentName = logAgName;
            }
            catch (Exception exception) {
                this.logAgentNamePattern = null;
            }
        }

        public void setVisibility(boolean vis) {
            this.visibility = vis;
        }

        public boolean getVisibility() {
            return this.visibility;
        }

        public String getAgentName() {
            return this.logAgentName;
        }

        public int match(String logAgName) {
            if (this.logAgentName == null) {
                return 1;
            }
            try {
                Matcher m = this.logAgentNamePattern.matcher(logAgName);
                boolean matches = m.matches();
                return !matches ? 2 : (this.visibility ? 0 : 1);
            }
            catch (Exception exception) {
                return 1;
            }
        }
    }
}

