/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceFilterManager;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileFiltersUI;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.FilterSetElement;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class FilterConfigurationPage
implements AbstractConfiguration.IExtendedConfigurationPage {
    private TraceProfileFiltersUI filterUI = this.createFilterUI();
    private ILaunchConfiguration launchConfiguration;
    private String attributeName;

    public FilterConfigurationPage() {
        this(IProfileLaunchConfigurationConstants.ATTR_FILTER_SET);
    }

    public FilterConfigurationPage(String attributeName) {
        this.attributeName = attributeName;
    }

    public void reset(ILaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    public Vector getAttributes() {
        Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
        try {
            String filterSetId = this.launchConfiguration.getAttribute(this.attributeName, this.getDefautltFilterSet());
            options.addElement(new DataCollectionEngineAttribute("SETOPTION_" + this.attributeName, filterSetId));
            FilterSetElement filterSet = (FilterSetElement)TraceFilterManager.getInstance().getFilterSet().get(filterSetId);
            if (filterSet == null) {
                return options;
            }
            ArrayList filterElements = filterSet.getChildren();
            if (filterElements == null) {
                return options;
            }
            int i = 0;
            int filterElementCount = filterElements.size();
            while (i < filterElementCount) {
                FilterTableElement filterElement = (FilterTableElement)filterElements.get(i);
                String value = filterElement.getVisibility().equals(TraceMessages.INCLUDE) ? "INCLUDE" : "EXCLUDE";
                options.add(new DataCollectionEngineAttribute(filterElement.getMethod().length() <= 0 ? "SETFILTER" + filterElement.getText() : "SETMETHODFILTER" + filterElement.getText() + ' ' + filterElement.getMethod(), value));
                ++i;
            }
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
        }
        return options;
    }

    protected String getDefautltFilterSet() {
        return "org.eclipse.hyades.trace.ui.filterSet.default";
    }

    public boolean storeAttributes(ILaunchConfigurationWorkingCopy workingCopy) {
        TraceFilterManager.getInstance().storeFilterSetList(this.filterUI.getFilterSet());
        workingCopy.setAttribute(this.attributeName, this.filterUI.getActiveFilterSet());
        return true;
    }

    public void createControl(Composite parent) {
        this.filterUI.resetFields();
        this.filterUI.createControl(parent);
        if (this.launchConfiguration == null) {
            return;
        }
        this.filterUI.setFilterSet(TraceFilterManager.getInstance().getFilterSetCopy());
        String activeFilterSetId = null;
        FilterSetElement activeFilterSet = null;
        if (this.launchConfiguration != null) {
            try {
                activeFilterSetId = this.launchConfiguration.getAttribute(this.attributeName, "org.eclipse.hyades.trace.ui.filterSet.default");
            }
            catch (CoreException coreException) {}
        }
        FilterSetElement filterSetElement = activeFilterSet = activeFilterSetId == null ? null : this.findFilterSet(activeFilterSetId);
        if (activeFilterSet == null) {
            FilterSetElement nextAvailableFilterSet = ProfilingSetsManager.instance().findNextAvailableFilterSet();
            FilterSetElement filterSetElement2 = activeFilterSet = nextAvailableFilterSet == null ? null : this.findFilterSet(nextAvailableFilterSet.getId());
        }
        if (activeFilterSet != null) {
            this.filterUI.setActiveFilterSet(activeFilterSet);
        }
    }

    protected FilterSetElement findFilterSet(String activeFilterSetId) {
        ArrayList filterList = this.filterUI.getFilterSet();
        int i = 0;
        int listCount = filterList.size();
        while (i < listCount) {
            FilterSetElement fse = (FilterSetElement)filterList.get(i);
            if (fse.getId().equals(activeFilterSetId)) {
                return fse;
            }
            ++i;
        }
        return null;
    }

    public String getPageName() {
        return this.getClass().getName();
    }

    public String getTitle() {
        return TraceMessages.EFS;
    }

    public ImageDescriptor getWizardBanner() {
        return TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif");
    }

    public String getDescription() {
        return TraceMessages.EFS_DE;
    }

    public void addErrorListener(IStatusListener statusListener) {
        statusListener.handleOKEvent();
    }

    public TraceProfileFiltersUI getFilterUI() {
        return this.filterUI;
    }

    public ILaunchConfiguration getLaunchConfiguration() {
        return this.launchConfiguration;
    }

    protected TraceProfileFiltersUI createFilterUI() {
        return new TraceProfileFiltersUI();
    }
}

