/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.application;

import java.util.Vector;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.trace.ui.internal.launcher.application.AbstractConfiguration;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.DataCollectionEngineAttribute;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class PIMemoryAnalysisConf
extends AbstractConfiguration {
    public PIMemoryAnalysisConf() {
        super(new Class[]{MemoryConfigurationPage.class});
    }

    public static class MemoryConfigurationPage
    extends AbstractConfiguration.ExtendedConfigurationPage {
        private ILaunchConfiguration launchConfiguration;
        private Button collectInstanceCheckBox;
        private boolean collectInstanceLevel;
        private boolean controlsCreated;

        public void reset(ILaunchConfiguration launchConfiguration) {
            this.launchConfiguration = launchConfiguration;
            try {
                this.collectInstanceLevel = launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_EXEC_INSTANCES, false);
            }
            catch (Exception e) {
                UIPlugin.getDefault().log(e);
            }
        }

        public void createControl(Composite parent) {
            this.controlsCreated = true;
            Group memoryAnalysisOptGroup = new Group(parent, 0);
            memoryAnalysisOptGroup.setLayout((Layout)new GridLayout());
            memoryAnalysisOptGroup.setLayoutData((Object)new GridData(4, -1, true, false));
            memoryAnalysisOptGroup.setText(LauncherMessages.CONFIGURATION_MEM_GROUP_TITLE);
            this.collectInstanceCheckBox = new Button((Composite)memoryAnalysisOptGroup, 32);
            this.collectInstanceCheckBox.setText(TraceMessages.SH_INSTLI);
            Label info = new Label((Composite)memoryAnalysisOptGroup, 64);
            GridData data = new GridData();
            data.widthHint = 375;
            data.verticalIndent = 10;
            info.setLayoutData((Object)data);
            info.setForeground(Display.getCurrent().getSystemColor(3));
            info.setText(TraceMessages.INSTL_INFO);
            if (this.launchConfiguration != null) {
                try {
                    this.collectInstanceCheckBox.setSelection(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, false));
                }
                catch (Exception e) {
                    LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, LauncherMessages.ERROR_CONFIG_RESTORE, e);
                    this.collectInstanceCheckBox.setSelection(false);
                }
            }
        }

        public String getPageName() {
            return this.getClass().getName();
        }

        public String getTitle() {
            return UIPlugin.getResourceString("memoryType");
        }

        public ImageDescriptor getWizardBanner() {
            return TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif");
        }

        public String getDescription() {
            return LauncherMessages.CONFIGURATION_MEM_ANALYSIS_DESC;
        }

        public void addErrorListener(IStatusListener statusListener) {
            statusListener.handleOKEvent();
        }

        public boolean storeAttributes(ILaunchConfigurationWorkingCopy configurationWC) {
            configurationWC.setAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, this.controlsCreated ? this.collectInstanceCheckBox.getSelection() : this.collectInstanceLevel);
            return true;
        }

        public Vector getAttributes() {
            Vector<DataCollectionEngineAttribute> options = new Vector<DataCollectionEngineAttribute>();
            try {
                String[][] heapData = Options.OPTIONS_ANALYZE_HEAP;
                int idx = 0;
                while (idx < heapData.length) {
                    options.add(new DataCollectionEngineAttribute("SETOPTION_" + heapData[idx][0], heapData[idx][1]));
                    ++idx;
                }
                String showHeap = String.valueOf(this.launchConfiguration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, false));
                options.add(new DataCollectionEngineAttribute(IProfileLaunchConfigurationConstants.ATTR_SHOW_HEAP_INSTANCES, showHeap));
            }
            catch (Exception e) {
                LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_LAUNCH_ATTRIBUTES, e);
            }
            return options;
        }
    }
}

