/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AgentDeclaration;

public class AgentDeclarationManager {
    private static AgentDeclarationManager agentDeclarationMgr;
    private Hashtable agentDeclarations = new Hashtable();

    private AgentDeclarationManager() {
        this.initialize();
    }

    public static AgentDeclarationManager getInstance() {
        if (agentDeclarationMgr == null) {
            agentDeclarationMgr = new AgentDeclarationManager();
        }
        return agentDeclarationMgr;
    }

    private void initialize() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.hyades.trace.ui.agentDeclaration");
        int i = 0;
        while (i < elements.length) {
            AgentDeclaration agentDeclaration;
            if ("agent".equalsIgnoreCase(elements[i].getName()) && (agentDeclaration = AgentDeclaration.constructInstance(elements[i])) != null) {
                this.agentDeclarations.put(agentDeclaration.getId(), agentDeclaration);
            }
            ++i;
        }
    }

    public AgentDeclaration getAgentDeclaration(String agentDeclarationId) {
        return (AgentDeclaration)this.agentDeclarations.get(agentDeclarationId);
    }

    public String getAgentDeclarationId(String agentName, String agentType) {
        Enumeration agentDeclarationIds = this.agentDeclarations.keys();
        while (agentDeclarationIds.hasMoreElements()) {
            String currentDeclarationId = (String)agentDeclarationIds.nextElement();
            AgentDeclaration ad = (AgentDeclaration)this.agentDeclarations.get(currentDeclarationId);
            if (!ad.getName().equals("*") && !ad.getName().equals(agentName) || !ad.getType().equals(agentType)) continue;
            return currentDeclarationId;
        }
        return null;
    }
}

