/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.IAvailabilityTester;

public class AvailabilityTesterDelegate
extends SelectionAdapter {
    private static AvailabilityTesterDelegate instance;

    private AvailabilityTesterDelegate() {
    }

    public static AvailabilityTesterDelegate getInstance() {
        if (instance == null) {
            instance = new AvailabilityTesterDelegate();
        }
        return instance;
    }

    public void widgetSelected(SelectionEvent e) {
        Object launchConfiguration = e.widget.getData("0");
        Object confLoader = e.widget.getData("1");
        IAvailabilityTester tester = null;
        if (!(launchConfiguration instanceof ILaunchConfiguration) || !(confLoader instanceof LightConfigurationLoader) || (tester = ((LightConfigurationLoader)confLoader).getAvailabilityTester()) == null) {
            ((Button)e.widget).setEnabled(false);
            return;
        }
        tester.reset((ILaunchConfiguration)launchConfiguration);
        IStatus status = tester.isServiceAvailable();
        if (status == null) {
            return;
        }
        int statusSeverity = status.getSeverity();
        if (statusSeverity == 4 || statusSeverity == 2) {
            LauncherUtility.openMessageWithDetail(Display.getDefault().getActiveShell(), statusSeverity, statusSeverity == 4 ? LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE : LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, status.getMessage(), status.getException() != null ? status.getException().getMessage() : "");
        } else if (statusSeverity == 0) {
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)LauncherMessages.LAUNCHER_COMMON_INFO_TITLE, (String)status.getMessage());
        }
    }
}

