/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessActiveException;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.Variable;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.security.internal.util.ConnectUtil;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;

public class CommonDelegateHelper {
    public static Process createProcess(Node node) throws CoreException {
        Process process = ProcessFactory.createProcess((Node)node);
        try {
            process.setExecutable("java.exe");
        }
        catch (ProcessActiveException e) {
            throw LauncherUtility.createCoreException(4, e.getMessage(), (Exception)((Object)e));
        }
        return process;
    }

    public static void configureProcess(Process process, TRCProcessProxy trcProcessProxy, String nodeName, String location, String classPath) throws CoreException {
        try {
            if (ConnectUtil.isLocalHost((String)nodeName)) {
                process.setLocation(location);
            } else {
                process.setLocation(null);
            }
            process.addEnvironmentVariable(new Variable("CLASSPATH", TString.stripNewLineChar((String)classPath)));
            process.addEnvironmentVariable(new Variable("UICLASSPATH", classPath));
        }
        catch (Exception e) {
            throw LauncherUtility.createCoreException(4, e.getMessage(), e);
        }
    }

    public static Agent createAgent(ILaunchConfiguration conf, Process process, TRCProcessProxy trcProcessProxy, String agentName, String agentType, String profileFile) throws CoreException {
        Agent agent = PDCoreUtil.createAgent(process, new ArrayList(), new Vector(), trcProcessProxy, agentName, agentType);
        if (profileFile != null) {
            agent.setProfileFile(profileFile);
        }
        return agent;
    }
}

