/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.platform.common.ui.trace.internal.util.CommonUITraceUtil;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeAssociationManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisTypeManager;

public class DataCollector {
    private String id;
    private String name;
    private AnalysisType[] applicableAnalysisTypes;
    private AnalysisType[] defaultAnalysisTypes;
    private Map coexistanceViolators;
    private String description;
    private ImageDescriptor icon;
    private boolean requiresAnalysisType;

    private DataCollector() {
    }

    public static DataCollector constructInstances(IConfigurationElement collector) {
        String id = collector.getAttribute("id");
        String name = collector.getAttribute("name");
        String description = collector.getAttribute("description");
        ImageDescriptor icon = CommonUITraceUtil.resolveImageDescriptor((IConfigurationElement)collector, (String)"icon");
        if (name == null || id == null) {
            return null;
        }
        IConfigurationElement[] childElement = null;
        Vector analysisTypesContainer = new Vector();
        Vector defaultAnalysisTypesContainer = new Vector();
        childElement = DataCollector.getElement(collector, "analysis", 1);
        if (childElement != null) {
            DataCollector.readApplicableAnalysisTypes(analysisTypesContainer, childElement[0]);
        }
        DataCollector.readAssociatedAnalysisTypes(analysisTypesContainer, id);
        AnalysisType[] analysisTypes = new AnalysisType[analysisTypesContainer.size()];
        analysisTypesContainer.toArray(analysisTypes);
        childElement = DataCollector.getElement(collector, "defaultAnalysis", 1);
        if (childElement != null) {
            DataCollector.readApplicableAnalysisTypes(defaultAnalysisTypesContainer, childElement[0]);
        }
        AnalysisType[] defaultAnalysisTypes = new AnalysisType[defaultAnalysisTypesContainer.size()];
        defaultAnalysisTypesContainer.toArray(defaultAnalysisTypes);
        boolean requiresAnalysisType = false;
        Hashtable<String, Boolean> coexistanceViolators = null;
        childElement = DataCollector.getElement(collector, "configuration", 1);
        if (childElement != null) {
            String reqAnalysisType = childElement[0].getAttribute("requiresAnalysisType");
            if ("true".equals(reqAnalysisType)) {
                requiresAnalysisType = true;
            }
            if ((childElement = DataCollector.getElement(childElement[0], "coexistanceViolation", 1)) != null) {
                IConfigurationElement[] coexistanceRules = DataCollector.getElement(childElement[0], "rule", -1);
                coexistanceViolators = new Hashtable<String, Boolean>();
                int j = 0;
                while (j < coexistanceRules.length) {
                    String ruleID = coexistanceRules[j].getAttribute("dataCollectionMechanismID");
                    if (ruleID != null) {
                        coexistanceViolators.put(ruleID, Boolean.TRUE);
                    }
                    ++j;
                }
                if (coexistanceViolators.size() <= 0) {
                    coexistanceViolators = null;
                }
            }
        }
        DataCollector dataCollector = new DataCollector();
        dataCollector.setId(id);
        dataCollector.setName(name);
        dataCollector.setDescription(description);
        dataCollector.setApplicableAnalysisTypes(analysisTypes);
        dataCollector.setCoexistanceViolators(coexistanceViolators);
        dataCollector.setRequiresAnalysisType(requiresAnalysisType);
        dataCollector.setDefaultAnalysisTypes(defaultAnalysisTypes);
        dataCollector.setIcon(icon);
        return dataCollector;
    }

    private static void readApplicableAnalysisTypes(Vector analysisTypesContainer, IConfigurationElement configurationElement) {
        IConfigurationElement[] applicableAnalysisTypes = DataCollector.getElement(configurationElement, "applicableType", -1);
        AnalysisTypeManager analysisTypeManager = AnalysisTypeManager.getInstance();
        int j = 0;
        while (j < applicableAnalysisTypes.length) {
            AnalysisType analysisType = analysisTypeManager.getAnalysisType(applicableAnalysisTypes[j].getAttribute("id"));
            if (analysisType != null) {
                analysisTypesContainer.add(analysisType);
            }
            ++j;
        }
    }

    private static void readAssociatedAnalysisTypes(Vector analysisTypesContainer, String dataCollectionMechanismId) {
        AnalysisType[] analysisTypes = AnalysisTypeAssociationManager.getInstance().getAssociatedAnalysisTypes(dataCollectionMechanismId);
        int i = 0;
        while (i < analysisTypes.length) {
            if (!analysisTypesContainer.contains(analysisTypes[i])) {
                analysisTypesContainer.add(analysisTypes[i]);
            }
            ++i;
        }
    }

    private static IConfigurationElement[] getElement(IConfigurationElement parentElement, String elementName, int expectedChildrentCount) {
        IConfigurationElement[] configurationElements = parentElement.getChildren(elementName);
        if (configurationElements == null || expectedChildrentCount != -1 && configurationElements.length != expectedChildrentCount) {
            return null;
        }
        return configurationElements;
    }

    public AnalysisType[] getApplicableAnalysisTypes() {
        return this.applicableAnalysisTypes;
    }

    public void setApplicableAnalysisTypes(AnalysisType[] applicableAnalysisTypes) {
        this.applicableAnalysisTypes = applicableAnalysisTypes;
    }

    public Map getCoexistanceViolators() {
        return this.coexistanceViolators;
    }

    public void setCoexistanceViolators(Map coexistanceViolators) {
        this.coexistanceViolators = coexistanceViolators;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AnalysisType[] getDefaultAnalysisTypes() {
        return this.defaultAnalysisTypes;
    }

    public void setDefaultAnalysisTypes(AnalysisType[] defaultAnalysisTypes) {
        this.defaultAnalysisTypes = defaultAnalysisTypes;
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public void setIcon(ImageDescriptor icon) {
        this.icon = icon;
    }

    public boolean isAnalysisTypeRequired() {
        return this.requiresAnalysisType;
    }

    public void setRequiresAnalysisType(boolean requiresAnalysisType) {
        this.requiresAnalysisType = requiresAnalysisType;
    }
}

