/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.ConfigurationManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LightConfigurationLoader;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILaunchValidator;

public class DataCollectorAssociationData {
    private IConfigurationElement launchDelegateConfigurationElem;
    private LightConfigurationLoader configurationLoader;
    private ILaunchValidator validator;
    private String datacollectionMechanismID;
    private String[] applicableAgents;
    private ICollectorFiltration filter;

    private DataCollectorAssociationData() {
    }

    private DataCollectorAssociationData(IConfigurationElement launchDelegateConfigurationElem, LightConfigurationLoader configuration, ILaunchValidator validator, String dataCollectorID, String[] applicableAgents) {
        this.launchDelegateConfigurationElem = launchDelegateConfigurationElem;
        this.configurationLoader = configuration;
        this.validator = validator;
        this.datacollectionMechanismID = dataCollectorID;
        this.applicableAgents = applicableAgents;
    }

    public static DataCollectorAssociationData constructInstance(IConfigurationElement mechanism) {
        ILaunchValidator collectorValidator;
        LightConfigurationLoader launchConfiguration;
        String datacollectionMechanismID;
        IConfigurationElement configurationElement;
        IConfigurationElement[] configurationElemChildren;
        block12: {
            block11: {
                configurationElemChildren = mechanism.getChildren("configuration");
                if (configurationElemChildren == null || configurationElemChildren.length != 1) {
                    return null;
                }
                configurationElement = configurationElemChildren[0];
                datacollectionMechanismID = mechanism.getAttribute("mechanismID");
                if (datacollectionMechanismID != null) break block11;
                return null;
            }
            String configurationId = configurationElemChildren[0].getAttribute("configurationId");
            launchConfiguration = null;
            if (configurationId != null) {
                launchConfiguration = ConfigurationManager.getInstance().getConfiguration(configurationId);
            }
            collectorValidator = null;
            if (configurationElemChildren[0].getAttribute("validator") != null) {
                collectorValidator = (ILaunchValidator)configurationElemChildren[0].createExecutableExtension("validator");
            }
            if (configurationElement.getAttribute("launchDelegate") != null) break block12;
            return null;
        }
        try {
            String[] applicableAgentsStr = null;
            String associatedAgent = configurationElemChildren[0].getAttribute("associatedAgent");
            if (associatedAgent != null && associatedAgent.length() > 0) {
                applicableAgentsStr = new String[]{associatedAgent};
            } else if ((configurationElemChildren = configurationElemChildren[0].getChildren("agentAssociation")) != null && configurationElemChildren.length == 1) {
                configurationElemChildren = configurationElemChildren[0].getChildren("agent");
                Vector<String> applicableAgents = new Vector<String>();
                int i = 0;
                while (i < configurationElemChildren.length) {
                    applicableAgents.add(configurationElemChildren[i].getAttribute("id"));
                    ++i;
                }
                applicableAgentsStr = new String[applicableAgents.size()];
                applicableAgents.toArray(applicableAgentsStr);
            }
            ICollectorFiltration filter = configurationElement.getAttribute("filter") == null ? null : (ICollectorFiltration)configurationElement.createExecutableExtension("filter");
            DataCollectorAssociationData associationData = new DataCollectorAssociationData();
            associationData.setLaunchDelegateConfigurationElem(configurationElement);
            associationData.setConfigurationLoader(launchConfiguration);
            associationData.setValidator(collectorValidator);
            associationData.setApplicableAgents(applicableAgentsStr);
            associationData.setDatacollectionMechanismID(datacollectionMechanismID);
            associationData.setFilter(filter);
            return associationData;
        }
        catch (CoreException e) {
            UIPlugin.getDefault().log(e);
            return null;
        }
    }

    public String getDataCollectorId() {
        return this.datacollectionMechanismID;
    }

    public IDataCollectorBaseLauncher createLaunchDelegate() throws CoreException {
        return (IDataCollectorBaseLauncher)this.launchDelegateConfigurationElem.createExecutableExtension("launchDelegate");
    }

    public LightConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    public void setConfigurationLoader(LightConfigurationLoader configuration) {
        this.configurationLoader = configuration;
    }

    public ILaunchValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ILaunchValidator validator) {
        this.validator = validator;
    }

    public String[] getApplicableAgents() {
        return this.applicableAgents;
    }

    public void setApplicableAgents(String[] applicableAgents) {
        this.applicableAgents = applicableAgents;
    }

    public ICollectorFiltration getFilter() {
        return this.filter;
    }

    public void setFilter(ICollectorFiltration filter) {
        this.filter = filter;
    }

    public String getDatacollectionMechanismID() {
        return this.datacollectionMechanismID;
    }

    public void setDatacollectionMechanismID(String datacollectionMechanismID) {
        this.datacollectionMechanismID = datacollectionMechanismID;
    }

    public void setLaunchDelegateConfigurationElem(IConfigurationElement launchDelegateConfigurationElem) {
        this.launchDelegateConfigurationElem = launchDelegateConfigurationElem;
    }
}

