/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.hyades.trace.ui.internal.core.TraceProfileUI;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfilingSetsManager;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollector;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociation;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorAssociationData;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.ICollectorFiltration;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.WorkbenchJob;

public class DataCollectorTreeContentProvider
implements ITreeContentProvider {
    private TraceProfileUI profileUI;
    private DeferredTreeContentManager deferredContentManager;
    private DataCollectorTreeInput input;

    public DataCollectorTreeContentProvider(TraceProfileUI profileUI) {
        this.profileUI = profileUI;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof DataCollector) {
            int numberOfChildren = 0;
            DataCollector dataCollector = (DataCollector)parentElement;
            AnalysisType[] applicableAnalysisTypes = dataCollector.getApplicableAnalysisTypes();
            if (applicableAnalysisTypes == null) {
                return null;
            }
            numberOfChildren = applicableAnalysisTypes.length;
            Object[] profilingTypes = null;
            if (dataCollector.getId().equals("org.eclipse.tptp.trace.ui.jvmpiMechanism")) {
                profilingTypes = ProfilingSetsManager.instance().getProfilingTypes().values().toArray();
                int i = 0;
                while (i < profilingTypes.length) {
                    if (profilingTypes[i] instanceof AnalysisType || !(profilingTypes[i] instanceof IProfilingSetType)) {
                        profilingTypes[i] = null;
                    } else {
                        ++numberOfChildren;
                    }
                    ++i;
                }
            }
            ArrayList<ParentChildNode> parentChildNodes = new ArrayList<ParentChildNode>(numberOfChildren);
            int storageInx = 0;
            while (storageInx < applicableAnalysisTypes.length) {
                ICollectorFiltration filter = applicableAnalysisTypes[storageInx].getFilter();
                if (filter == null || filter.include(applicableAnalysisTypes[storageInx].getId(), this.input == null ? null : this.input.getConfiguration(), null)) {
                    parentChildNodes.add(new ParentChildNode(parentElement, applicableAnalysisTypes[storageInx]));
                }
                ++storageInx;
            }
            if (profilingTypes != null) {
                int i = 0;
                while (i < profilingTypes.length) {
                    if (profilingTypes[i] != null) {
                        parentChildNodes.add(new ParentChildNode(parentElement, profilingTypes[i]));
                    }
                    ++i;
                }
            }
            return parentChildNodes.toArray(new ParentChildNode[parentChildNodes.size()]);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof ParentChildNode) {
            return ((ParentChildNode)element).parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        AnalysisType[] analysisTypes;
        return element instanceof DataCollector && (analysisTypes = ((DataCollector)element).getApplicableAnalysisTypes()) != null && analysisTypes.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.deferredContentManager.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        DataCollectorTreeInput dataCollectorTreeInput = this.input = newInput instanceof DataCollectorTreeInput ? (DataCollectorTreeInput)newInput : null;
        if (this.deferredContentManager == null) {
            class ExtendedDeferredContentManager
            extends DeferredTreeContentManager {
                private AbstractTreeViewer viewer;

                public ExtendedDeferredContentManager(ITreeContentProvider provider, AbstractTreeViewer viewer) {
                    super(provider, viewer);
                    this.viewer = viewer;
                }

                protected void addChildren(final Object parent, final Object[] children, IProgressMonitor monitor) {
                    WorkbenchJob updateJob = new WorkbenchJob(TraceMessages.AttachAdding){

                        public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                            if (viewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            viewer.add(parent, children);
                            return Status.OK_STATUS;
                        }
                    };
                    updateJob.setSystem(true);
                    updateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            DataCollectorTreeContentProvider.this.profileUI.initializeAfterFetch();
                        }
                    });
                    updateJob.schedule();
                }
            }
            this.deferredContentManager = new ExtendedDeferredContentManager(this, (AbstractTreeViewer)viewer);
        }
    }

    public static class DataCollectorTreeInput
    implements IAdaptable {
        private DeferredDataCollectorAdapter deferredAgentAdapter;
        private ILaunchConfiguration configuration;

        public DataCollectorTreeInput(ILaunchConfiguration configuration) {
            this.configuration = configuration;
            this.deferredAgentAdapter = new DeferredDataCollectorAdapter(configuration);
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IDeferredWorkbenchAdapter.class) {
                return this.deferredAgentAdapter;
            }
            return null;
        }

        public ILaunchConfiguration getConfiguration() {
            return this.configuration;
        }

        public void setConfiguration(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataCollectorTreeInput)) {
                return false;
            }
            if (this.configuration != null) {
                return this.configuration.equals(((DataCollectorTreeInput)o).configuration);
            }
            return this == o;
        }
    }

    public static class DeferredDataCollectorAdapter
    implements IDeferredWorkbenchAdapter {
        private ILaunchConfiguration configuration;

        public DeferredDataCollectorAdapter(ILaunchConfiguration configuration) {
            this.configuration = configuration;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            try {
                if (this.configuration == null) {
                    return;
                }
                String launchConfigurationID = null;
                try {
                    launchConfigurationID = this.configuration.getType().getIdentifier();
                }
                catch (Exception e) {
                    LauncherUtility.openErrorWithDetail(TraceMessages.LAUNCHER_COMMON_ERROR_TITLE, TraceMessages.ERROR_LAUNCH_TYPE_NOT_F, e);
                    collector.done();
                    monitor.done();
                    return;
                }
                DataCollectorManager dataCollManager = DataCollectorManager.getInstance();
                DataCollectorAssociation dataCollectorAssociation = dataCollManager.getDataCollectorAssociator(launchConfigurationID);
                if (dataCollectorAssociation == null) {
                    return;
                }
                dataCollManager.beginFetch();
                Object[] dataCollectors = dataCollectorAssociation.getDataCollectors();
                ArrayList<DataCollector> filteredDataCollectorSet = new ArrayList<DataCollector>();
                monitor.beginTask(TraceMessages.DataCollectorFiltering, dataCollectors.length * 2);
                int i = 0;
                while (i < dataCollectors.length) {
                    ICollectorFiltration filter;
                    DataCollectorAssociationData associationData = dataCollectorAssociation.getDataCollectorAssociationData(dataCollectors[i].getId());
                    ICollectorFiltration iCollectorFiltration = filter = associationData == null ? null : associationData.getFilter();
                    if (filter == null || filter.include(dataCollectors[i].getId(), this.configuration, null)) {
                        filteredDataCollectorSet.add(dataCollectors[i]);
                    }
                    monitor.worked(1);
                    ++i;
                }
                dataCollectors = filteredDataCollectorSet.toArray(new DataCollector[filteredDataCollectorSet.size()]);
                boolean useModifiedList = false;
                ArrayList<Object> modifiedListContainer = new ArrayList<Object>();
                int i2 = 0;
                while (i2 < dataCollectors.length) {
                    if (dataCollectors[i2].isAnalysisTypeRequired()) {
                        if (!useModifiedList && ((DataCollector)dataCollectors[i2]).getApplicableAnalysisTypes().length <= 0) {
                            useModifiedList = true;
                            int j = 0;
                            while (j < i2) {
                                modifiedListContainer.add(dataCollectors[j++]);
                            }
                        } else if (useModifiedList) {
                            modifiedListContainer.add(dataCollectors[i2]);
                        }
                    } else if (useModifiedList) {
                        modifiedListContainer.add(dataCollectors[i2]);
                    }
                    monitor.worked(1);
                    ++i2;
                }
                Object[] filteredResult = null;
                if (useModifiedList) {
                    filteredResult = new DataCollector[modifiedListContainer.size()];
                    modifiedListContainer.toArray(filteredResult);
                    collector.add(filteredResult, monitor);
                } else {
                    collector.add(dataCollectors, monitor);
                    filteredResult = dataCollectors;
                }
                dataCollManager.endFetch((DataCollector[])filteredResult);
            }
            finally {
                collector.done();
                monitor.done();
            }
        }

        public ISchedulingRule getRule(Object object) {
            return null;
        }

        public boolean isContainer() {
            return true;
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return TraceMessages.DataCollectorChildren;
        }

        public Object getParent(Object child) {
            if (child instanceof ParentChildNode) {
                return ((ParentChildNode)child).parent;
            }
            return null;
        }
    }

    public static class ParentChildNode {
        public Object parent;
        public Object child;

        public ParentChildNode(Object parent, Object child) {
            this.parent = parent;
            this.child = child;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ParentChildNode) {
                ParentChildNode parentChildNode2 = (ParentChildNode)obj;
                return parentChildNode2.child.equals(this.child) && parentChildNode2.parent.equals(this.parent);
            }
            return false;
        }
    }
}

