/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.hyades.trace.ui.internal.launcher.AttachAgentTabProviders;
import org.eclipse.hyades.trace.ui.internal.launcher.ILaunchConfigurationTabUpdater;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.hyades.trace.ui.launcher.IProfilingType;
import org.eclipse.hyades.trace.ui.launcher.ProfilingAttribute;
import org.eclipse.hyades.trace.ui.launcher.ProfilingSetsManagerCopy;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tptp.trace.ui.internal.launcher.core.ConfigurationLoader;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorTreeContentProvider;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfiguration;
import org.eclipse.tptp.trace.ui.provisional.launcher.IConfigurationPage;
import org.eclipse.tptp.trace.ui.provisional.launcher.IStatusListener;

public class EditOptionDelegate
implements SelectionListener {
    private static EditOptionDelegate editOptDelegate;
    private static ILaunchConfigurationTabUpdater tabUpdater;
    private static ProfilingSetsManagerCopy profilingSetManageWC;
    private static ConfigurationPageWrapper confPageWrapperLastPage;

    private EditOptionDelegate() {
    }

    public static SelectionListener getInstance(ILaunchConfigurationTabUpdater tabUpdater, ProfilingSetsManagerCopy profilingSetsManagerCopy) {
        if (editOptDelegate == null) {
            editOptDelegate = new EditOptionDelegate();
        }
        EditOptionDelegate.tabUpdater = tabUpdater;
        profilingSetManageWC = profilingSetsManagerCopy;
        return editOptDelegate;
    }

    public void widgetSelected(SelectionEvent se) {
        Object launchConfiguration = null;
        Object confLoader = null;
        Object profilingSetType = null;
        Object checkboxTreeViewer = null;
        Object checkstateListener = null;
        try {
            EditOptionWizard editOptWizard;
            boolean isInputProfilingType;
            launchConfiguration = se.widget.getData("0");
            confLoader = se.widget.getData("1");
            profilingSetType = se.widget.getData("2");
            checkboxTreeViewer = se.widget.getData("3");
            checkstateListener = se.widget.getData("4");
            boolean bl = isInputProfilingType = profilingSetType != null;
            if (!(launchConfiguration instanceof ILaunchConfiguration && (isInputProfilingType || confLoader instanceof ConfigurationLoader) && checkboxTreeViewer instanceof CheckboxTreeViewer && checkstateListener instanceof ICheckStateListener)) {
                ((Button)se.widget).setEnabled(false);
                return;
            }
            int width = -1;
            int height = -1;
            if (isInputProfilingType) {
                editOptWizard = new EditOptionWizard(tabUpdater, (ILaunchConfiguration)launchConfiguration, (IProfilingSetType)profilingSetType, profilingSetManageWC, (CheckboxTreeViewer)checkboxTreeViewer, (ICheckStateListener)checkstateListener);
            } else {
                ConfigurationLoader configurationLoader = (ConfigurationLoader)confLoader;
                editOptWizard = new EditOptionWizard(tabUpdater, (ILaunchConfiguration)launchConfiguration, configurationLoader, (CheckboxTreeViewer)checkboxTreeViewer, (ICheckStateListener)checkstateListener);
                String widthStr = configurationLoader.retrieveAttribute("width");
                String heightStr = configurationLoader.retrieveAttribute("height");
                try {
                    width = Integer.parseInt(widthStr);
                    height = Integer.parseInt(heightStr);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            final int finalWidth = width;
            final int finalHeight = height;
            WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)editOptWizard){

                protected Point getInitialSize() {
                    Point size = super.getInitialSize();
                    Point parentSize = this.getShell().getParent().getSize();
                    Point preferredSize = this.getShell().computeSize(-1, -1, true);
                    return new Point(finalWidth > 0 ? finalWidth : Math.min(Math.round((float)parentSize.x * 0.7f), preferredSize.x), finalHeight > 0 ? finalHeight : size.y);
                }

                protected Point getInitialLocation(Point initialSize) {
                    Point parentLocation = this.getShell().getParent().getLocation();
                    Point parentSize = this.getShell().getParent().getSize();
                    int widthDifference = parentSize.x - initialSize.x;
                    int heightDifference = parentSize.y - initialSize.y;
                    if (widthDifference > 0 && heightDifference > 0) {
                        return new Point(parentLocation.x + widthDifference / 2, parentLocation.y + heightDifference / 2);
                    }
                    return super.getInitialLocation(initialSize);
                }
            };
            wizardDialog.open();
        }
        catch (Exception ex) {
            String configurationID = confLoader instanceof ConfigurationLoader ? ((ConfigurationLoader)confLoader).getId() : LauncherMessages.LAUNCHER_COMMON_UNKNOWN;
            LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, NLS.bind((String)LauncherMessages.ERROR_CONFIG_OPEN, (Object)configurationID), ex);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static class ConfigurationPageWrapper
    extends WizardPage {
        private IConfigurationPage configuraitonPage;
        private IProfilingSetType profilingSetType;
        private boolean isInputProfilingType;
        private IStatusListener errorHandler;

        public ConfigurationPageWrapper(IConfigurationPage configurationPage) {
            super(configurationPage.getPageName(), configurationPage.getTitle(), configurationPage.getWizardBanner());
            super.setDescription(configurationPage.getDescription());
            this.configuraitonPage = configurationPage;
            this.isInputProfilingType = false;
            this.errorHandler = new IStatusListener(){

                public void handleErrorEvent(String error) {
                    ConfigurationPageWrapper.this.setErrorMessage(error);
                    ConfigurationPageWrapper.this.setPageComplete(false);
                }

                public void handleOKEvent() {
                    ConfigurationPageWrapper.this.setErrorMessage(null);
                    ConfigurationPageWrapper.this.setPageComplete(true);
                }
            };
            configurationPage.addErrorListener(this.errorHandler);
        }

        public ConfigurationPageWrapper(ProfilingSetsManagerCopy profilingSetManageWC, IProfilingSetType profilingSetType) {
            super(ConfigurationPageWrapper.class.getName(), TraceMessages.HPF_T, TraceUIImages.INSTANCE.getImageDescriptor("profset_wiz.gif"));
            super.setDescription(LauncherMessages.CONFIGURATION_PROFILING_TYPE_DESC);
            this.profilingSetType = profilingSetType;
            this.isInputProfilingType = true;
        }

        public void createControl(Composite parent) {
            Composite pageComposite = new Composite(parent, 0);
            pageComposite.setLayout((Layout)new GridLayout());
            pageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            if (this.isInputProfilingType) {
                this.profilingSetType.getProfilingType().createControl(pageComposite, profilingSetManageWC);
            } else {
                this.configuraitonPage.createControl(pageComposite);
            }
            super.setControl((Control)pageComposite);
        }
    }

    private static class EditOptionWizard
    extends Wizard {
        private ConfigurationLoader configurationLoader;
        private ILaunchConfigurationWorkingCopy launchConfigurationWC;
        private boolean isWorkingCopyConstructed;
        private ILaunchConfigurationTabUpdater tabUpdater;
        private boolean isInputProfilingType;
        private IProfilingSetType profilingSetType;
        private ProfilingSetsManagerCopy profilingSetManageWC;
        private ConfigurationPageWrapper dummyConfigurationPage;
        private CheckboxTreeViewer treeViewer;
        private ICheckStateListener listener;

        public EditOptionWizard(ILaunchConfigurationTabUpdater tabUpdater, ILaunchConfiguration launchConfiguration, ConfigurationLoader configurationLoader, CheckboxTreeViewer treeViewer, ICheckStateListener listener) {
            this.configurationLoader = configurationLoader;
            this.isInputProfilingType = false;
            this.treeViewer = treeViewer;
            this.listener = listener;
            super.setWindowTitle(configurationLoader.getDialogTitle());
            this.commonInitializer(tabUpdater, launchConfiguration);
        }

        public EditOptionWizard(ILaunchConfigurationTabUpdater tabUpdater, ILaunchConfiguration launchConfiguration, IProfilingSetType type, ProfilingSetsManagerCopy profilingSetManageWC, CheckboxTreeViewer treeViewer, ICheckStateListener listener) {
            this.isInputProfilingType = true;
            this.profilingSetType = type;
            this.profilingSetManageWC = profilingSetManageWC;
            this.treeViewer = treeViewer;
            this.listener = listener;
            super.setWindowTitle(UIPlugin.getResourceString("EDIT_PROF_OPT"));
            this.commonInitializer(tabUpdater, launchConfiguration);
        }

        private void commonInitializer(ILaunchConfigurationTabUpdater tabUpdater, ILaunchConfiguration launchConfiguration) {
            this.tabUpdater = tabUpdater;
            if (launchConfiguration.isWorkingCopy()) {
                this.isWorkingCopyConstructed = false;
                this.launchConfigurationWC = (ILaunchConfigurationWorkingCopy)launchConfiguration;
            } else {
                try {
                    this.isWorkingCopyConstructed = true;
                    this.launchConfigurationWC = launchConfiguration.getWorkingCopy();
                }
                catch (CoreException e) {
                    LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_CONFIG_WC_HANDLE, e);
                }
            }
        }

        public void addPages() {
            if (this.isInputProfilingType) {
                this.dummyConfigurationPage = new ConfigurationPageWrapper(this.profilingSetManageWC, this.profilingSetType);
                super.addPage((IWizardPage)this.dummyConfigurationPage);
            } else {
                IConfigurationPage[] confPages = ((IConfiguration)this.configurationLoader.getConfigurationClass()).getConfigurationPages();
                if (confPages == null || confPages.length == 0) {
                    return;
                }
                int i = 0;
                while (i < confPages.length - 1) {
                    this.addCurrentPage(confPages[i]);
                    ++i;
                }
                confPageWrapperLastPage = this.addCurrentPage(confPages[confPages.length - 1]);
            }
        }

        private ConfigurationPageWrapper addCurrentPage(IConfigurationPage configurationPage) {
            configurationPage.reset((ILaunchConfiguration)this.launchConfigurationWC);
            ConfigurationPageWrapper confPageWrapper = new ConfigurationPageWrapper(configurationPage);
            super.addPage((IWizardPage)confPageWrapper);
            return confPageWrapper;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean performFinish() {
            try {
                boolean status = true;
                if (this.isInputProfilingType) {
                    IProfilingType profilingType = this.profilingSetType.getProfilingType();
                    String errorMessage = profilingType.validateConfiguration(this.profilingSetManageWC);
                    if (errorMessage != null) {
                        this.dummyConfigurationPage.setErrorMessage(errorMessage);
                        this.dummyConfigurationPage.setPageComplete(false);
                        return false;
                    }
                    this.dummyConfigurationPage.setErrorMessage(null);
                    this.dummyConfigurationPage.setPageComplete(true);
                    Map attr = this.profilingSetManageWC.getDefaultSet().getAttributes();
                    String profilingTypeId = this.profilingSetType.getId();
                    Set keys = attr.keySet();
                    ArrayList removalList = new ArrayList();
                    for (Object currentKey : keys) {
                        ProfilingAttribute attribute = (ProfilingAttribute)attr.get(currentKey);
                        if (!profilingTypeId.equals(attribute.getContributorId())) continue;
                        removalList.add(currentKey);
                    }
                    int i = 0;
                    int markedDeletedElementsSize = removalList.size();
                    while (i < markedDeletedElementsSize) {
                        attr.remove(removalList.get(i));
                        ++i;
                    }
                    ProfilingAttribute[] profilingAttributes = profilingType.getAttributes();
                    if (profilingAttributes != null) {
                        int i2 = 0;
                        while (i2 < profilingAttributes.length) {
                            profilingAttributes[i2++].setContributorId(profilingTypeId);
                        }
                        i2 = 0;
                        while (i2 < profilingAttributes.length) {
                            attr.put(profilingAttributes[i2].getName(), profilingAttributes[i2]);
                            ++i2;
                        }
                    }
                    this.tabUpdater.update();
                } else {
                    status = ((IConfiguration)this.configurationLoader.getConfigurationClass()).finishConfiguration(this.launchConfigurationWC);
                    if (!status) {
                        confPageWrapperLastPage.setErrorMessage(LauncherMessages.ERROR_NO_PROBES_SELECTED);
                    }
                    if (this.isWorkingCopyConstructed && status) {
                        this.launchConfigurationWC.doSave();
                    } else {
                        this.tabUpdater.update();
                    }
                }
                ISelection selection = this.treeViewer.getSelection();
                Object selectedItem = null;
                if (selection instanceof StructuredSelection) {
                    selectedItem = ((StructuredSelection)selection).getFirstElement();
                }
                if (selectedItem == null) {
                    return status;
                }
                AttachAgentTabProviders.AgentTreeItem item = null;
                if (selectedItem instanceof DataCollectorTreeContentProvider.ParentChildNode || selectedItem instanceof AttachAgentTabProviders.AgentTreeItem && ((item = (AttachAgentTabProviders.AgentTreeItem)selectedItem).getAnalysisType() != null || item.getProfilingType() != null)) {
                    ProfileLaunchUtil.changeItemCheckedState(this.treeViewer, this.listener, selectedItem, true);
                }
                return status;
            }
            catch (Exception e) {
                LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, LauncherMessages.ERROR_CONFIG_FINISH, e);
                return false;
            }
        }
    }
}

