/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IAvailabilityTester;
import org.eclipse.tptp.trace.ui.provisional.launcher.ILightConfiguration;

public class LightConfigurationLoader {
    protected String id;
    protected ILightConfiguration configurationClass;
    protected boolean editable;
    protected IAvailabilityTester availabilityTester;

    protected LightConfigurationLoader(String id) {
        this.id = id;
        this.editable = false;
    }

    public static LightConfigurationLoader constructInstance(IConfigurationElement configuration) {
        String[] attributeValues = LauncherUtility.getAttributes(configuration, new String[]{"id", "class", "testAvailabilityClass"});
        if (attributeValues[0] == null) {
            return null;
        }
        ILightConfiguration configurationClass = null;
        IAvailabilityTester availabilityTester = null;
        try {
            if (attributeValues[1] != null) {
                configurationClass = (ILightConfiguration)configuration.createExecutableExtension("class");
            }
            if (attributeValues[2] != null) {
                availabilityTester = (IAvailabilityTester)configuration.createExecutableExtension("testAvailabilityClass");
            }
        }
        catch (Exception exception) {
            return null;
        }
        LightConfigurationLoader lcl = new LightConfigurationLoader(attributeValues[0]);
        lcl.setConfigurationClass(configurationClass);
        lcl.setAvailabilityTester(availabilityTester);
        return lcl;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ILightConfiguration getConfigurationClass() {
        return this.configurationClass;
    }

    public void setConfigurationClass(ILightConfiguration configurationClass) {
        this.configurationClass = configurationClass;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public IAvailabilityTester getAvailabilityTester() {
        return this.availabilityTester;
    }

    public void setAvailabilityTester(IAvailabilityTester availabilityTester) {
        this.availabilityTester = availabilityTester;
    }
}

