/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.internal.launcher.deleg.application;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.internal.launcher.deleg.application.AbstractJavaDelegate;

public class AbstractJavaAppletDelegate
extends AbstractJavaDelegate
implements IDebugEventSetListener {
    private File workingDir;
    private ILaunch launch;
    private static Map fgLaunchToFileMap = new HashMap();

    public AbstractJavaAppletDelegate(String agentName, String agentType) {
        super(agentName, agentType);
    }

    public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.workingDir = this.javaLaunchConfigurationDelegate.verifyWorkingDirectory(configuration);
        this.launch = launch;
        super.preLaunch(configuration, mode, launch, monitor);
    }

    protected String getWorkingDirectory(ILaunchConfiguration conf) {
        return this.workingDir.getAbsolutePath();
    }

    protected String getProgramArguments(ILaunchConfiguration conf) {
        File htmlFile = this.buildHTMLFile(conf, this.workingDir);
        if (fgLaunchToFileMap.isEmpty()) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        fgLaunchToFileMap.put(this.launch, htmlFile);
        try {
            this.javaLaunchConfigurationDelegate.setDefaultSourceLocator(this.launch, conf);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return htmlFile.getName();
    }

    protected String getMainTypeName(ILaunchConfiguration conf) {
        try {
            this.javaLaunchConfigurationDelegate.verifyMainTypeName(conf);
            return conf.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer");
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String getVMArguments(ILaunchConfiguration conf) {
        try {
            return String.valueOf(this.getJavaPolicyFile(this.workingDir)) + ' ' + this.javaLaunchConfigurationDelegate.getVMArguments(conf);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object eventSource = event.getSource();
            switch (event.getKind()) {
                case 8: {
                    if (eventSource == null) break;
                    ILaunch launch = null;
                    if (eventSource instanceof IProcess) {
                        IProcess process = (IProcess)eventSource;
                        launch = process.getLaunch();
                    } else if (eventSource instanceof IDebugTarget) {
                        IDebugTarget debugTarget = (IDebugTarget)eventSource;
                        launch = debugTarget.getLaunch();
                    }
                    File temp = (File)fgLaunchToFileMap.get(launch);
                    if (temp == null) break;
                    try {
                        fgLaunchToFileMap.remove(launch);
                        temp.delete();
                    }
                    catch (Throwable throwable) {
                        if (fgLaunchToFileMap.isEmpty()) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        }
                        throw throwable;
                    }
                    if (!fgLaunchToFileMap.isEmpty()) break;
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private File buildHTMLFile(ILaunchConfiguration configuration, File dir) {
        block21: {
            writer = null;
            tempFile = null;
            try {
                name = this.javaLaunchConfigurationDelegate.getMainTypeName(configuration);
                tempFile = new File(dir, String.valueOf(name) + System.currentTimeMillis() + ".html");
                writer = new FileWriter(tempFile);
                writer.write("<html>\n");
                writer.write("<body>\n");
                writer.write("<applet code=");
                writer.write(name);
                writer.write(".class ");
                appletName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, "");
                if (appletName.length() != 0) {
                    writer.write("NAME =\"" + appletName + "\" ");
                }
                writer.write("width=\"");
                writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
                writer.write("\" height=\"");
                writer.write(Integer.toString(configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
                writer.write("\" >\n");
                parameters = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, new HashMap<K, V>());
                if (parameters.size() != 0) {
                    for (Map.Entry<K, V> next : parameters.entrySet()) {
                        writer.write("<param name=");
                        writer.write(this.getQuotedString((String)next.getKey()));
                        writer.write(" value=");
                        writer.write(this.getQuotedString((String)next.getValue()));
                        writer.write(">\n");
                    }
                }
                writer.write("</applet>\n");
                writer.write("</body>\n");
                writer.write("</html>\n");
            }
            catch (IOException v0) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException v1) {}
                }
                break block21;
            }
            catch (CoreException v2) {
                try {
                    ** if (writer == null) goto lbl-1000
                }
                catch (Throwable var10_10) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException v4) {}
                    }
                    throw var10_10;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        writer.close();
                    }
                    catch (IOException v3) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block21;
                }
            }
            if (writer == null) break block21;
            try {
                writer.close();
            }
            catch (IOException v5) {}
        }
        if (tempFile == null) {
            return null;
        }
        return tempFile;
    }

    private String getQuotedString(String string) {
        if (string.indexOf(34) == -1) {
            return String.valueOf('\"') + string + '\"';
        }
        return String.valueOf('\'') + string + '\'';
    }

    public String getJavaPolicyFile(File workingDir) {
        File file = new File(workingDir, "java.policy.applet");
        if (!file.exists()) {
            File test = LauncherUtility.getFileInPlugin((IPath)new Path("java.policy.applet"));
            try {
                byte[] bytes = AbstractJavaAppletDelegate.getFileByteContent(test);
                BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
                outputStream.write(bytes);
                outputStream.close();
            }
            catch (IOException iOException) {
                return "";
            }
        }
        return "-Djava.security.policy=java.policy.applet";
    }

    protected static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block7: {
            InputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = AbstractJavaAppletDelegate.getInputStreamAsByteArray(stream, (int)file.length());
                if (stream == null) break block7;
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    protected static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int bytesRead = -1;
            do {
                int available;
                if (contentsLength + (available = stream.available()) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + available];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((bytesRead = stream.read(contents, contentsLength, available)) <= 0) continue;
                contentsLength += bytesRead;
            } while (bytesRead > 0);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    protected ArrayList getLaunchTypeWorkspaceFilters(ILaunchConfiguration config) throws CoreException {
        ArrayList<FilterTableElement> result = super.getLaunchTypeWorkspaceFilters(config);
        String appletViewerClassName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, "sun.applet.AppletViewer");
        result.add(new FilterTableElement(String.valueOf(appletViewerClassName) + "*", "*", TraceMessages.INCLUDE));
        return result;
    }
}

