/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractAgentControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;

public abstract class AbstractAgentToolbarProvider
extends AbstractAgentControlProvider {
    public static final String START_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.startMonitoring";
    public static final String PAUSE_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.stopMonitoring";
    public static final String DETACH_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.detach";
    public static final String TERMINATE_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.terminate";
    public static final String REFRESH_VIEW_TOOLBAR_ITEM = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.refreshViews";
    public static final String REFRESH_OPTIONS = "org.eclipse.hyades.trace.ui.internal.monitorsview.toolbar.refreshOptions";
    private IControlItem startMonitoring;
    private IControlItem pauseMonitoring;
    private IControlItem detach;
    private IControlItem terminate;
    private IControlItem refreshView;
    private IControlItem automaticRefresh;

    protected void initializeControlItems() {
        this.addControlItem(this.createStartMonitoringControlItem());
        this.addControlItem(this.createPauseMonitoringControlItem());
        this.addControlItem(this.createDetachControlItem());
        this.addControlItem(this.createTerminateControlItem());
        this.addControlItem(this.createRefreshViewsControlItem());
        this.addControlItem(this.createAutomaticRefreshControlItem());
    }

    protected IControlItem createStartMonitoringControlItem() {
        if (this.startMonitoring != null) {
            return this.startMonitoring;
        }
        this.startMonitoring = this.makeToolbarReady(super.createStartMonitoringControlItem(), START_TOOLBAR_ITEM, "monitoringGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "resume_co.gif"));
        return this.startMonitoring;
    }

    protected IControlItem createPauseMonitoringControlItem() {
        if (this.pauseMonitoring != null) {
            return this.pauseMonitoring;
        }
        this.pauseMonitoring = this.makeToolbarReady(super.createPauseMonitoringControlItem(), PAUSE_TOOLBAR_ITEM, "monitoringGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "suspend_co.gif"));
        return this.pauseMonitoring;
    }

    protected IControlItem createDetachControlItem() {
        if (this.detach != null) {
            return this.detach;
        }
        this.detach = this.makeToolbarReady(super.createDetachControlItem(), DETACH_TOOLBAR_ITEM, "monitoringGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "detachAgent.gif"));
        return this.detach;
    }

    protected IControlItem createTerminateControlItem() {
        if (this.terminate != null) {
            return this.terminate;
        }
        this.terminate = this.makeToolbarReady(super.createTerminateControlItem(), TERMINATE_TOOLBAR_ITEM, "monitoringGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "terminate_co.gif"));
        return this.terminate;
    }

    protected IControlItem createRefreshViewsControlItem() {
        if (this.refreshView != null) {
            return this.refreshView;
        }
        this.refreshView = this.makeToolbarReady(super.createRefreshViewsControlItem(), REFRESH_VIEW_TOOLBAR_ITEM, "refreshGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "updateviews_co.gif"));
        return this.refreshView;
    }

    protected IControlItem createAutomaticRefreshControlItem() {
        if (this.automaticRefresh != null) {
            return this.automaticRefresh;
        }
        this.automaticRefresh = this.makeToolbarReady(super.createRefreshOptionControlItem(), REFRESH_OPTIONS, "refreshGroup", TraceUIImages.INSTANCE.getImageDescriptor("d", "message_options.gif"));
        return this.automaticRefresh;
    }

    protected IControlItem makeToolbarReady(IControlItem controlItem, String newId, String newGroupName, ImageDescriptor disableIcon) {
        controlItem.setId(newId);
        controlItem.setGroup(newGroupName);
        controlItem.setDisabledImageDescriptor(disableIcon);
        controlItem.setToolTipText(UIPlugin.removeAccelerators(controlItem.getText()));
        controlItem.setText("");
        return controlItem;
    }
}

