/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.trace.ui.internal.core.TraceUIImages;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IProcessStateModifier;
import org.eclipse.tptp.trace.ui.provisional.control.provider.ResourceItemControlProvider;

public abstract class AbstractProcessControlProvider
extends ResourceItemControlProvider {
    private static final String TERMINATE_ITEM = "org.eclipse.hyades.trace.ui.internal.popupMenu.TerminateAction";
    private IControlItem terminateItem;

    public abstract IProcessStateModifier getProcessStateModifier();

    protected void initializeControlItems() {
        super.initializeControlItems();
        this.addControlItem(this.createTerminateControlItem());
    }

    protected IControlItem createTerminateControlItem() {
        if (this.terminateItem != null) {
            return this.terminateItem;
        }
        class TerminateAction
        extends ControlItem {
            public TerminateAction() {
                super(AbstractProcessControlProvider.TERMINATE_ITEM, "terminateGroup", ControlMessages.CONTROL_ITEM_TERMINATE, TraceUIImages.INSTANCE.getImageDescriptor("c", "terminate_co.gif"));
                this.setDisabledImageDescriptor(TraceUIImages.INSTANCE.getImageDescriptor("d", "terminate_co.gif"));
            }

            public void run() {
                IProcessStateModifier processStateModifier = AbstractProcessControlProvider.this.getProcessStateModifier();
                try {
                    processStateModifier.terminate();
                }
                catch (CoreException e) {
                    LauncherUtility.openMessageWithDetail(e.getStatus().getSeverity(), "", e.getMessage(), e);
                }
            }

            public boolean isEnabled() {
                return AbstractProcessControlProvider.this.getProcessStateModifier().canTerminate();
            }

            public void setInput(StructuredSelection input) {
                AbstractProcessControlProvider.this.getProcessStateModifier().setInput(input);
            }

            public IProcessStateModifier getStateModifier() {
                return AbstractProcessControlProvider.this.getProcessStateModifier();
            }

            public boolean equals(Object o) {
                if (!(o instanceof TerminateAction)) {
                    return false;
                }
                return AbstractProcessControlProvider.this.getProcessStateModifier() == ((TerminateAction)o).getStateModifier() && super.equals(o);
            }
        }
        this.terminateItem = new TerminateAction();
        return this.terminateItem;
    }
}

