/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.OpenTraceReportAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshFromLocalAction;
import org.eclipse.hyades.trace.ui.internal.actions.RefreshTreeAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tptp.trace.ui.internal.control.provider.TraceControlItemManager;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IControlItem;
import org.eclipse.ui.actions.ExportResourcesAction;
import org.eclipse.ui.actions.ImportResourcesAction;

public class LogicalItemControlProvider
extends AbstractControlProvider {
    private IControlItem reportItem;
    private IControlItem importItem;
    private IControlItem exportItem;
    private IControlItem refreshItem;
    private IControlItem unloadDataItem;

    protected void initializeControlItems() {
        this.controlItems.clear();
        this.addControlItem(this.createReportControlItem());
        this.addControlItem(this.createImportControlItem());
        this.addControlItem(this.createExportControlItem());
        this.addControlItem(this.createRefreshControlItem());
        this.addControlItem(this.createUnloadControlItem());
    }

    protected IControlItem createReportControlItem() {
        if (this.reportItem != null && !this.isContextDifferent) {
            ((OpenTraceReportAction)((AbstractControlProvider.ControlItemAdapter)this.reportItem).getAction()).selectionChanged((IStructuredSelection)TraceControlItemManager.getNavigator().getViewer().getSelection());
            return this.reportItem;
        }
        OpenTraceReportAction openReportAction = new OpenTraceReportAction();
        openReportAction.selectionChanged((IStructuredSelection)TraceControlItemManager.getNavigator().getViewer().getSelection());
        if (openReportAction.isApplicableForSelection()) {
            this.reportItem = new AbstractControlProvider.ControlItemAdapter("group.import", (IAction)openReportAction);
        }
        return this.reportItem;
    }

    protected IControlItem createImportControlItem() {
        if (this.importItem != null && !this.isContextDifferent) {
            return this.importItem;
        }
        this.importItem = new AbstractControlProvider.ControlItemAdapter("group.import", (IAction)new ImportResourcesAction(UIPlugin.getActiveWorkbenchWindow()));
        return this.importItem;
    }

    protected IControlItem createExportControlItem() {
        if (this.exportItem != null && !this.isContextDifferent) {
            return this.exportItem;
        }
        this.exportItem = new AbstractControlProvider.ControlItemAdapter("group.import", (IAction)new ExportResourcesAction(UIPlugin.getActiveWorkbenchWindow()));
        return this.exportItem;
    }

    protected IControlItem createRefreshControlItem() {
        if (this.refreshItem != null && !this.isContextDifferent) {
            return this.refreshItem;
        }
        this.refreshItem = new AbstractControlProvider.ControlItemAdapter("group.refresh", (IAction)new RefreshTreeAction(TraceControlItemManager.getNavigator()));
        return this.refreshItem;
    }

    protected IControlItem createUnloadControlItem() {
        if (this.unloadDataItem != null && !this.isContextDifferent) {
            return this.unloadDataItem;
        }
        this.unloadDataItem = new AbstractControlProvider.ControlItemAdapter("group.refresh", (IAction)new RefreshFromLocalAction(TraceControlItemManager.getNavigator()));
        return this.unloadDataItem;
    }
}

