/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.trace.ui.internal.control.provider.application.ControlMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.AbstractProcessControlProvider;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IProcessStateModifier;

public class ProcessControlProvider
extends AbstractProcessControlProvider {
    private ProcessStateModifier processStateModifier = new ProcessStateModifier();

    public IProcessStateModifier getProcessStateModifier() {
        return this.processStateModifier;
    }

    public static class ProcessStateModifier
    implements IProcessStateModifier {
        private StructuredSelection input;

        public void setInput(StructuredSelection input) {
            this.input = input;
        }

        public void terminate() throws CoreException {
            HashSet<TRCProcessProxy> processProxies = new HashSet<TRCProcessProxy>();
            Iterator processes = this.input.iterator();
            while (processes.hasNext()) {
                TRCProcessProxy processProxy = this.findProcessProxy(processes.next());
                if (processProxies.contains(processProxy) || processProxy == null) continue;
                processProxies.add(processProxy);
                this.terminateProcess(processProxy);
            }
        }

        public boolean canTerminate() {
            boolean canTerminate = this.input.size() > 0;
            HashSet<TRCProcessProxy> processProxies = new HashSet<TRCProcessProxy>();
            Iterator processes = this.input.iterator();
            while (canTerminate && processes.hasNext()) {
                TRCProcessProxy processProxy = this.findProcessProxy(processes.next());
                if (processProxies.contains(processProxy) || processProxy == null) continue;
                processProxies.add(processProxy);
                boolean bl = canTerminate = canTerminate && processProxy.isActive();
            }
            return canTerminate;
        }

        private TRCProcessProxy findProcessProxy(Object element) {
            if (element instanceof TRCProcessProxy) {
                return (TRCProcessProxy)element;
            }
            if (element instanceof TRCAgentProxy) {
                return ((TRCAgentProxy)element).getProcessProxy();
            }
            return null;
        }

        private void terminateProcess(TRCProcessProxy process) throws CoreException {
            CoreException error = null;
            try {
                String title = TraceMessages.TRC_MSGT;
                String msg = NLS.bind((String)TraceMessages.TERMINATE_Q, (Object[])new Object[]{process.getName(), String.valueOf(process.getPid())});
                if (!MessageDialog.openQuestion((Shell)UIPlugin.getActiveWorkbenchShell(), (String)title, (String)msg)) {
                    return;
                }
                TRCNode modelNode = process.getNode();
                String host = modelNode.getName();
                Node node = PDCoreUtil.profileConnect((String)host, (String)String.valueOf(modelNode.getPort()));
                if (node == null) {
                    return;
                }
                Process p = node.getProcess(String.valueOf(process.getPid()));
                if (p != null && p.isActive()) {
                    node.killProcess(p);
                }
                process.setActive(false);
            }
            catch (Exception e) {
                error = new CoreException((IStatus)new Status(4, UIPlugin.getPluginId(), 4, NLS.bind((String)ControlMessages.ERROR_PROCESS_TERMINATE, (Object)String.valueOf(process.getPid())), (Throwable)e));
            }
            LauncherUtility.sendProfileEvent(16, process);
            EList agentProxies = process.getAgentProxies();
            int i = 0;
            int agentCount = agentProxies.size();
            while (i < agentCount) {
                TRCAgentProxy agentProxy = (TRCAgentProxy)agentProxies.get(i);
                if (!agentProxy.isAttached()) {
                    agentProxy.setMonitored(false);
                    agentProxy.setActive(false);
                    LauncherUtility.sendProfileEvent(16, agentProxy);
                }
                ++i;
            }
            if (error != null) {
                throw error;
            }
        }
    }
}

