/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.control.provider;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.actions.AttachAction;
import org.eclipse.hyades.trace.ui.internal.actions.DetachAction;
import org.eclipse.hyades.trace.ui.internal.actions.StartTraceAction;
import org.eclipse.hyades.trace.ui.internal.actions.StopTraceAction;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.control.provider.IAgentStateModifier;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class StandardAgentStateModifier
implements IAgentStateModifier {
    private static final byte ATTACH_ACTION = 0;
    private static final byte DETACH_ACTION = 1;
    private static final byte PAUSE_ACTION = 2;
    private static final byte RESUME_ACTION = 3;
    private ExtendedDetachAction detachAction = new ExtendedDetachAction();
    private ExtendedAttachAction attachAction = new ExtendedAttachAction();
    private StartTraceAction startAction = new StartTraceAction();
    private StopTraceAction stopAction = new StopTraceAction();
    private StructuredSelection input;

    public void detach() throws CoreException {
        this.performProfileAction((byte)1, true);
    }

    public void attach() throws CoreException {
        this.performProfileAction((byte)0, true);
    }

    public void startMonitoring() throws CoreException {
        this.performProfileAction((byte)3, true);
    }

    public void pauseMonitoring() throws CoreException {
        this.performProfileAction((byte)2, true);
    }

    public boolean canAttach() {
        try {
            return this.performProfileAction((byte)0, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean canDetach() {
        try {
            return this.performProfileAction((byte)1, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean canPause() {
        try {
            return this.performProfileAction((byte)2, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean canResume() {
        try {
            return this.performProfileAction((byte)3, false);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void setInput(StructuredSelection input) {
        this.input = input;
    }

    private boolean performProfileAction(byte actionIndicator, boolean run) throws CoreException {
        boolean isEnabled = this.input.size() > 0;
        try {
            Iterator agents = this.input.iterator();
            while (isEnabled && agents.hasNext()) {
                Object currentAgent = agents.next();
                switch (actionIndicator) {
                    case 0: {
                        IWorkbenchPart workbenchPart;
                        if (run) {
                            if (this.attachAction.getView() == null && (workbenchPart = UIPlugin.getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IViewPart) {
                                this.attachAction.setView((IViewPart)workbenchPart);
                            }
                            this.attachAction.doAction(currentAgent);
                            break;
                        }
                        isEnabled = isEnabled && this.attachAction.isEnabledFor(currentAgent);
                        break;
                    }
                    case 1: {
                        IWorkbenchPart workbenchPart;
                        if (run) {
                            if (this.detachAction.getView() == null && (workbenchPart = UIPlugin.getActiveWorkbenchWindow().getActivePage().getActivePart()) instanceof IViewPart) {
                                this.detachAction.setView((IViewPart)workbenchPart);
                            }
                            this.detachAction.doAction(currentAgent);
                            break;
                        }
                        isEnabled = isEnabled && this.detachAction.isEnabledFor(currentAgent);
                        break;
                    }
                    case 2: {
                        if (run) {
                            this.stopAction.doAction(currentAgent);
                            break;
                        }
                        isEnabled = isEnabled && this.stopAction.isEnabledFor(currentAgent);
                        break;
                    }
                    case 3: {
                        if (run) {
                            this.startAction.doAction(currentAgent);
                            break;
                        }
                        boolean bl = isEnabled = isEnabled && this.startAction.isEnabledFor(currentAgent);
                    }
                }
            }
        }
        catch (Exception e) {
            throw LauncherUtility.createCoreException(4, e.getMessage(), e);
        }
        return isEnabled;
    }

    private static class ExtendedAttachAction
    extends AttachAction {
        private ExtendedAttachAction() {
        }

        public IViewPart getView() {
            return super.getView();
        }

        public void setView(IViewPart viewPart) {
            super.setView(viewPart);
        }
    }

    private static class ExtendedDetachAction
    extends DetachAction {
        private ExtendedDetachAction() {
        }

        public IViewPart getView() {
            return super.getView();
        }

        public void setView(IViewPart viewPart) {
            super.setView(viewPart);
        }
    }
}

