/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.HyadesTraceUIExtensionSupportUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.util.FilterTableElement;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.WorkspaceFiltersExtractor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.tptp.trace.ui.internal.launcher.core.CommonDelegateHelper;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorProcessLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProcessLauncher
implements IDataCollectorProcessLauncher {
    protected Node node;
    protected ILaunchConfiguration conf;
    private String hostName;
    private int port;
    private String location;
    private ProcessParameters processParameter;
    private String classpath;
    private String profileFile;
    private String agentType;
    private String agentName;
    private IProgressMonitor monitor;

    public AbstractProcessLauncher(String agentName, String agentType) {
        this.agentName = agentName;
        this.agentType = agentType;
    }

    private String ensureFileEncoding(ILaunch launch, String vmArgs) {
        String encoding;
        if (vmArgs.indexOf("-Dfile.encoding") < 0 && (encoding = launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING")) != null) {
            return String.valueOf(vmArgs) + " -Dfile.encoding=" + encoding;
        }
        return vmArgs;
    }

    @Override
    public void preLaunch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.conf = configuration;
        this.monitor = monitor;
        monitor.beginTask("", 7);
        this.hostName = this.conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost");
        String workingDir = this.getWorkingDirectory(this.conf);
        this.location = workingDir != null ? workingDir : System.getProperty("user.dir");
        this.processParameter = new ProcessParameters(this.ensureFileEncoding(launch, this.getVMArguments(this.conf)), this.getMainTypeName(this.conf), this.getProgramArguments(this.conf));
        this.classpath = this.getClasspathString(this.conf);
        this.port = LauncherUtility.getPort(this.conf);
        if (this.conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILE_TO_FILE, false)) {
            this.profileFile = this.conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_FILE, null);
        }
        monitor.worked(1);
        IWorkingSet[] workingSets = LauncherUtility.getActiveWorkingSets();
        ILaunchConfigurationWorkingCopy wc = this.conf.getWorkingCopy();
        HyadesTraceUIExtensionSupportUtil.applyExtensionFilterProcessing(wc, workingSets);
        wc.doSave();
        if (LauncherUtility.isAutoFilteringCriteria(this.conf)) {
            LauncherUtility.storeAutogeneratedFilterSet(this.getLaunchTypeWorkspaceFilters(this.conf));
        }
    }

    protected abstract String getWorkingDirectory(ILaunchConfiguration var1);

    protected abstract String getProgramArguments(ILaunchConfiguration var1);

    protected abstract String getMainTypeName(ILaunchConfiguration var1);

    protected abstract String getVMArguments(ILaunchConfiguration var1);

    @Override
    public Process createProcess() throws CoreException {
        return CommonDelegateHelper.createProcess(this.node);
    }

    @Override
    public ProcessParameters getProcessParameters(ILaunchConfiguration launchConfiguration) {
        this.monitor.worked(1);
        return this.processParameter;
    }

    @Override
    public void configureProcess(Process process, TRCProcessProxy trcProcessProxy) throws CoreException {
        String nodeName;
        String applicationName = this.processParameter.getApplicationName();
        if (applicationName != null && applicationName.length() > 0) {
            trcProcessProxy.setName(applicationName);
        } else {
            try {
                trcProcessProxy.setName(LauncherUtility.resolveProcessAttributes(process)[0]);
            }
            catch (InactiveProcessException inactiveProcessException) {}
        }
        try {
            if (process == null || process.getNode() == null) {
                throw new CoreException((IStatus)new Status(4, UIPlugin.getPluginId(), 4, null, null));
            }
            nodeName = process.getNode().getName();
        }
        catch (InactiveProcessException inactiveProcessException) {
            nodeName = this.getHostName();
        }
        CommonDelegateHelper.configureProcess(process, trcProcessProxy, nodeName, this.getLocation(), this.getClassPath());
        this.monitor.worked(1);
    }

    @Override
    public Agent createAgent(Process process, TRCProcessProxy trcProcessProxy) throws CoreException {
        Agent agent = CommonDelegateHelper.createAgent(this.conf, process, trcProcessProxy, this.getAgentName(), this.getAgentType(), this.getProfileFile());
        this.monitor.worked(1);
        return agent;
    }

    protected String getClasspathString(ILaunchConfiguration conf) throws CoreException {
        String classPath = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_CLASSPATH, null);
        if (classPath == null) {
            StringBuffer buf = new StringBuffer();
            String[] entries = this.getClasspath(conf);
            if (entries == null) {
                return buf.toString();
            }
            int i = 0;
            while (i < entries.length - 1) {
                buf.append(entries[i]);
                buf.append(File.pathSeparatorChar);
                ++i;
            }
            buf.append(entries[entries.length - 1]);
            return buf.toString();
        }
        return classPath;
    }

    protected abstract String[] getClasspath(ILaunchConfiguration var1);

    @Override
    public Node createNode() {
        this.node = PDCoreUtil.profileConnect((String)this.getHostName(), (String)String.valueOf(this.getPortNumber()));
        this.monitor.worked(1);
        return this.node;
    }

    @Override
    public void postLaunch(IStatus launchStatus) {
        this.monitor.worked(1);
        this.monitor.done();
        LauncherUtility.removeAutogeneratedFilterSet();
    }

    @Override
    public boolean isProcessLauncher() {
        return true;
    }

    @Override
    public boolean isMutualLauncher() {
        return true;
    }

    protected String getHostName() {
        return this.hostName;
    }

    protected int getPortNumber() {
        return this.port;
    }

    protected String getLocation() {
        return this.location;
    }

    protected String getClassPath() {
        return this.classpath;
    }

    protected String getProfileFile() {
        return this.profileFile;
    }

    protected String getAgentName() {
        return this.agentName;
    }

    protected String getAgentType() {
        return this.agentType;
    }

    protected ArrayList<FilterTableElement> getLaunchTypeWorkspaceFilters(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        if (javaProject == null || javaProject.getProject() == null) {
            return new ArrayList<FilterTableElement>();
        }
        IWorkingSet[] workingSets = LauncherUtility.getActiveWorkingSets();
        ArrayList<FilterTableElement> result = WorkspaceFiltersExtractor.extractFilters(javaProject.getProject(), workingSets);
        return result;
    }
}

