/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.launcher;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessFactory;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.launcher.IProfileLaunchConfigurationConstants;
import org.eclipse.hyades.trace.ui.internal.launcher.ProfileLaunchUtil;
import org.eclipse.hyades.trace.ui.internal.launcher.RunLaunchProfileStatusHandler;
import org.eclipse.hyades.trace.ui.internal.util.DeleteUtil;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.ProcessAdapter;
import org.eclipse.hyades.trace.ui.internal.util.ProcessMap;
import org.eclipse.hyades.trace.ui.internal.util.TraceMessages;
import org.eclipse.hyades.trace.ui.launcher.IProfilingSetType;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tptp.platform.common.internal.CommonPlugin;
import org.eclipse.tptp.trace.ui.internal.launcher.core.AnalysisType;
import org.eclipse.tptp.trace.ui.internal.launcher.core.DataCollectorManager;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherMessages;
import org.eclipse.tptp.trace.ui.internal.launcher.core.LauncherUtility;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorAgentLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorBaseLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorMutualLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.IDataCollectorProcessLauncher;
import org.eclipse.tptp.trace.ui.provisional.launcher.ProcessParameters;

public class PrimaryLaunchDelegate
implements ILaunchConfigurationDelegate,
Runnable {
    private TRCProcessProxy trcProcessProxy;
    private Node node;
    private String nodeName;
    private ILaunchConfiguration configuration;
    private String mode;
    private ILaunch launch;
    private IProgressMonitor monitor;
    private CoreException error;
    private boolean finished;

    public PrimaryLaunchDelegate() {
    }

    public PrimaryLaunchDelegate(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) {
        this.configuration = configuration;
        this.mode = mode;
        this.launch = launch;
        this.monitor = monitor;
        this.finished = false;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        PrimaryLaunchDelegate primaryLauncher = new PrimaryLaunchDelegate(configuration, mode, launch, monitor);
        new Thread((Runnable)primaryLauncher, "Pimary-Launcher").start();
        this.blockUntilCompletion(primaryLauncher);
        if (primaryLauncher.getError() != null) {
            throw primaryLauncher.getError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block30: {
            ArrayList launchDelegates = null;
            try {
                String dataCollectors = this.configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_PROFILING_COLLECTOR_AND_ANALYSIS, null);
                if (dataCollectors == null) {
                    this.openProfileDialog();
                    return;
                }
                Hashtable selectedCollectors = LauncherUtility.unserializeSelection(this.configuration);
                if (selectedCollectors == null || selectedCollectors.size() <= 0) {
                    this.openProfileDialog();
                    return;
                }
                ProfileLaunchUtil.performProfilingTypesLaunch(this.configuration);
                Hashtable delegateCollectorAssociation = LauncherUtility.validateLaunchItems(selectedCollectors, this.configuration, this.monitor);
                if (delegateCollectorAssociation == null) {
                    return;
                }
                launchDelegates = new ArrayList(delegateCollectorAssociation.size());
                Enumeration launchDelegatesEnum = delegateCollectorAssociation.keys();
                while (launchDelegatesEnum.hasMoreElements()) {
                    launchDelegates.add(launchDelegatesEnum.nextElement());
                }
                int listSize = launchDelegates.size();
                this.monitor.beginTask(LauncherMessages.LAUNCHING_BEGIN_TASK, listSize);
                try {
                    IDataCollectorMutualLauncher mutualLauncher;
                    launchDelegates = LauncherUtility.delegateInit(launchDelegates, this.configuration, this.mode, this.launch, this.monitor);
                    listSize = launchDelegates.size();
                    if (listSize <= 0) {
                        this.finished = true;
                        return;
                    }
                    Process process = null;
                    IDataCollectorProcessLauncher processLauncher = null;
                    int i = 0;
                    while (i < listSize) {
                        mutualLauncher = (IDataCollectorMutualLauncher)launchDelegates.get(i);
                        if (i == 0) {
                            this.node = mutualLauncher.createNode();
                            String string = this.nodeName = this.node == null ? this.configuration.getAttribute(IProfileLaunchConfigurationConstants.ATTR_HOSTNAME, "localhost") : this.node.getName();
                        }
                        if (mutualLauncher.isProcessLauncher()) {
                            processLauncher = (IDataCollectorProcessLauncher)mutualLauncher;
                            process = processLauncher.createProcess();
                            break;
                        }
                        ++i;
                    }
                    this.createModelEntities(this.configuration, process);
                    ProcessParameters processParameters = new ProcessParameters();
                    processParameters.setFilterDuplicates(true);
                    int i2 = 0;
                    while (i2 < listSize) {
                        mutualLauncher = (IDataCollectorMutualLauncher)launchDelegates.get(i2);
                        boolean isProcessLauncher = mutualLauncher.isProcessLauncher();
                        if (isProcessLauncher && process != null) {
                            IDataCollectorProcessLauncher currentProcessLauncher = (IDataCollectorProcessLauncher)mutualLauncher;
                            ProcessParameters currentParameter = currentProcessLauncher.getProcessParameters(this.configuration);
                            String applicationName = processParameters.getApplicationName();
                            if (applicationName == null || applicationName.length() <= 0) {
                                processParameters.setApplicationName(currentParameter.getApplicationName());
                            }
                            processParameters.add(currentParameter);
                            currentProcessLauncher.configureProcess(process, this.trcProcessProxy);
                            Agent agent = currentProcessLauncher.createAgent(process, this.trcProcessProxy);
                            this.addAnalysisTypes(agent, selectedCollectors, currentProcessLauncher, delegateCollectorAssociation);
                        } else if (isProcessLauncher && process == null) {
                            LauncherUtility.openErrorWithDetail(LauncherMessages.LAUNCHER_COMMON_ERROR_TITLE, NLS.bind((String)LauncherMessages.ERROR_DCM_INVALID_PROCESS, processLauncher == null ? null : processLauncher.getClass().getName()), null);
                        } else {
                            Agent agent = ((IDataCollectorAgentLauncher)mutualLauncher).createAgent(this.trcProcessProxy);
                            this.addAnalysisTypes(agent, selectedCollectors, mutualLauncher, delegateCollectorAssociation);
                        }
                        ++i2;
                    }
                    if (process != null) {
                        PDCoreUtil.addProcessParameters(process, processParameters, true);
                        this.launchProcess(process, this.launch);
                    }
                    i2 = 0;
                    while (i2 < listSize) {
                        ((IDataCollectorMutualLauncher)launchDelegates.get(i2)).postLaunch(Status.OK_STATUS);
                        ++i2;
                    }
                    break block30;
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().length() > 0) {
                        LauncherUtility.openWarningWithDetail(LauncherMessages.LAUNCHER_COMMON_WARNING_TITLE, LauncherMessages.WARNING_DCM_FAILED_DELEGATE, e);
                    }
                    if (this.trcProcessProxy != null) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                DeleteUtil.deleteProcess((TRCProcessProxy)PrimaryLaunchDelegate.this.trcProcessProxy, (boolean)true, (boolean)false, (boolean)false, (String)"org.eclipse.hyades.trace.ui.profileNavigator");
                            }
                        });
                    }
                    UIPlugin.getDefault().log(e);
                }
                break block30;
            }
            catch (Throwable t) {
                try {
                    if (launchDelegates != null) {
                        int i = 0;
                        int listSize = launchDelegates.size();
                        while (i < listSize) {
                            if (((IDataCollectorBaseLauncher)launchDelegates.get(i)).isMutualLauncher()) {
                                ((IDataCollectorMutualLauncher)launchDelegates.get(i)).postLaunch((IStatus)new Status(4, UIPlugin.getPluginId(), 4, LauncherMessages.ERROR_DCM_LAUNCH, t));
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            this.monitor.setCanceled(true);
            this.error = LauncherUtility.createCoreException(4, t.getMessage(), t instanceof Exception ? (Exception)t : null);
        }
        this.finished = true;
        PrimaryLaunchDelegate primaryLaunchDelegate = this;
        synchronized (primaryLaunchDelegate) {
            this.notify();
        }
    }

    private void openProfileDialog() {
        this.monitor.setCanceled(true);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = UIPlugin.getActiveWorkbenchShell();
                DebugUITools.openLaunchConfigurationDialog((Shell)shell, (ILaunchConfiguration)PrimaryLaunchDelegate.this.configuration, (String)"org.eclipse.debug.ui.launchGroup.profile", (IStatus)new Status(0, UIPlugin.getPluginId(), RunLaunchProfileStatusHandler.CODE, "", null));
            }
        });
        this.finished = true;
    }

    private void addAnalysisTypes(Agent agent, Hashtable collectorAnalysisTypeAssociation, IDataCollectorMutualLauncher mutualLauncher, Hashtable delegateCollectorAssociation) {
        List analysisTypes;
        String dataCollectorId = mutualLauncher == null ? null : (String)delegateCollectorAssociation.get(mutualLauncher);
        List list = analysisTypes = dataCollectorId == null ? null : (List)collectorAnalysisTypeAssociation.get(DataCollectorManager.getInstance().getDataCollector(dataCollectorId));
        if (analysisTypes == null) {
            return;
        }
        int i = 0;
        int analysisTypeCount = analysisTypes.size();
        while (i < analysisTypeCount) {
            Object currentAnalysisType = analysisTypes.get(i);
            if (currentAnalysisType instanceof AnalysisType) {
                LauncherUtility.associateAnalysisType(agent, ((AnalysisType)currentAnalysisType).getId());
            } else if (currentAnalysisType instanceof IProfilingSetType) {
                LauncherUtility.associateAnalysisType(agent, ((IProfilingSetType)currentAnalysisType).getId());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockUntilCompletion(PrimaryLaunchDelegate primaryLauncher) {
        int counter = 0;
        while (counter < 600 && !primaryLauncher.isCompleted()) {
            PrimaryLaunchDelegate primaryLaunchDelegate = primaryLauncher;
            synchronized (primaryLaunchDelegate) {
                try {
                    primaryLauncher.wait(100L);
                    ++counter;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isCompleted() {
        return this.finished;
    }

    public CoreException getError() {
        return this.error;
    }

    private void launchProcess(Process lprocess, ILaunch launch) {
        try {
            lprocess.launch();
            final ProcessAdapter adapter = new ProcessAdapter(lprocess, launch, true, 1);
            UIPlugin.getDefault().registerLaunchProcess(adapter);
            lprocess.addProcessListener(new ProcessListener(){

                public void processLaunched(Process process) {
                }

                public void processExited(Process process) {
                    UIPlugin.getDefault().deregisterLaunchProcess(adapter);
                    DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)adapter, 8)});
                }
            });
            int pID = Integer.parseInt(lprocess.getProcessId());
            for (TRCProcessProxy proxy : this.trcProcessProxy.getNode().getProcessProxies()) {
                if (pID != proxy.getPid() || !proxy.isActive()) continue;
                ProcessMap.put(proxy, adapter);
                break;
            }
        }
        catch (Exception e) {
            String text = TraceMessages.PLERR_INFO_;
            final String msg = NLS.bind((String)TraceMessages.PL_ERROR_, (Object)lprocess.getExecutable());
            final Status err = new Status(2, "org.eclipse.core.resources", 566, text, null);
            CommonPlugin.logError((Throwable)e);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ErrorDialog.openError((Shell)UIPlugin.getActiveWorkbenchShell(), (String)TraceMessages.TRC_MSGT, (String)msg, (IStatus)err);
                }
            });
        }
    }

    private void createModelEntities(ILaunchConfiguration conf, Process process) throws CoreException {
        IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();
        String projectName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_PROJECT, store.getString("prj_name"));
        String monitorName = conf.getAttribute(IProfileLaunchConfigurationConstants.ATTR_DESTINATION_MONITOR, store.getString("mon_name"));
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(projectName));
        TRCMonitor monitor = PDCoreUtil.createMonitor((IContainer)container, (String)monitorName);
        TRCNode trcNode = PDCoreUtil.createNode((TRCMonitor)monitor, (String)this.nodeName, (String)String.valueOf(LauncherUtility.getPort(conf)));
        if (process != null) {
            this.trcProcessProxy = PDCoreUtil.createProcess((TRCNode)trcNode, (Object)process, (boolean)false);
            LauncherUtility.addLaunchConfigId(this.trcProcessProxy, conf.getType().getIdentifier());
            process.addProcessListener(new ProcessListener(){
                boolean invalidate = false;

                public void processLaunched(Process process) {
                    if (!this.invalidate) {
                        PrimaryLaunchDelegate.this.trcProcessProxy.setRuntimeId(process.getUUID());
                        try {
                            PrimaryLaunchDelegate.this.trcProcessProxy.setPid(Integer.parseInt(process.getProcessId()));
                        }
                        catch (InactiveProcessException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void processExited(Process process) {
                    this.invalidate = true;
                }
            });
        } else if (this.node != null) {
            process = ProcessFactory.createProcess((Node)this.node);
            this.trcProcessProxy = PDCoreUtil.createProcess((TRCNode)trcNode, (Object)process, (boolean)false);
        } else {
            throw LauncherUtility.createCoreException(4, LauncherMessages.ERROR_LAUNCH_MODEL_CREATION);
        }
    }
}

