/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.trace.ui.provisional.launcher;

import java.util.ArrayList;
import java.util.List;

public class ProcessParameters {
    private List executableParameters = new ArrayList();
    private String applicationName = "";
    private List applicationParameters = new ArrayList();
    private boolean filterDuplicates;

    public ProcessParameters(String executableParameters, String applicationName, String applicationParameters) {
        this();
        if (executableParameters != null && executableParameters.length() > 0) {
            this.executableParameters.add(executableParameters);
        }
        this.applicationName = applicationName;
        if (applicationParameters != null && applicationParameters.length() > 0) {
            this.applicationParameters.add(applicationParameters);
        }
    }

    public ProcessParameters() {
    }

    public void add(ProcessParameters processParameter) {
        if (this.getApplicationName().equals(processParameter.getApplicationName())) {
            this.addExecutableParameter(processParameter.getExecutableParameters());
            this.addApplicationParameter(processParameter.getApplicationParameters());
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public List getApplicationParameters() {
        return this.applicationParameters;
    }

    public String getApplicationParametersStr() {
        return this.listToString(this.applicationParameters);
    }

    private String listToString(List list) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int listSize = list.size();
        while (i < listSize) {
            sb.append(" ");
            sb.append((String)list.get(i));
            ++i;
        }
        return sb.toString();
    }

    public void setApplicationParameters(List applicationParameters) {
        this.applicationParameters = applicationParameters;
    }

    public void addApplicationParameter(String param) {
        this.addStringToList(param, this.applicationParameters);
    }

    public void addApplicationParameter(List params) {
        this.addListToList(this.applicationParameters, params);
    }

    private void addStringToList(String param, List list) {
        if (param == null) {
            return;
        }
        if (this.filterDuplicates && list.contains(param)) {
            return;
        }
        list.add(param);
    }

    private void addListToList(List list1, List list2) {
        if (list2 == null) {
            return;
        }
        int i = 0;
        int listSize = list2.size();
        while (i < listSize) {
            this.addStringToList((String)list2.get(i), list1);
            ++i;
        }
    }

    public List getExecutableParameters() {
        return this.executableParameters;
    }

    public String getExecutableParametersStr() {
        return this.listToString(this.executableParameters);
    }

    public void setExecutableParameters(List executableParameters) {
        this.executableParameters = executableParameters;
    }

    public void addExecutableParameter(String param) {
        this.addStringToList(param, this.executableParameters);
    }

    public void addExecutableParameter(List params) {
        this.addListToList(this.executableParameters, params);
    }

    public boolean isFilterDuplicates() {
        return this.filterDuplicates;
    }

    public void setFilterDuplicates(boolean filterDuplicates) {
        this.filterDuplicates = filterDuplicates;
    }
}

