/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.core.internal.DCategory;

public class CategoryScale
implements IScale {
    protected double dmin_;
    protected double dmax_;
    protected double vmin_;
    protected double vmax_;
    protected double k_;
    protected boolean reverse_;
    protected UFormat format_;
    protected List categories;
    protected ULocale locale_;

    public CategoryScale(List cat) {
        this.categories = cat;
    }

    public void setValueRange(Object v1, Object v2) {
        System.out.println("setValueRange");
    }

    public boolean isValid() {
        return this.categories != null && this.categories.size() > 0;
    }

    public void setTextFormat(UFormat _format) {
        this.format_ = _format;
    }

    public String valueText(Object _value) {
        if (_value instanceof DCategory) {
            return ((DCategory)_value).getLabel();
        }
        return null;
    }

    public void setReversed(boolean b) {
        this.reverse_ = b;
    }

    public boolean isReversed() {
        return this.reverse_;
    }

    public Object getValueMax(Object _value) {
        return this.categories != null ? this.categories.get(this.categories.size() - 1) : null;
    }

    public Object getValueMin(Object _value) {
        return this.categories != null ? this.categories.get(0) : null;
    }

    public double getScaleMin() {
        return this.dmin_;
    }

    public double getScaleMax() {
        return this.dmax_;
    }

    public double toScale(Object _value) {
        if (_value instanceof DCategory) {
            int idx = this.categories.indexOf(_value) + 1;
            if (this.reverse_) {
                return (double)idx * this.k_ + this.dmin_ - this.k_ / 2.0;
            }
            return (double)idx * this.k_ + this.dmin_ - this.k_ / 2.0;
        }
        if (_value instanceof Number) {
            int idx = ((Number)_value).intValue();
            if (this.reverse_) {
                return (double)idx * this.k_ + this.dmin_ - this.k_ / 2.0;
            }
            return (double)idx * this.k_ + this.dmin_ - this.k_ / 2.0;
        }
        return -1.0;
    }

    public Object toValue(double dbl, Object _value) {
        int val = this.reverse_ ? (int)Math.round(dbl - this.dmin_ / this.k_ + this.k_ / 2.0) : (int)Math.round(dbl - this.dmin_ / this.k_ + this.k_ / 2.0);
        return this.categories.get(val);
    }

    public void setScaleRange(double dmin, double dmax) {
        this.dmin_ = dmin;
        this.dmax_ = dmax;
        this.k_ = (this.dmax_ - this.dmin_) / (double)this.categories.size() + 1.0;
    }

    public Object stepFirst(Object _step) {
        return this.categories.get(0);
    }

    public Object stepNext(Object _step, Object _last) {
        if (_last instanceof DCategory) {
            int idx = this.categories.indexOf(_last);
            if (idx == -1) {
                return null;
            }
            if (idx < this.categories.size() - 1) {
                return this.categories.get(idx + 1);
            }
        }
        return null;
    }

    public double getScaleForBar() {
        return this.dmin_;
    }

    public String toString() {
        return String.valueOf(super.toString()) + "{pixels=" + this.dmin_ + ".." + this.dmax_ + ", range=" + this.vmin_ + ".." + this.vmax_ + "}";
    }

    public void setLocale(ULocale _locale) {
        this.locale_ = _locale;
    }
}

