/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.io.IOException;
import java.io.OutputStream;

public class ChartEncoderOutputStream
extends OutputStream {
    public static final int E_DEFAULT = 0;
    public static final int E_FORJAVASCRIPT = 1;
    public static final int E_ALL = 3;
    private OutputStream os_;
    private int encode_;
    private boolean[] encode_it_;

    public ChartEncoderOutputStream(OutputStream os) {
        this(os, 0);
    }

    public ChartEncoderOutputStream(OutputStream os, int encode) {
        this.os_ = os;
        this.setEncode(encode);
    }

    public int getEncode() {
        return this.encode_;
    }

    public void setEncode(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 3: {
                this.encode_ = type;
                break;
            }
            default: {
                throw new Error("Unsupported encode type=" + type);
            }
        }
        if (this.encode_it_ == null) {
            this.encode_it_ = new boolean[256];
        }
        int i = 0;
        while (i < 256) {
            this.encode_it_[i] = false;
            ++i;
        }
        switch (this.encode_) {
            case 1: {
                this.encode_it_[123] = true;
                this.encode_it_[125] = true;
                this.encode_it_[39] = true;
                this.encode_it_[92] = true;
            }
            case 0: {
                i = 0;
                while (i <= 31) {
                    this.encode_it_[i] = true;
                    ++i;
                }
                i = 127;
                while (i <= 255) {
                    this.encode_it_[i] = true;
                    ++i;
                }
                i = 48;
                while (i <= 57) {
                    this.encode_it_[i] = true;
                    ++i;
                }
                i = 97;
                while (i <= 102) {
                    this.encode_it_[i] = true;
                    ++i;
                }
                this.encode_it_[34] = true;
                this.encode_it_[38] = true;
                this.encode_it_[37] = true;
                break;
            }
            case 3: {
                i = 0;
                while (i < 256) {
                    this.encode_it_[i] = true;
                    ++i;
                }
                break;
            }
        }
    }

    public void write(int c) throws IOException {
        int b = c & 0xFF;
        if (this.encode_it_[b]) {
            int bh = (b & 0xF0) >> 4;
            int bl = b & 0xF;
            if (bh < 10) {
                this.os_.write(48 + bh);
            } else {
                this.os_.write(97 + bh - 10);
            }
            if (bl < 10) {
                this.os_.write(48 + bl);
            } else {
                this.os_.write(97 + bl - 10);
            }
        } else {
            this.os_.write(b);
        }
    }
}

