/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.tptp.platform.report.chart.internal.IXYSurface;
import org.eclipse.tptp.platform.report.core.internal.DChildrenController;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlWriter;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.extension.internal.DExtensionRegistry;
import org.eclipse.tptp.platform.report.extension.internal.IDExtension;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DXYSurface
extends DItem
implements IXYSurface {
    protected int sizex_;
    protected int sizey_;
    protected double[] z_;
    protected double zmin_;
    protected double zmax_;
    private static Extension extension = new Extension();

    static {
        DChildrenController.installChildRule(DGraphic.class, DXYSurface.class);
        DExtensionRegistry.addExtension(extension, DXmlWriter.class);
        DExtensionRegistry.addExtension(extension, DXmlReader.class);
    }

    public DXYSurface() {
        this.z_ = new double[1];
    }

    public DXYSurface(int sizex, int sizey) {
        this.sizex_ = sizex;
        this.sizey_ = sizey;
        this.z_ = new double[this.sizex_ * this.sizey_];
    }

    public DXYSurface(int sizex, int sizey, double[] z, double zmin, double zmax) {
        this.sizex_ = sizex;
        this.sizey_ = sizey;
        this.z_ = z;
        this.zmin_ = zmin;
        this.zmax_ = zmax;
    }

    public void setZ(int sizex, int sizey, double[] z, double zmin, double zmax) {
        this.sizex_ = sizex;
        this.sizey_ = sizey;
        this.z_ = z;
        this.zmin_ = zmin;
        this.zmax_ = zmax;
    }

    public void setZ(int x, int y, double z) {
        this.z_[y * this.sizex_ + x] = z;
    }

    public int getSizeX() {
        return this.sizex_;
    }

    public int getSizeY() {
        return this.sizey_;
    }

    public double getZMin() {
        return this.zmin_;
    }

    public double getZMax() {
        return this.zmax_;
    }

    public double getZ(int x, int y) {
        return this.z_[y * this.sizex_ + x];
    }

    public void updateZMinMax() {
        if (this.z_ == null || this.z_.length == 0) {
            return;
        }
        this.zmin_ = this.zmax_ = this.z_[0];
        int i = 0;
        while (i < this.z_.length) {
            double z = this.z_[i];
            if (z < this.zmin_) {
                this.zmin_ = z;
            } else if (z > this.zmax_) {
                this.zmax_ = z;
            }
            ++i;
        }
    }

    public static class Extension
    implements IDExtension,
    DXmlReader.IDItemFactory {
        public void updateExtensible(DExtensible ext) {
            if (ext instanceof DXmlWriter) {
                ext.installDoMethods("writeXml", this);
            } else if (ext instanceof DXmlReader) {
                ext.installDoMethods("readXml", this);
                ((DXmlReader)ext).addIDItemFactory(this);
            }
        }

        public void writeXml(DXYSurface surf, DExtensible p, Object arg) {
            DXmlWriter writer = (DXmlWriter)p;
            writer.writeExtension(surf);
            writer.startElement("XYSURFACE", surf);
            writer.outAttribute("SIZEX", surf.sizex_);
            writer.outAttribute("SIZEY", surf.sizey_);
            writer.outAttribute("ZMIN", surf.zmin_);
            writer.outAttribute("ZMAX", surf.zmax_);
            if (surf.z_ != null) {
                int len = surf.z_.length;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(len * 9);
                try {
                    int i = 0;
                    int j = 0;
                    while (j < surf.sizey_) {
                        int k = 0;
                        while (k < surf.sizex_) {
                            bos.write(Double.toString(surf.z_[i]).getBytes("UTF-8"));
                            bos.write(32);
                            ++k;
                            ++i;
                        }
                        bos.write(10);
                        ++j;
                    }
                    writer.outCData(bos.toString("UTF-8"));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    throw new DXmlError(ex.getMessage());
                }
            }
            writer.doChildrenItem(surf, p, arg);
            writer.endElement();
        }

        private int getInteger(String name, NamedNodeMap attr) {
            Node n = attr.getNamedItem(name);
            if (n == null) {
                throw new DXmlError(String.valueOf(name) + " attribute not defined while parsing XYSURFACE element");
            }
            String val = n.getNodeValue();
            try {
                int v = Integer.parseInt(val);
                return v;
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError(String.valueOf(name) + " must be an integer value");
            }
        }

        private double getDouble(String name, NamedNodeMap attr) {
            Node n = attr.getNamedItem(name);
            if (n == null) {
                throw new DXmlError(String.valueOf(name) + " attribute not defined while parsing XYSURFACE element");
            }
            String val = n.getNodeValue();
            try {
                double v = Double.parseDouble(val);
                return v;
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError(String.valueOf(name) + " must be a double value");
            }
        }

        public void readXml(DXYSurface surf, DExtensible p, Object p_arg) {
            DXmlReader reader = (DXmlReader)p;
            DXmlReader.Arg arg = (DXmlReader.Arg)p_arg;
            NamedNodeMap attr = arg.node.getAttributes();
            reader.setNodeStyle(attr, surf);
            int sizex = this.getInteger("SIZEX", attr);
            int sizey = this.getInteger("SIZEY", attr);
            double zmin = this.getDouble("ZMIN", attr);
            double zmax = this.getDouble("ZMAX", attr);
            String text = "";
            Node cdata = arg.node.getFirstChild();
            while (cdata != null) {
                if (cdata.getNodeType() == 3) {
                    text = String.valueOf(text) + cdata.getNodeValue();
                }
                cdata = cdata.getNextSibling();
            }
            int index = 0;
            int len = sizex * sizey;
            double[] values = new double[len];
            StringTokenizer tok = new StringTokenizer(text, " \n");
            while (tok.hasMoreTokens()) {
                String stok = tok.nextToken();
                try {
                    values[index++] = Double.parseDouble(stok);
                    if (index < len) continue;
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new DXmlError(ex.getMessage());
                }
            }
            surf.setZ(sizex, sizey, values, zmin, zmax);
            if (index != len) {
                surf.updateZMinMax();
            }
            reader.doChildrenItem(surf, p, arg);
        }

        public IDItem createIDItem(Node node) {
            if (node != null && node.getNodeType() == 1 && ("XYSURFACE".equals(node.getNodeName()) || "xysurface".equals(node.getNodeName()))) {
                return new DXYSurface();
            }
            return null;
        }
    }
}

