/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IPen;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class DefaultChartRenderHBars {
    private static final int margin = 5;

    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        RPDHBars p = null;
        if (rpd.g instanceof RPDHBars) {
            p = (RPDHBars)rpd.g;
        }
        if (p == null) {
            DefaultChartRenderHBars.rebuildGraphData(d, rpd);
            p = (RPDHBars)rpd.g;
        }
        boolean one_hbar = p.axis2 == null;
        int h_graph = rpd.ag_rect.h();
        float dh = (float)h_graph / (float)p.num_lines;
        float dh2 = dh / 2.0f;
        float y = (float)rpd.ag_rect.top() + dh2;
        int bar_space = 0;
        if (rpd.graphic.getProperties().get("P_THIN_BAR.DGraphic.core.jscrib", false)) {
            bar_space = d.dpiX(3);
            if (2 * bar_space > (int)dh2) {
                bar_space = d.dpiX(1);
            } else if ((int)dh > 30) {
                bar_space = Math.max(d.dpiX(3), d.dpiX((int)(dh - 30.0f) / 2));
            }
        }
        if (p.axis1 == null) {
            if (d.draw_) {
                d.error("Missing axis", rpd);
            }
            return;
        }
        if (!p.scale1.isValid() && d.draw_) {
            d.error("Invalid Min/Max range in axis (" + p.axis1.getName() + ")", rpd);
        }
        if (!one_hbar && !p.scale2.isValid() && d.draw_) {
            d.error("Invalid Min/Max range in axis (" + p.axis2.getName() + ")", rpd);
        }
        if (p.num_lines == 0) {
            return;
        }
        int x_bar_base1 = (int)p.scale1.getScaleForBar();
        int x_bar_base2 = p.scale2 == null ? 0 : (int)p.scale2.getScaleForBar();
        Rect rg1 = new Rect((int)p.scale1.getScaleMin(), rpd.ag_rect.y(), (int)(p.scale1.getScaleMax() - p.scale1.getScaleMin()), h_graph);
        DefaultChartRenderHBars.drawHBarAxis(d, p.axis1, p.scale1, p.axis1_am, rg1, p.axis1_style, p.num_lines, y, dh);
        Rect rg2 = null;
        if (!one_hbar) {
            rg2 = new Rect((int)p.scale2.getScaleMin(), rpd.ag_rect.y(), (int)(p.scale2.getScaleMax() - p.scale2.getScaleMin()), h_graph);
            rg2.normalize();
            DefaultChartRenderHBars.drawHBarAxis(d, p.axis2, p.scale2, p.axis2_am, rg2, p.axis2_style, p.num_lines, y, dh);
        }
        Object v1 = DefaultChartRenderData.getNewInstanceValue(p.axis1);
        Rect r = new Rect();
        int h_bar = (int)(dh - (float)(2 * bar_space));
        int ibar = 0;
        while (ibar < p.num_lines) {
            HBarData b1 = null;
            HBarData b2 = null;
            try {
                b1 = (HBarData)p.bars1.get(ibar);
            }
            catch (Exception exception) {
                b1 = null;
            }
            try {
                b2 = one_hbar ? null : (HBarData)p.bars2.get(ibar);
            }
            catch (Exception exception) {
                b2 = null;
            }
            if (b1 != null) {
                if (p.show_title && b1.title_style != null) {
                    r.setRect(rpd.graphic_rect.getX() + d.margin_, (int)(y - dh2), p.w_max_title, (int)dh);
                    d.renderText(b1.title, r, 1, b1.title_style.style_, "LegendArea", b1.title_style.curve_);
                }
                if (p.show_v_begin1) {
                    r.setRect(p.x_v_begin1, (int)(y - dh2), p.w_max_v_begin1, (int)dh);
                    d.renderText(b1.begin_text, r, 2, b1.bar_style, "CurvePointText", b1.point);
                }
                if (p.show_v_end1) {
                    r.setRect(p.x_v_end1, (int)(y - dh2), p.w_max_v_end1, (int)dh);
                    d.renderText(b1.end_text, r, 2, b1.bar_style, "CurvePointText", b1.point);
                }
            }
            if (p.show_v_end2 && b2 != null) {
                r.setRect(p.x_v_end2, (int)(y - dh2), p.w_max_v_end2, (int)dh);
                d.renderText(b2.end_text, r, 2, b2.bar_style, "CurvePointText", b2.point);
            }
            IShape rc = d.gc_.getClipping();
            d.gc_.setClipping(new Rect(rg1.x(), rg1.y(), rg1.w(), rg1.h()));
            DefaultChartRenderHBars.renderHBar(d, b1, p.one_value, y, x_bar_base1, h_bar, bar_space, dh, dh2, p.axis1, p.scale1, r, v1);
            if (!one_hbar) {
                d.gc_.setClipping(new Rect(rg2.x(), rg2.y(), rg2.w(), rg2.h()));
                DefaultChartRenderHBars.renderHBar(d, b2, p.one_value, y, x_bar_base2, h_bar, bar_space, dh, dh2, p.axis2, p.scale2, r, v1);
            }
            d.gc_.setClipping(rc);
            if (!d.drawing() && (int)((y += dh) - dh2) > d.ly_) break;
            ++ibar;
        }
        d.renderXAxis(false, false, p.axis1, p.scale1, rg1, p.axis1_am, p.axis1_style, 4);
        if (!one_hbar) {
            d.renderXAxis(false, false, p.axis2, p.scale2, rg2, p.axis2_am, p.axis2_style, 4);
        }
    }

    private static HBarData createHBarData(DefaultChartRenderData d_, RPDHBars p, IDCoord b1c1, IDCoord b1c2, DPoint point, Object val1, Object val2, IScale scale, boolean is_bar1) {
        HBarData bar = new HBarData();
        bar.bar_style = new IGCDStyle(point, d_.scale_);
        bar.point = point;
        if (p.one_value) {
            val1 = b1c1.getValue(val1);
            bar.c_end = b1c1;
            bar.end_text = scale.valueText(val1);
            d_.gc_.setFont(bar.bar_style.getFont());
            bar.end_extend = DrawUtilIGC.textExtent(d_.gc_, bar.end_text, 1);
            int w_vx = bar.end_extend.getW();
            if (is_bar1) {
                if (w_vx > p.w_max_v_end1) {
                    p.w_max_v_end1 = w_vx;
                }
            } else if (w_vx > p.w_max_v_end2) {
                p.w_max_v_end2 = w_vx;
            }
        } else {
            val1 = b1c1.getValue(val1);
            val2 = b1c2.getValue(val2);
            if (val1 instanceof Comparable && ((Comparable)val1).compareTo(val2 = b1c2.getValue(val2)) > 0) {
                IDCoord c = b1c1;
                b1c1 = b1c2;
                b1c2 = c;
                Object o = val1;
                val1 = val2;
                val2 = o;
            }
            bar.c_begin = b1c1;
            bar.c_end = b1c2;
            bar.begin_text = scale.valueText(val1);
            bar.end_text = scale.valueText(val2);
            d_.gc_.setFont(bar.bar_style.getFont());
            bar.begin_extend = DrawUtilIGC.textExtent(d_.gc_, bar.begin_text, 1);
            bar.end_extend = DrawUtilIGC.textExtent(d_.gc_, bar.end_text, 1);
            int w_vn = bar.begin_extend.getW();
            int w_vx = bar.end_extend.getW();
            if (is_bar1) {
                if (w_vn > p.w_max_v_begin1) {
                    p.w_max_v_begin1 = w_vn;
                }
                if (w_vx > p.w_max_v_end1) {
                    p.w_max_v_end1 = w_vx;
                }
            } else {
                if (w_vn > p.w_max_v_begin2) {
                    p.w_max_v_begin2 = w_vn;
                }
                if (w_vx > p.w_max_v_end2) {
                    p.w_max_v_end2 = w_vx;
                }
            }
        }
        return bar;
    }

    private static void drawHBarAxis(DefaultChartRenderData d, DAxis axis, IScale scale, Insets insets, Rect r, IGCDStyle sty_axis, int num_lines, float y, float dh) throws DefaultRenderChartLocation {
        d.gc_.setFont(sty_axis.getFont());
        if (d.drawing()) {
            LineStylePen pen = new LineStylePen(sty_axis.getFore(), 2);
            IPen old = d.gc_.setPen(pen);
            float ly = y;
            int i = 0;
            while (i < num_lines) {
                d.gc_.drawLine(r.left(), (int)ly, r.right(), (int)ly);
                ly += dh;
                ++i;
            }
            d.gc_.setPen(old);
            d.renderXAxis(false, true, axis, scale, r, insets, sty_axis, 4);
            pen.setRGBA(255);
            pen.setLineStyle(0);
            d.gc_.setPen(pen);
            d.gc_.drawRect(r.x(), r.y(), r.w(), r.h());
        }
    }

    private static void renderHBar(DefaultChartRenderData d, HBarData data, boolean one_value, float y, int x_bar_base, int h_bar, int bar_space, float dh, float dh2, DAxis axis, IScale scale, Rect r, Object val) throws DefaultRenderChartLocation {
        int xvn = one_value ? x_bar_base : (int)scale.toScale(data.c_begin.getValue(val));
        int xvx = (int)scale.toScale(data.c_end.getValue(val));
        float y1 = y - dh2 + (float)bar_space;
        float y2 = y1 + dh - (float)bar_space;
        r.setRect(xvn, (int)y1, xvx - xvn, (int)(y2 - (float)((int)y1)));
        if (d.drawing()) {
            d.gc_.setBrush(new SolidBrush(data.bar_style.getBack()));
            d.gc_.fillRect(r.left(), r.y(), Math.abs(r.w()), r.h());
            d.gc_.setPen(new LineStylePen(255));
            d.gc_.drawRect(r.left(), r.y(), Math.abs(r.w()), r.h());
        } else if (r.contains(d.lx_, d.ly_)) {
            throw new DefaultRenderChartLocation("LegendArea", data.point, r);
        }
    }

    private static void rebuildGraphData(DefaultChartRenderData d, RenderPersistData rpd) {
        HBarData b;
        int i;
        boolean do_end;
        MinMax mm;
        int w;
        int div;
        RPDHBars p = new RPDHBars();
        rpd.g = p;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                if (p.axis1 == null) {
                    p.axis1 = (DAxis)item;
                } else if (p.axis2 == null) {
                    p.axis2 = (DAxis)item;
                    break;
                }
            }
            item = item.getNext();
        }
        if (p.axis1 == null) {
            if (d.draw_) {
                d.error("Missing axis", rpd);
            }
            return;
        }
        boolean one_hbar = p.axis2 == null;
        int icrv = 0;
        while (icrv < rpd.curve_styles.length) {
            CurveStyle cs = rpd.curve_styles[icrv];
            DCurve curve = cs.curve_;
            IDItem i2 = curve.getFirstChild();
            block2: while (i2 != null) {
                if (i2 instanceof DPoint) {
                    DPoint point = (DPoint)i2;
                    int num_coord_axis1 = 0;
                    IDItem ic = point.getFirstChild();
                    while (ic != null) {
                        DCoord coord;
                        if (ic instanceof DCoord && (coord = (DCoord)ic).getAxis() == p.axis1 && ++num_coord_axis1 == 2) {
                            p.one_value = false;
                            break block2;
                        }
                        ic = ic.getNext();
                    }
                    if (num_coord_axis1 == 1) break;
                }
                i2 = i2.getNext();
            }
            ++icrv;
        }
        if (!one_hbar) {
            p.bars2 = new Vector();
        }
        Object val1 = DefaultChartRenderData.getNewInstanceValue(p.axis1);
        Object val2 = DefaultChartRenderData.getNewInstanceValue(p.axis2);
        p.scale1 = DefaultChartRenderData.getScale(p.axis1, 0.0, 0.0, null, null);
        p.scale2 = DefaultChartRenderData.getScale(p.axis2, 0.0, 0.0, null, null);
        int icrv2 = 0;
        while (icrv2 < rpd.curve_styles.length) {
            CurveStyle cs = rpd.curve_styles[icrv2];
            DCurve curve = cs.curve_;
            IDItem i3 = curve.getFirstChild();
            while (i3 != null) {
                if (i3 instanceof DPoint) {
                    DCoord b1c1 = null;
                    DCoord b1c2 = null;
                    DCoord b2c1 = null;
                    DCoord b2c2 = null;
                    DPoint point1 = null;
                    DPoint point2 = null;
                    DPoint point = (DPoint)i3;
                    IDItem ic = point.getFirstChild();
                    while (ic != null) {
                        if (ic instanceof DCoord) {
                            DCoord coord = (DCoord)ic;
                            DAxis axis = coord.getAxis();
                            if (axis == p.axis1) {
                                point1 = point;
                                if (b1c1 == null) {
                                    b1c1 = coord;
                                } else if (!p.one_value && b1c2 == null) {
                                    b1c2 = coord;
                                }
                            } else if (axis == p.axis2 && !one_hbar) {
                                point2 = point;
                                if (b2c1 == null) {
                                    b2c1 = coord;
                                } else if (!p.one_value && b2c2 == null) {
                                    b2c2 = coord;
                                }
                            }
                        }
                        ic = ic.getNext();
                    }
                    HBarData b1 = null;
                    HBarData b2 = null;
                    if (b1c1 != null && (p.one_value || !p.one_value && b1c2 != null)) {
                        b1 = DefaultChartRenderHBars.createHBarData(d, p, b1c1, b1c2, point1, val1, val2, p.scale1, true);
                    }
                    if (b2c1 != null && (p.one_value || !p.one_value && b2c2 != null)) {
                        b2 = DefaultChartRenderHBars.createHBarData(d, p, b2c1, b2c2, point2, val1, val2, p.scale2, false);
                    }
                    if (b1 != null || b2 != null) {
                        if (b1 != null) {
                            b1.title_style = cs;
                            d.gc_.setFont(cs.style_.getFont());
                            b1.title = DefaultChartRenderData.getResourceString(curve.getName(), (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
                            b1.title_extend = DrawUtilIGC.textExtent(d.gc_, b1.title, 1);
                            int w_title = b1.title_extend.getW();
                            if (w_title > p.w_max_title) {
                                p.w_max_title = w_title;
                            }
                        }
                        if (b1 != null && b2 != null) {
                            while (p.bars1.size() < p.bars2.size()) {
                                p.bars1.add(null);
                            }
                            while (p.bars2.size() < p.bars1.size()) {
                                p.bars2.add(null);
                            }
                        }
                        if (b1 != null) {
                            p.bars1.add(b1);
                        }
                        if (!one_hbar && b2 != null) {
                            p.bars2.add(b2);
                        }
                    }
                }
                i3 = i3.getNext();
            }
            ++icrv2;
        }
        p.num_lines = Math.max(p.bars1.size(), one_hbar ? 0 : p.bars2.size());
        if (p.num_lines == 0) {
            return;
        }
        boolean truncate_title = false;
        boolean truncate_v_begin1 = false;
        boolean truncate_v_end1 = false;
        boolean truncate_v_begin2 = false;
        boolean truncate_v_end2 = false;
        int wg = rpd.ag_rect.w();
        int n = div = one_hbar ? 4 : 8;
        if (p.w_max_v_begin1 > wg / div) {
            p.w_max_v_begin1 = wg / div;
            truncate_v_begin1 = true;
        }
        if (p.w_max_v_end1 > wg / div) {
            p.w_max_v_end1 = wg / div;
            truncate_v_end1 = true;
        }
        int wc = p.w_max_v_begin1 + p.w_max_v_end1;
        if (!one_hbar) {
            if (p.w_max_v_begin2 > wg / div) {
                p.w_max_v_begin2 = wg / div;
                truncate_v_begin2 = true;
            }
            if (p.w_max_v_end2 > wg / div) {
                p.w_max_v_end2 = wg / div;
                truncate_v_end2 = true;
            }
            wc += p.w_max_v_begin2 + p.w_max_v_end2;
        }
        if ((w = p.w_max_title + wc) > wg / 2) {
            p.w_max_title = wg / 2 - wc;
            truncate_title = true;
        }
        DPropertyStore p_axis1 = p.axis1.getProperties();
        Object vmin1 = p_axis1.get("P_MIN.DAxis.core.jscrib");
        Object vmax1 = p_axis1.get("P_MAX.DAxis.core.jscrib");
        if ((vmin1 == null || vmax1 == null) && (mm = DefaultChartRenderHBars.computeMinMax(p, true)) != null) {
            vmin1 = mm.getVMin();
            vmax1 = mm.getVMax();
        }
        p.scale1.setValueRange(vmin1, vmax1);
        DPropertyStore p_axis2 = null;
        if (!one_hbar) {
            MinMax mm2;
            p_axis2 = p.axis2.getProperties();
            Object vmin2 = p_axis2.get("P_MIN.DAxis.core.jscrib");
            Object vmax2 = p_axis2.get("P_MAX.DAxis.core.jscrib");
            if ((vmin2 == null || vmax2 == null) && (mm2 = DefaultChartRenderHBars.computeMinMax(p, false)) != null) {
                vmin2 = mm2.getVMin();
                vmax2 = mm2.getVMax();
            }
            p.scale2.setValueRange(vmin2, vmax2);
        }
        p.show_title = p.w_max_title > d.dpiX(20);
        p.show_v_begin1 = one_hbar && !p.one_value && p.w_max_v_begin1 > d.dpiX(15);
        p.show_v_end1 = (p.one_value || one_hbar) && p.w_max_v_end1 > d.dpiX(15);
        p.show_v_begin2 = false;
        p.show_v_end2 = !one_hbar && p.one_value && p.w_max_v_end2 > d.dpiX(15);
        p.x_v_begin1 = p.show_title ? rpd.ag_rect.x() + p.w_max_title + 5 : 0;
        p.x_v_end1 = p.show_v_end1 ? rpd.ag_rect.right() - p.w_max_v_end1 : rpd.ag_rect.right();
        p.x_v_end2 = p.show_v_end2 ? rpd.ag_rect.x() + p.w_max_title + 5 : 0;
        int xl_graph1 = -1;
        int xr_graph1 = p.show_v_end1 ? p.x_v_end1 - 5 : rpd.ag_rect.right();
        int xl_graph2 = -1;
        int xr_graph2 = -1;
        if (one_hbar) {
            xl_graph1 = p.show_v_begin1 ? p.x_v_begin1 + p.w_max_v_begin1 + 5 : (p.show_title ? rpd.ag_rect.x() + p.w_max_title + 5 : rpd.ag_rect.left());
        } else {
            xl_graph2 = p.show_v_end2 ? p.x_v_end2 + p.w_max_v_end2 + 5 : (p.show_title ? rpd.ag_rect.x() + p.w_max_title + 5 : rpd.ag_rect.left());
            int mid_graph = (xr_graph1 + xl_graph2) / 2;
            xl_graph1 = mid_graph + 2;
            xr_graph2 = xl_graph1 - 5;
        }
        rpd.ag_rect.setLeft(one_hbar ? xl_graph1 : xl_graph2);
        rpd.ag_rect.setRight(xr_graph1);
        p.scale1.setScaleRange(xl_graph1, xr_graph1);
        if (!one_hbar) {
            p.scale2.setReversed(true);
            p.scale2.setScaleRange(xr_graph2, xl_graph2);
        }
        p.axis1_am = d.computeXAxisAmounts(p.axis1, p.scale1, rpd.ag_rect, 20, null);
        int max_h = p.axis1_am.getB();
        if (!one_hbar) {
            p.axis2_am = d.computeXAxisAmounts(p.axis2, p.scale2, rpd.ag_rect, 20, null);
            max_h = Math.max(max_h, p.axis2_am.getB());
        }
        rpd.ag_rect.setHeight(rpd.ag_rect.h() - max_h);
        if (p.axis1_style == null) {
            p.axis1_style = new IGCDStyle(p.axis1, d.scale_);
            IGCDStyle iGCDStyle = p.axis2_style = one_hbar ? null : new IGCDStyle(p.axis2, d.scale_);
        }
        if (truncate_title && p.show_title && p.bars1 != null) {
            int i4 = 0;
            while (i4 < p.bars1.size()) {
                HBarData b2 = (HBarData)p.bars1.get(i4);
                d.gc_.setFont(b2.title_style.style_.getFont());
                b2.title = DrawUtilIGC.truncateText(d.gc_, b2.title, p.w_max_title, 0, 1);
                ++i4;
            }
        }
        boolean do_begin = truncate_v_begin1 && p.show_v_begin1;
        boolean bl = do_end = truncate_v_end1 && p.show_v_end1;
        if (do_begin || do_end && p.bars1 != null) {
            i = 0;
            while (i < p.bars1.size()) {
                b = (HBarData)p.bars1.get(i);
                d.gc_.setFont(b.bar_style.getFont());
                if (do_begin) {
                    b.begin_text = DrawUtilIGC.truncateText(d.gc_, b.begin_text, p.w_max_v_begin1, 0, 2);
                }
                if (do_end) {
                    b.end_text = DrawUtilIGC.truncateText(d.gc_, b.end_text, p.w_max_v_end1, 0, 2);
                }
                ++i;
            }
        }
        do_begin = truncate_v_begin2 && p.show_v_begin2;
        boolean bl2 = do_end = truncate_v_end2 && p.show_v_end2;
        if (do_begin || do_end && p.bars2 != null) {
            i = 0;
            while (i < p.bars2.size()) {
                b = (HBarData)p.bars2.get(i);
                d.gc_.setFont(b.bar_style.getFont());
                if (do_begin) {
                    b.begin_text = DrawUtilIGC.truncateText(d.gc_, b.begin_text, p.w_max_v_begin2, 0, 2);
                }
                if (do_end) {
                    b.end_text = DrawUtilIGC.truncateText(d.gc_, b.end_text, p.w_max_v_end2, 0, 2);
                }
                ++i;
            }
        }
    }

    private static MinMax computeMinMax(RPDHBars p, boolean for_axis1) {
        DAxis axis;
        boolean one_value = p.one_value;
        Vector bars = for_axis1 ? p.bars1 : p.bars2;
        DAxis dAxis = axis = for_axis1 ? p.axis1 : p.axis2;
        if (axis == null || bars == null || bars.size() == 0) {
            return null;
        }
        MinMax mm = new MinMax(axis);
        HBarData bd2 = null;
        if (one_value) {
            for (HBarData bd2 : bars) {
                mm.update(bd2.c_end);
            }
        } else {
            for (HBarData bd2 : bars) {
                mm.update(bd2.c_begin);
                mm.update(bd2.c_end);
            }
        }
        return mm;
    }

    private static class HBarData
    implements IDisposable {
        public String title;
        public ISize title_extend;
        public CurveStyle title_style;
        public IDCoord c_begin;
        public IDCoord c_end;
        public String begin_text;
        public String end_text;
        public IGCDStyle bar_style;
        public DPoint point;
        public ISize begin_extend;
        public ISize end_extend;

        private HBarData() {
        }

        public void dispose() {
        }
    }

    private static class RPDHBars
    implements IDisposable {
        DAxis axis1;
        DAxis axis2;
        IGCDStyle axis1_style;
        IGCDStyle axis2_style;
        Insets axis1_am;
        Insets axis2_am;
        IScale scale1;
        IScale scale2;
        int w_max_title = 0;
        int w_max_v_begin1 = 0;
        int w_max_v_end1 = 0;
        int w_max_v_begin2 = 0;
        int w_max_v_end2 = 0;
        int num_lines;
        boolean one_value = true;
        Vector bars1 = new Vector();
        Vector bars2;
        boolean show_title;
        boolean show_v_begin1;
        boolean show_v_end1;
        boolean show_v_begin2;
        boolean show_v_end2;
        int x_v_begin1;
        int x_v_end1;
        int x_v_end2;

        private RPDHBars() {
        }

        public void dispose() {
            int i;
            if (this.bars1 != null) {
                i = 0;
                while (i < this.bars1.size()) {
                    ((HBarData)this.bars1.get(i)).dispose();
                    ++i;
                }
                this.bars1.clear();
            }
            if (this.bars2 != null) {
                i = 0;
                while (i < this.bars2.size()) {
                    ((HBarData)this.bars2.get(i)).dispose();
                    ++i;
                }
                this.bars2.clear();
            }
            this.bars1 = null;
            this.bars2 = null;
        }
    }
}

