/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IShape;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class DefaultChartRenderHStackBars {
    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        RPDSBars p = null;
        if (rpd.g instanceof RPDSBars) {
            p = (RPDSBars)rpd.g;
        }
        if (p == null) {
            p = DefaultChartRenderHStackBars.rebuildData(d, rpd);
        }
        if (p.axis == null) {
            if (d.drawing()) {
                d.error("Error: Missing axis", rpd);
            }
            return;
        }
        if (!p.scale.isValid()) {
            if (d.drawing()) {
                d.error("Error: invalid scale", rpd);
            }
            return;
        }
        int n_bars = p.bars.size();
        if (n_bars == 0) {
            return;
        }
        double xbar = rpd.ag_rect.top();
        double ybase = p.scale.getScaleForBar();
        if (rpd.ag_rect.w() <= 0 || rpd.ag_rect.h() <= 0) {
            return;
        }
        LineStylePen pen = new LineStylePen();
        d.renderYAxis(false, true, true, p.axis, p.scale, rpd.ag_rect, p.am, p.sty_axis, 4, p._3d_z, p._3d_z);
        if (d.drawing()) {
            pen.setRGBA(p.sty_axis.getFore());
            d.gc_.setPen(pen);
            int left = rpd.ag_rect.left();
            d.gc_.drawLine((int)ybase, rpd.ag_rect.top(), (int)ybase, rpd.ag_rect.bottom());
            d.gc_.drawLine(left, rpd.ag_rect.top(), rpd.ag_rect.right(), rpd.ag_rect.top());
        }
        Object val = null;
        Rect r = new Rect();
        DefaultRenderChartLocation last_loc = null;
        IShape save_clip = null;
        if (d.drawing()) {
            save_clip = d.gc_.getClipping();
        }
        int label_alignment = p.label_alignment.getAlignment();
        for (Bar bar : p.bars) {
            if (d.drawing()) {
                d.gc_.setClipping(new Rect(rpd.ag_rect.left(), rpd.ag_rect.top() - p._3d_z, rpd.ag_rect.right() + 1, rpd.ag_rect.bottom() + p._3d_z));
            }
            double ypoint = ybase;
            for (Point pt : bar.points) {
                val = pt.coord.getValue(val);
                double ys = p.scale.toScale(val);
                double bh = ys - ybase;
                int xb = (int)(xbar + (double)p.xdecbar);
                r.setRect((int)ypoint, xb, (int)bh, (int)(xbar + (double)p.xdecbar + (double)p.wbar - (double)xb));
                r.normalize();
                ypoint += bh;
                try {
                    d.renderBar(false, r, pt.cs.style_.getBack(), pt.point, p._3d_z);
                }
                catch (DefaultRenderChartLocation loc) {
                    last_loc = loc;
                }
            }
            if (d.drawing()) {
                d.gc_.setClipping(null);
            }
            IGCDStyle style = bar.label_style == null ? p.sty_axis : bar.label_style;
            d.gc_.setFont(style.getFont());
            String txt = DrawUtilIGC.truncateText(d.gc_, bar.text, p.available_labels_height, (int)p.wbartobar, label_alignment);
            if (!DrawUtilIGC.isEmpty(txt)) {
                IShape rc = d.gc_.getClipping();
                d.gc_.setClipping(null);
                String id = bar.label != null ? "LabelText" : "InAxisXUnit";
                DItem loc_item = bar.label != null ? bar.label : p.axis;
                Rect rtxt = new Rect(rpd.ag_rect.left() - d.axis_unit_to_dot_spacing - p.available_labels_height, (int)xbar, p.available_labels_height, (int)p.wbartobar - d.dpiX(2));
                d.renderText(txt, rtxt, label_alignment, style, id, loc_item);
                d.gc_.setClipping(rc);
            }
            xbar += (double)p.wbartobar;
        }
        if (save_clip != null) {
            d.gc_.setClipping(save_clip);
        }
        if (last_loc != null) {
            throw last_loc;
        }
        d.renderYAxis(false, false, true, p.axis, p.scale, rpd.ag_rect, p.am, p.sty_axis, 128, p._3d_z, p._3d_z);
    }

    private static RPDSBars rebuildData(DefaultChartRenderData d, RenderPersistData rpd) {
        RPDSBars p = new RPDSBars();
        rpd.g = p;
        IDItem i = rpd.graphic.getFirstChild();
        while (i != null) {
            if (i instanceof DAxis) {
                p.axis = (DAxis)i;
                break;
            }
            i = i.getNext();
        }
        if (p.axis == null) {
            return p;
        }
        p.axis_use_numbers = p.axis.useNumbers();
        p.sty_axis = new IGCDStyle(p.axis, d.scale_);
        Object prop = p.axis.getProperties().get("P_LABEL_ALIGNMENT.DAxis.core.jscrib");
        p.label_alignment = prop instanceof IDAlignment ? (IDAlignment)prop : new DAlignment(36);
        p.bars = new Vector();
        int i2 = 0;
        while (i2 < rpd.curve_styles.length) {
            CurveStyle cs = rpd.curve_styles[i2];
            int ibar = 0;
            IDItem ip = cs.curve_.getFirstChild();
            while (ip != null) {
                if (ip instanceof DPoint) {
                    DPoint point = (DPoint)ip;
                    DText label = null;
                    IDCoord coord = null;
                    IDItem ic = ip.getFirstChild();
                    while (ic != null) {
                        if (ic instanceof DText) {
                            if (label == null) {
                                label = (DText)ic;
                            }
                        } else if (ic instanceof IDCoord) {
                            IDCoord crd = (IDCoord)((Object)ic);
                            if (coord == null && crd.getAxis() == p.axis) {
                                coord = crd;
                            }
                        }
                        if (coord != null && label != null) break;
                        ic = ic.getNext();
                    }
                    if (coord != null) {
                        Bar bar = null;
                        if (ibar >= p.bars.size()) {
                            bar = new Bar();
                            bar.sum = 0.0;
                            p.bars.add(bar);
                        } else {
                            bar = (Bar)p.bars.get(ibar);
                        }
                        if (bar.label == null) {
                            bar.label = label;
                        }
                        Point pp = new Point();
                        pp.cs = cs;
                        pp.point = point;
                        pp.coord = coord;
                        bar.points.add(pp);
                        if (p.axis_use_numbers) {
                            double vp = ((Number)coord.getValue(null)).doubleValue();
                            bar.sum += Math.abs(vp);
                        }
                    }
                }
                ip = ip.getNext();
                ++ibar;
            }
            ++i2;
        }
        Object v_min = p.axis.getProperties().get("P_MIN.DAxis.core.jscrib");
        Object v_max = p.axis.getProperties().get("P_MAX.DAxis.core.jscrib");
        if (v_min == null || v_max == null) {
            if (p.axis_use_numbers) {
                if (v_min == null) {
                    v_min = new Double(0.0);
                }
                if (v_max == null) {
                    double max = 0.0;
                    boolean init = false;
                    Iterator it = p.bars.iterator();
                    while (it.hasNext()) {
                        double b_sum = ((Bar)it.next()).sum;
                        if (init) {
                            max = Math.max(max, b_sum);
                            continue;
                        }
                        max = b_sum;
                        init = true;
                    }
                    if (init) {
                        v_max = new Double(max);
                    }
                }
            } else {
                if (v_min == null) {
                    v_min = p.axis.getProperties().get("P_MIN_HINT.DAxis.core.jscrib");
                }
                if (v_max == null) {
                    v_max = p.axis.getProperties().get("P_MAX_HINT.DAxis.core.jscrib");
                }
            }
        }
        p.scale = DefaultChartRenderData.getScale(p.axis, 0.0, 0.0, v_min, v_max);
        p.am = d.computeYAxisAmounts(false, true, p.axis, p.scale, rpd.ag_rect, 128, null);
        rpd.ag_rect.setLeft(rpd.ag_rect.left() + p.am.getL());
        rpd.ag_rect.setTop(rpd.ag_rect.top() + p.am.getT());
        rpd.ag_rect.setBottom(rpd.ag_rect.bottom() - p.am.getB());
        int n_bars = p.bars.size();
        if (n_bars == 0) {
            return p;
        }
        p.thin_bar = rpd.graphic.getProperties().get("P_THIN_BAR.DGraphic.core.jscrib", false);
        boolean _3d = rpd.graphic.getProperties().get("P_3D.DGraphic.core.jscrib", false);
        float kthinbar = p.thin_bar ? 0.7f : 1.0f;
        p.wbartobar = 0.0f;
        p.wbartobar = _3d ? (float)rpd.ag_rect.h() / (float)((double)n_bars + 0.5 * (double)kthinbar) : (float)rpd.ag_rect.h() / (float)n_bars;
        p.wbar = kthinbar * p.wbartobar;
        p.xdecbar = p.thin_bar ? (p.wbartobar - p.wbar) / 2.0f : 0.0f;
        p._3d_z = 0;
        if (_3d) {
            p._3d_z = (int)(0.5f * p.wbar);
            rpd.ag_rect.setWidth(rpd.ag_rect.w() - p._3d_z);
            rpd.ag_rect.setTop(rpd.ag_rect.top() + p._3d_z);
        }
        int max_label_text_height = 0;
        for (Bar bar : p.bars) {
            IGCDStyle style = p.sty_axis;
            if (bar.label != null) {
                style = bar.label_style = new IGCDStyle(bar.label, d.scale_);
                bar.text = bar.label.getText();
            } else if (p.axis_use_numbers) {
                bar.text = p.scale.valueText(new Double(bar.sum));
            }
            if (bar.text == null) continue;
            d.gc_.setFont(style.getFont());
            int label_w = DrawUtilIGC.textExtent(d.gc_, bar.text, p.label_alignment.getAlignment()).getW();
            if (label_w <= max_label_text_height) continue;
            max_label_text_height = label_w;
        }
        int labels_limit_height = (int)(0.5f * (float)rpd.ag_rect.w());
        p.available_labels_height = Math.min(labels_limit_height, max_label_text_height);
        rpd.ag_rect.setLeft(rpd.ag_rect.left() + p.available_labels_height + d.axis_title_to_unit_spacing);
        p.scale.setScaleRange(rpd.ag_rect.left(), rpd.ag_rect.right());
        return p;
    }

    private static class Bar
    implements IDisposable {
        public double sum;
        public Vector points = new Vector();
        public DText label;
        public IGCDStyle label_style;
        public String text;

        private Bar() {
        }

        public void dispose() {
        }
    }

    private static class Point {
        CurveStyle cs;
        DPoint point;
        IDCoord coord;

        private Point() {
        }
    }

    private static class RPDSBars
    implements IDisposable {
        public DAxis axis;
        public boolean axis_use_numbers;
        public IDAlignment label_alignment;
        public IGCDStyle sty_axis;
        public IScale scale;
        public Insets am;
        public int available_labels_height;
        public Vector bars;
        public boolean thin_bar;
        float wbartobar;
        float wbar;
        float xdecbar;
        int _3d_z;

        private RPDSBars() {
        }

        public void dispose() {
            if (this.bars != null) {
                Iterator it = this.bars.iterator();
                while (it.hasNext()) {
                    ((Bar)it.next()).dispose();
                }
            }
        }
    }
}

