/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.tptp.platform.report.chart.internal.Box3D;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.chart.internal.View3D;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.Point3D;
import org.eclipse.tptp.platform.report.drawutil.internal.Vector3D;
import org.eclipse.tptp.platform.report.igc.internal.ISize;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class DefaultChartRenderPie3D {
    private static SolidBrush brush;

    private static boolean isValidPersistData(H3D p, DefaultChartRenderData d, RenderPersistData rpd) {
        return p != null;
    }

    public static void render(DefaultChartRenderData d, RenderPersistData rpd, boolean pie3d) throws DefaultRenderChartLocation {
        H3D p = null;
        if (rpd.g instanceof H3D) {
            p = (H3D)rpd.g;
        }
        if (!DefaultChartRenderPie3D.isValidPersistData(p, d, rpd)) {
            p = DefaultChartRenderPie3D.rebuildPersistData(d, rpd);
        }
        if (p.axis == null) {
            if (d.drawing()) {
                String txt = "Error: missing axis";
                d.error(txt, rpd);
            }
            return;
        }
        String axis_unit = p.axis.getUnit();
        if (axis_unit == null) {
            axis_unit = "";
        }
        IScale scale = DefaultChartRenderData.getScale(p.axis, 0.0, 0.0, null, null);
        boolean show_values = rpd.graphic.getProperties().get("P_SHOW_VALUES.DGraphic.core.jscrib", true) || rpd.graphic.getProperties().get("P_SHOW_PERCENTAGE.DGraphic.core.jscrib", false);
        p.shadow = rpd.graphic.getProperties().get("P_3D_SHADOW.DGraphic.core.jscrib", 0.5f);
        p.light = rpd.graphic.getProperties().get("P_3D_LIGHT.DGraphic.core.jscrib", 0.6f);
        double[] values = new double[20];
        IDItem[] items = new IDItem[20];
        String[] labels = show_values ? new String[20] : null;
        double[] shifts = new double[20];
        double max_shift = 0.0;
        boolean have_shift = false;
        double sum = 0.0;
        int nvalues = 0;
        Object ov = null;
        int i = 0;
        while (i < rpd.curve_styles.length) {
            double curr_shift = rpd.curve_styles[i].curve_.getProperties().get("SHIFT_SECTOR.DCurve.core.jscrib", 0.0);
            have_shift |= (curr_shift = Math.abs(curr_shift)) > 0.0;
            max_shift = Math.max(max_shift, curr_shift);
            IDItem it = rpd.curve_styles[i].curve_.getFirstChild();
            while (it != null) {
                if (it instanceof DPoint) {
                    double v;
                    DPoint cfr_ignored_0 = (DPoint)it;
                    IDCoord coord = null;
                    DText label = null;
                    IDItem ic = it.getFirstChild();
                    while (ic != null) {
                        if (ic instanceof IDCoord) {
                            IDCoord c = (IDCoord)((Object)ic);
                            if (c.getAxis() == p.axis) {
                                coord = c;
                            }
                        } else if (ic instanceof DText) {
                            label = (DText)ic;
                        }
                        ic = ic.getNext();
                    }
                    if (coord != null && (ov = coord.getValue(ov)) instanceof Number && (v = Math.abs(((Number)ov).doubleValue())) != 0.0) {
                        if (nvalues >= values.length) {
                            int s = nvalues + 10;
                            double[] av = new double[s];
                            System.arraycopy(values, 0, av, 0, nvalues);
                            values = av;
                            IDItem[] ap = new IDItem[s];
                            System.arraycopy(items, 0, ap, 0, nvalues);
                            items = ap;
                            if (show_values) {
                                String[] al = new String[s];
                                System.arraycopy(labels, 0, al, 0, nvalues);
                                labels = al;
                            }
                            av = new double[s];
                            System.arraycopy(shifts, 0, av, 0, nvalues);
                            shifts = av;
                        }
                        items[nvalues] = it;
                        values[nvalues] = v;
                        shifts[nvalues] = curr_shift;
                        sum += v;
                        if (show_values) {
                            if (label != null) {
                                labels[nvalues] = label.getText();
                                items[nvalues] = label;
                                if ("".equals(labels[nvalues])) {
                                    labels[nvalues] = null;
                                }
                            } else {
                                labels[nvalues] = scale.valueText(ov);
                                if ("".equals(labels[nvalues])) {
                                    labels[nvalues] = null;
                                } else {
                                    int n = nvalues;
                                    labels[n] = String.valueOf(labels[n]) + axis_unit;
                                }
                            }
                        }
                        ++nvalues;
                    }
                }
                it = it.getNext();
            }
            ++i;
        }
        if (nvalues == 0) {
            return;
        }
        if (nvalues == 1) {
            have_shift = false;
        }
        double h = pie3d ? rpd.graphic.getProperties().get("P_3D_HEIGHT.DGraphic.core.jscrib", 0.25) : 0.25;
        double Rx = have_shift ? 2.0 * (max_shift + 1.0) * 0.5 : 1.0;
        p.bbox = new Box3D(0.0, h, 0.0, Rx, 0.0, Rx);
        double phi = rpd.graphic.getProperties().get("P_XYZ_PHI.DGraphic.core.jscrib", 0.3);
        double theta = rpd.graphic.getProperties().get("P_XYZ_THETA.DGraphic.core.jscrib", 0.2);
        View3D view = new View3D(phi, theta, 0.0, 1.0, p.bbox);
        view.scaleTo(rpd.ag_rect.x(), rpd.ag_rect.y(), rpd.ag_rect.w(), rpd.ag_rect.h());
        double ntheta = Radian.normalize(view.getTheta());
        boolean x_incr = ntheta <= 1.5707963267948966 || ntheta >= 4.71238898038469;
        boolean y_incr = 0.0 <= ntheta && ntheta <= Math.PI;
        double nphi = Radian.normalize(view.getPhi());
        if (0.0 <= nphi) {
            // empty if block
        }
        if (nphi > 1.5707963267948966 && nphi < 4.71238898038469) {
            x_incr = !x_incr;
            y_incr = !y_incr;
        }
        LRect[] r_labels = null;
        Insets insets = new Insets();
        if (show_values) {
            r_labels = DefaultChartRenderPie3D.renderLabels(d, rpd, p, nvalues, values, labels, items, shifts, have_shift, view, sum, x_incr, insets);
        }
        view.scaleTo(rpd.ag_rect.x() + insets.getL(), rpd.ag_rect.y() + insets.getT(), rpd.ag_rect.w() - insets.getW(), rpd.ag_rect.h() - insets.getH());
        Vector3D view_vector = view.getViewVector(null);
        view_vector.normalize();
        if (pie3d) {
            DefaultChartRenderPie3D.renderSector(nvalues, sum, values, items, labels, r_labels, shifts, have_shift, d, p, x_incr, view, view_vector);
        } else {
            DefaultChartRenderPie3D.renderTorus(nvalues, sum, values, items, labels, r_labels, shifts, have_shift, d, p, x_incr, view, view_vector);
        }
    }

    private static void renderPolygon(IDItem _item, DefaultChartRenderData d, H3D h3d, int rgba, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        if (d.drawing()) {
            double k = Math.abs(Vector3D.Scalar(v, view_vector));
            if (brush == null) {
                brush = new SolidBrush();
            }
            brush.setRGBA(RGBA.Shadow(rgba, h3d.shadow, h3d.light, (float)k));
            d.gc_.setBrush(brush);
            d.gc_.fillPoly(p);
        } else if (p.contains(d.lx_, d.ly_)) {
            String loc_id = "CurveSector";
            if (_item instanceof DText) {
                _item = _item.getParent();
            }
            throw new DefaultRenderChartLocation(loc_id, _item, new Rect(d.lx_, d.ly_, 0, 0));
        }
    }

    private static H3D rebuildPersistData(DefaultChartRenderData d, RenderPersistData rpd) {
        H3D p = new H3D();
        rpd.g = p;
        p.axis = null;
        IDItem item = rpd.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DAxis) {
                p.axis = (DAxis)item;
                break;
            }
            item = item.getNext();
        }
        if (p.axis == null) {
            return p;
        }
        return p;
    }

    private static void sortByXpj(ArrayList list, LRect[] r_labels, String[] labels, int xl, int xr, int margin) {
        if (list.size() > 0) {
            Object[] ar = list.toArray();
            Arrays.sort(ar);
            int xjc = 0;
            int labels_width = 0;
            int j = 0;
            while (j < ar.length) {
                XSort xs = (XSort)ar[j];
                xjc += xs.xpj;
                labels_width += r_labels[xs.index].getW() + margin;
                ++j;
            }
            int lx = (xjc /= ar.length) - (labels_width -= margin) / 2;
            if (lx < xl) {
                lx = xl;
            } else if (lx + labels_width > xr) {
                lx = xr - labels_width;
            }
            int j2 = 0;
            while (j2 < ar.length) {
                int i = ((XSort)ar[j2]).index;
                r_labels[i].moveTo(lx, r_labels[i].y());
                lx += r_labels[i].getW() + margin;
                ++j2;
            }
        }
        list.clear();
    }

    private static LRect[] renderLabels(DefaultChartRenderData d, RenderPersistData rpd, H3D p, int nvalues, double[] values, String[] labels, IDItem[] items, double[] shifts, boolean have_shifts, View3D view, double sum, boolean x_incr, Insets insets) throws DefaultRenderChartLocation {
        LRect[] r_labels = new LRect[nvalues];
        insets.reset();
        int i = 0;
        while (i < nvalues) {
            if (labels[i] != null) {
                d.gc_.setFont(IGCDStyle.GetFont(items[i], d.scale_));
                ISize size = d.gc_.textExtent(labels[i]);
                r_labels[i] = new LRect(0, 0, size.getW(), size.getH());
            }
            ++i;
        }
        int xl = rpd.ag_rect.x();
        int xr = rpd.ag_rect.right();
        int yt = rpd.ag_rect.top();
        int yb = rpd.ag_rect.bottom();
        int xtop = xl;
        int ytop = yt;
        int top_hmax = 0;
        int xbtm = xl;
        int ybtm = yb;
        int btm_hmax = 0;
        double a = 0.0;
        double xc = x_incr ? p.bbox.getXMax() : p.bbox.getXMin();
        double yc = 0.5 * p.bbox.getYMax();
        double zc = 0.5 * p.bbox.getZMax();
        double R = 0.5;
        Point3D pj = new Point3D();
        view.projection(xc, yc, zc, pj);
        int ycenter = (int)pj.getY();
        ArrayList<XSort> top_to_sort = new ArrayList<XSort>();
        ArrayList<XSort> btm_to_sort = new ArrayList<XSort>();
        int i2 = 0;
        while (i2 < nvalues) {
            double da = Math.PI * 2 * (values[i2] / sum);
            double ma = a + da / 2.0;
            a += da;
            if (r_labels[i2] != null) {
                boolean on_top;
                double lyc = yc;
                double lzc = zc;
                if (have_shifts && shifts[i2] > 0.0) {
                    double sht = R * shifts[i2];
                    lyc = yc + sht * Math.cos(ma);
                    lzc = zc - sht * Math.sin(ma);
                }
                view.projection(xc, lyc + R * Math.cos(ma), lzc - R * Math.sin(ma), pj);
                boolean bl = on_top = (int)pj.getY() <= ycenter;
                if (on_top) {
                    if (xtop + r_labels[i2].getW() > xr) {
                        DefaultChartRenderPie3D.sortByXpj(top_to_sort, r_labels, labels, xl, xr, d.margin_);
                        insets.addT(top_hmax + d.margin_);
                        ytop += top_hmax + d.margin_;
                        xtop = xl;
                        top_hmax = 0;
                    }
                    r_labels[i2].moveTo(xtop, ytop);
                    r_labels[i2].align = 8;
                    xtop += r_labels[i2].getW() + d.margin_;
                    top_hmax = Math.max(top_hmax, r_labels[i2].getH());
                    top_to_sort.add(new XSort(i2, (int)pj.getX()));
                } else {
                    if (xbtm + r_labels[i2].getW() > xr) {
                        DefaultChartRenderPie3D.sortByXpj(btm_to_sort, r_labels, labels, xl, xr, d.margin_);
                        insets.addB(btm_hmax + d.margin_);
                        ybtm -= btm_hmax + d.margin_;
                        xbtm = xl;
                        btm_hmax = 0;
                    }
                    r_labels[i2].moveTo(xbtm, ybtm - r_labels[i2].getH());
                    r_labels[i2].align = 16;
                    xbtm += r_labels[i2].getW() + d.margin_;
                    btm_hmax = Math.max(btm_hmax, r_labels[i2].getH());
                    btm_to_sort.add(new XSort(i2, (int)pj.getX()));
                }
            }
            ++i2;
        }
        DefaultChartRenderPie3D.sortByXpj(top_to_sort, r_labels, labels, xl, xr, d.margin_);
        DefaultChartRenderPie3D.sortByXpj(btm_to_sort, r_labels, labels, xl, xr, d.margin_);
        if (btm_hmax > 0) {
            insets.addB(btm_hmax + d.margin_);
        }
        if (top_hmax > 0) {
            insets.addT(top_hmax + d.margin_);
        }
        i2 = 0;
        while (i2 < nvalues) {
            if (labels[i2] != null) {
                IGCDStyle style = new IGCDStyle(items[i2]);
                String txt = DrawUtilIGC.truncateTextH(d.gc_, labels[i2], r_labels[i2].getW());
                String loc_id = items[i2] instanceof DText ? "LabelText" : "CurvePointText";
                d.renderText(txt, r_labels[i2], 36, style, loc_id, items[i2]);
            }
            ++i2;
        }
        return r_labels;
    }

    private static void renderTriangle(Face f, DefaultChartRenderData d, H3D h3d, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)f.pj[f.ip0].getX(), (int)f.pj[f.ip0].getY());
        p.setPoint(1, (int)f.pj[f.ip1].getX(), (int)f.pj[f.ip1].getY());
        p.setPoint(2, (int)f.pj[f.ip2].getX(), (int)f.pj[f.ip2].getY());
        v.vectorialProduct(f.pt[f.ip1].getX() - f.pt[f.ip0].getX(), f.pt[f.ip1].getY() - f.pt[f.ip0].getY(), f.pt[f.ip1].getZ() - f.pt[f.ip0].getZ(), f.pt[f.ip2].getX() - f.pt[f.ip1].getX(), f.pt[f.ip2].getY() - f.pt[f.ip1].getY(), f.pt[f.ip2].getZ() - f.pt[f.ip1].getZ());
        v.normalize();
        DefaultChartRenderPie3D.renderPolygon(f.item, d, h3d, IGCDStyle.GetBackColor(f.item), p, v, view_vector);
    }

    private static void renderQuad(Face f, DefaultChartRenderData d, H3D h3d, Polygon p, Vector3D v, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.setPoint(0, (int)f.pj[f.ip0].getX(), (int)f.pj[f.ip0].getY());
        p.setPoint(1, (int)f.pj[f.ip1].getX(), (int)f.pj[f.ip1].getY());
        p.setPoint(2, (int)f.pj[f.ip2].getX(), (int)f.pj[f.ip2].getY());
        p.setPoint(3, (int)f.pj[f.ip3].getX(), (int)f.pj[f.ip3].getY());
        v.vectorialProduct(f.pt[f.ip1].getX() - f.pt[f.ip0].getX(), f.pt[f.ip1].getY() - f.pt[f.ip0].getY(), f.pt[f.ip1].getZ() - f.pt[f.ip0].getZ(), f.pt[f.ip2].getX() - f.pt[f.ip1].getX(), f.pt[f.ip2].getY() - f.pt[f.ip1].getY(), f.pt[f.ip2].getZ() - f.pt[f.ip1].getZ());
        v.normalize();
        DefaultChartRenderPie3D.renderPolygon(f.item, d, h3d, IGCDStyle.GetBackColor(f.item), p, v, view_vector);
    }

    private static void renderSector(int nvalues, double sum, double[] values, IDItem[] items, String[] labels, LRect[] r_labels, double[] shifts, boolean have_shift, DefaultChartRenderData d, H3D p, boolean x_incr, View3D view, Vector3D view_vector) throws DefaultRenderChartLocation {
        p.bbox.getXMax();
        double yc = 0.5 * p.bbox.getYMax();
        double zc = 0.5 * p.bbox.getZMax();
        double x1 = p.bbox.getXMin();
        double x2 = p.bbox.getXMax();
        if (nvalues == 0) {
            return;
        }
        Vector3D v = new Vector3D();
        if (nvalues == 1) {
            Point3D[] pt = new Point3D[128];
            Point3D[] pj = new Point3D[128];
            double a = 0.0;
            int i = 0;
            while (i < 64) {
                double c = 0.5 * Math.cos(a);
                double s = 0.5 * Math.sin(a);
                pt[i] = new Point3D(x1, yc + c, zc - s);
                pt[64 + i] = new Point3D(x2, yc + c, zc - s);
                pj[i] = new Point3D();
                view.projection(pt[i], pj[i]);
                Point3D point3D = new Point3D();
                pj[i + 64] = point3D;
                view.projection(pt[i + 64], point3D);
                ++i;
                a += 0.09817477042468103;
            }
            Object[] faces = new AFace[66];
            int last_ip0 = 63;
            int last_ip1 = 127;
            int i0 = 0;
            int i1 = 64;
            while (i0 < 64) {
                faces[i0] = new Face(0, items[0], last_ip0, i0, i1, last_ip1, pt, pj);
                last_ip0 = i0++;
                last_ip1 = i1++;
            }
            int[] ip0 = new int[64];
            int[] ip1 = new int[64];
            int i2 = 0;
            while (i2 < 64) {
                ip0[i2] = i2;
                ip1[i2] = 64 + i2;
                ++i2;
            }
            faces[64] = new FaceN(0, items[0], ip0, pt, pj);
            faces[65] = new FaceN(0, items[0], ip1, pt, pj);
            Arrays.sort(faces, 0, faces.length);
            Polygon pN = new Polygon(64);
            Polygon p4 = new Polygon(4);
            int i3 = faces.length - 1;
            while (i3 >= 0) {
                AFace f;
                Object face = faces[i3];
                if (face instanceof FaceN) {
                    f = (FaceN)face;
                    int ip = 0;
                    while (ip < 64) {
                        int ji = f.ip[ip];
                        pN.setPoint(ip, (int)pj[ji].getX(), (int)pj[ji].getY());
                        ++ip;
                    }
                    if (f == faces[64]) {
                        v.setVector(-1.0, 0.0, 0.0);
                    } else {
                        v.setVector(1.0, 0.0, 0.0);
                    }
                    DefaultChartRenderPie3D.renderPolygon(items[0], d, p, IGCDStyle.GetBackColor(items[0]), pN, v, view_vector);
                } else {
                    f = (Face)face;
                    DefaultChartRenderPie3D.renderQuad((Face)f, d, p, p4, v, view_vector);
                }
                --i3;
            }
        } else {
            ArrayList<Face> faces = new ArrayList<Face>();
            ArrayList<AFace> front = new ArrayList<AFace>();
            ArrayList<AFace> back = new ArrayList<AFace>();
            double last_angle = 0.0;
            int iv = 0;
            while (iv < nvalues) {
                int npt;
                double delta_angle = Math.PI * 2 * (values[iv] / sum);
                double end_angle = last_angle + delta_angle;
                double lyc = yc;
                double lzc = zc;
                if (have_shift && shifts[iv] > 0.0) {
                    double sht = 0.5 * shifts[iv];
                    double am = (last_angle + end_angle) / 2.0;
                    lyc = yc + sht * Math.cos(am);
                    lzc = zc - sht * Math.sin(am);
                }
                if ((npt = (int)Math.round(delta_angle / 0.09817477042468103)) <= 1) {
                    Point3D[] lpt = new Point3D[6];
                    Point3D[] lpj = new Point3D[6];
                    lpt[0] = new Point3D(x1, lyc, lzc);
                    double y1 = lyc + 0.5 * Math.cos(last_angle);
                    double z1 = lzc - 0.5 * Math.sin(last_angle);
                    double y2 = lyc + 0.5 * Math.cos(end_angle);
                    double z2 = lzc - 0.5 * Math.sin(end_angle);
                    lpt[1] = new Point3D(x1, y1, z1);
                    lpt[2] = new Point3D(x1, y2, z2);
                    lpt[3] = new Point3D(x2, lyc, lzc);
                    lpt[4] = new Point3D(x2, y1, z1);
                    lpt[5] = new Point3D(x2, y2, z2);
                    int i = 0;
                    while (i < 6) {
                        lpj[i] = new Point3D();
                        view.projection(lpt[i], lpj[i]);
                        ++i;
                    }
                    faces.add(new Face(iv, items[iv], 1, 4, 5, 2, lpt, lpj));
                    if (have_shift) {
                        faces.add(new Face(iv, items[iv], 3, 4, 1, 0, lpt, lpj));
                        faces.add(new Face(iv, items[iv], 5, 3, 0, 2, lpt, lpj));
                    }
                    Face f = new Face(iv, items[iv], 0, 1, 2, lpt, lpj);
                    f.medium_angle = last_angle + delta_angle / 2.0;
                    back.add(f);
                    f = new Face(iv, items[iv], 3, 5, 4, lpt, lpj);
                    f.medium_angle = last_angle + delta_angle / 2.0;
                    front.add(f);
                } else {
                    double lai = delta_angle / (double)(npt - 1);
                    double a = last_angle;
                    Point3D[] lpt = new Point3D[2 * npt + 2];
                    Point3D[] lpj = new Point3D[2 * npt + 2];
                    lpt[0] = new Point3D(x1, lyc, lzc);
                    lpt[npt + 1] = new Point3D(x2, lyc, lzc);
                    int i = 1;
                    while (i <= npt) {
                        double y = lyc + 0.5 * Math.cos(a);
                        double z = lzc - 0.5 * Math.sin(a);
                        lpt[i] = new Point3D(x1, y, z);
                        lpt[i + npt + 1] = new Point3D(x2, y, z);
                        ++i;
                        a += lai;
                    }
                    i = 0;
                    while (i < lpt.length) {
                        lpj[i] = new Point3D();
                        view.projection(lpt[i], lpj[i]);
                        ++i;
                    }
                    int[] fn_ip0 = new int[npt + 1];
                    int[] fn_ip1 = new int[npt + 1];
                    fn_ip0[0] = 0;
                    fn_ip1[0] = npt + 1;
                    int i4 = 1;
                    while (i4 <= npt) {
                        fn_ip0[i4] = i4;
                        fn_ip1[i4] = i4 + npt + 1;
                        ++i4;
                    }
                    FaceN f = new FaceN(iv, items[iv], fn_ip0, lpt, lpj);
                    f.medium_angle = last_angle + delta_angle / 2.0;
                    back.add(f);
                    f = new FaceN(iv, items[iv], fn_ip1, lpt, lpj);
                    f.medium_angle = last_angle + delta_angle / 2.0;
                    front.add(f);
                    int lip0 = 1;
                    int lip1 = npt + 2;
                    int ip0 = 2;
                    int ip1 = npt + 3;
                    while (ip0 <= npt) {
                        Face ff = new Face(iv, items[iv], lip1, ip1, ip0, lip0, lpt, lpj);
                        faces.add(ff);
                        lip0 = ip0++;
                        lip1 = ip1++;
                    }
                    if (have_shift) {
                        faces.add(new Face(iv, items[iv], npt + 1, npt + 2, 1, 0, lpt, lpj));
                        faces.add(new Face(iv, items[iv], 0, npt, 2 * npt + 1, npt + 1, lpt, lpj));
                    }
                }
                last_angle = end_angle;
                ++iv;
            }
            Object[] of = faces.toArray();
            Arrays.sort(of, 0, of.length);
            Polygon pN = new Polygon(64);
            Polygon p4 = new Polygon(4);
            Polygon p3 = new Polygon(3);
            boolean decr = d.drawing();
            int i0 = decr ? of.length - 1 : 0;
            int iX = decr ? 0 : of.length - 1;
            int ii = decr ? -1 : 1;
            DefaultRenderChartLocation loc = null;
            try {
                int i = i0;
                while (ii == 1 && i <= iX || ii == -1 && i >= iX) {
                    AFace face = (AFace)of[i];
                    DefaultChartRenderPie3D.renderFace(face, p3, p4, pN, v, view_vector, d, p, false);
                    i += ii;
                }
            }
            catch (DefaultRenderChartLocation l) {
                loc = l;
            }
            ArrayList<AFace> front_faces = x_incr ? front : back;
            decr = d.drawing();
            i0 = decr ? front_faces.size() - 1 : 0;
            iX = decr ? 0 : front_faces.size() - 1;
            ii = decr ? -1 : 1;
            int i = i0;
            while (ii == 1 && i <= iX || ii == -1 && i >= iX) {
                DefaultChartRenderPie3D.renderFace((AFace)front_faces.get(i), p3, p4, pN, v, view_vector, d, p, false);
                i += ii;
            }
            if (labels != null && d.drawing()) {
                d.gc_.setPen(new LineStylePen(255));
                Point3D pj = new Point3D();
                double xj = x_incr ? x2 : x1;
                int i5 = 0;
                while (i5 < front_faces.size()) {
                    AFace face = (AFace)front_faces.get(i5);
                    int index = face.item_index;
                    if (labels[index] != null) {
                        int yt;
                        int xt;
                        IDItem cfr_ignored_0 = items[face.item_index];
                        double ma = face.medium_angle;
                        double lyc = yc;
                        double lzc = zc;
                        if (have_shift && shifts[index] > 0.0) {
                            double sht = 0.5 * shifts[index];
                            lyc = yc + sht * Math.cos(ma);
                            lzc = zc - sht * Math.sin(ma);
                        }
                        view.projection(xj, lyc + 0.4 * Math.cos(ma), lzc - 0.4 * Math.sin(ma), pj);
                        int xs = (int)pj.getX();
                        int ys = (int)pj.getY();
                        switch (r_labels[index].align) {
                            default: {
                                xt = r_labels[index].centerX();
                                yt = r_labels[index].bottom() + d.margin_ / 2;
                                break;
                            }
                            case 16: {
                                xt = r_labels[index].centerX();
                                yt = r_labels[index].top() - d.margin_ / 2;
                                break;
                            }
                            case 1: {
                                xt = r_labels[index].right() + d.margin_ / 2;
                                yt = r_labels[index].centerY();
                            }
                        }
                        d.gc_.drawLine(xs, ys, xt, yt);
                    }
                    ++i5;
                }
            }
            if (loc != null) {
                throw loc;
            }
        }
    }

    private static void renderTorus(int nvalues, double sum, double[] values, IDItem[] items, String[] labels, LRect[] r_labels, double[] shifts, boolean have_shift, DefaultChartRenderData d, H3D p, boolean x_incr, View3D view, Vector3D view_vector) throws DefaultRenderChartLocation {
        double xc = 0.5 * p.bbox.getXMax();
        double yc = 0.5 * p.bbox.getYMax();
        double zc = 0.5 * p.bbox.getZMax();
        p.bbox.getXMin();
        p.bbox.getXMax();
        if (nvalues == 0) {
            return;
        }
        Vector3D v = new Vector3D();
        if (nvalues == 1) {
            Point3D[] pt = new Point3D[1536];
            Point3D[] pj = new Point3D[1536];
            double a = 0.0;
            int k = 0;
            int i = 0;
            while (i < 64) {
                double a2 = 0.0;
                int j = 0;
                while (j < 24) {
                    double x = xc + (double)0.15f * Math.sin(a2);
                    double R = (double)0.35f + (double)0.15f * Math.cos(a2);
                    double y = yc + R * Math.cos(a);
                    double z = zc - R * Math.sin(a);
                    pt[k] = new Point3D(x, y, z);
                    pj[k] = new Point3D();
                    view.projection(pt[k], pj[k]);
                    ++k;
                    ++j;
                    a2 += 0.2617993877991494;
                }
                ++i;
                a += 0.09817477042468103;
            }
            Object[] faces = new Face[1536];
            int last_i = 63;
            k = 0;
            int i2 = 0;
            while (i2 < 64) {
                int last_j = 23;
                int j = 0;
                while (j < 24) {
                    faces[k++] = new Face(0, items[0], last_i * 24 + last_j, i2 * 24 + last_j, i2 * 24 + j, last_i * 24 + j, pt, pj);
                    last_j = j++;
                }
                last_i = i2++;
            }
            Arrays.sort(faces, 0, faces.length);
            Polygon p4 = new Polygon(4);
            int i3 = faces.length - 1;
            while (i3 >= 0) {
                Object f = faces[i3];
                DefaultChartRenderPie3D.renderQuad((Face)f, d, p, p4, v, view_vector);
                --i3;
            }
        } else {
            ArrayList<AFace> faces = new ArrayList<AFace>();
            double last_angle = 0.0;
            int iv = 0;
            while (iv < nvalues) {
                int npt;
                double delta_angle = Math.PI * 2 * (values[iv] / sum);
                double end_angle = last_angle + delta_angle;
                double lyc = yc;
                double lzc = zc;
                if (have_shift && shifts[iv] > 0.0) {
                    double sht = (double)0.35f * shifts[iv];
                    double am = (last_angle + end_angle) / 2.0;
                    lyc = yc + sht * Math.cos(am);
                    lzc = zc - sht * Math.sin(am);
                }
                if ((npt = (int)Math.round(delta_angle / 0.09817477042468103)) <= 1) {
                    Point3D[] pt = new Point3D[48];
                    Point3D[] pj = new Point3D[48];
                    double a2 = 0.0;
                    int j2 = 24;
                    int j = 0;
                    while (j < 24) {
                        double x = xc + (double)0.15f * Math.sin(a2);
                        double R = (double)0.35f + (double)0.15f * Math.cos(a2);
                        double y1 = lyc + R * Math.cos(last_angle);
                        double z1 = lzc - R * Math.sin(last_angle);
                        double y2 = lyc + R * Math.cos(end_angle);
                        double z2 = lzc - R * Math.sin(end_angle);
                        pt[j] = new Point3D(x, y1, z1);
                        pt[j2] = new Point3D(x, y2, z2);
                        pj[j] = new Point3D();
                        view.projection(pt[j], pj[j]);
                        pj[j2] = new Point3D();
                        view.projection(pt[j2], pj[j2]);
                        ++j;
                        ++j2;
                        a2 += 0.2617993877991494;
                    }
                    j2 = 24;
                    int lj = 23;
                    int lj2 = 47;
                    int j3 = 0;
                    while (j3 < 24) {
                        faces.add(new Face(iv, items[iv], lj, lj2, j2, j3, pt, pj));
                        lj = j3++;
                        lj2 = j2++;
                        a2 += 0.2617993877991494;
                    }
                    if (have_shift) {
                        int[] ip1 = new int[24];
                        int[] ip2 = new int[24];
                        int i = 0;
                        while (i < 24) {
                            ip1[i] = i;
                            ip2[i] = 24 + i;
                            ++i;
                        }
                        faces.add(new FaceN(iv, items[iv], ip1, pt, pj));
                        faces.add(new FaceN(iv, items[iv], ip2, pt, pj));
                    }
                } else {
                    double lai = delta_angle / (double)(npt - 1);
                    Point3D[] pt = new Point3D[npt * 24];
                    Point3D[] pj = new Point3D[npt * 24];
                    double a1 = last_angle;
                    int k = 0;
                    int i = 0;
                    while (i < npt) {
                        if (i == npt - 1) {
                            a1 = end_angle;
                        }
                        double a2 = 0.0;
                        int j = 0;
                        while (j < 24) {
                            double x = xc + (double)0.15f * Math.sin(a2);
                            double R = (double)0.35f + (double)0.15f * Math.cos(a2);
                            double y = lyc + R * Math.cos(a1);
                            double z = lzc - R * Math.sin(a1);
                            pt[k] = new Point3D(x, y, z);
                            pj[k] = new Point3D();
                            view.projection(pt[k], pj[k]);
                            ++k;
                            ++j;
                            a2 += 0.2617993877991494;
                        }
                        ++i;
                        a1 += lai;
                    }
                    int last_i = 0;
                    int i4 = 1;
                    while (i4 < npt) {
                        int last_j = 23;
                        int j = 0;
                        while (j < 24) {
                            faces.add(new Face(iv, items[iv], last_i * 24 + last_j, i4 * 24 + last_j, i4 * 24 + j, last_i * 24 + j, pt, pj));
                            last_j = j++;
                        }
                        last_i = i4++;
                    }
                    if (have_shift) {
                        int[] ip1 = new int[24];
                        int[] ip2 = new int[24];
                        int i5 = 0;
                        while (i5 < 24) {
                            ip1[i5] = i5;
                            ip2[i5] = (npt - 1) * 24 + i5;
                            ++i5;
                        }
                        faces.add(new FaceN(iv, items[iv], ip1, pt, pj));
                        faces.add(new FaceN(iv, items[iv], ip2, pt, pj));
                    }
                }
                last_angle = end_angle;
                ++iv;
            }
            Object[] of = faces.toArray();
            Arrays.sort(of, 0, of.length);
            Polygon pN = have_shift ? new Polygon(24) : null;
            Polygon p4 = new Polygon(4);
            boolean decr = d.drawing();
            int i0 = decr ? of.length - 1 : 0;
            int iX = decr ? 0 : of.length - 1;
            int ii = decr ? -1 : 1;
            DefaultRenderChartLocation loc = null;
            try {
                int i = i0;
                while (ii == 1 && i <= iX || ii == -1 && i >= iX) {
                    AFace face = (AFace)of[i];
                    DefaultChartRenderPie3D.renderFace(face, null, p4, pN, v, view_vector, d, p, true);
                    i += ii;
                }
            }
            catch (DefaultRenderChartLocation l) {
                loc = l;
            }
            if (labels != null && d.drawing()) {
                d.gc_.setPen(new LineStylePen(255));
                Point3D pj = new Point3D();
                double xj = x_incr ? xc + (double)0.15f : xc - (double)0.15f;
                last_angle = 0.0;
                int iv2 = 0;
                while (iv2 < nvalues) {
                    double delta_angle = Math.PI * 2 * (values[iv2] / sum);
                    double end_angle = last_angle + delta_angle;
                    double am = (last_angle + end_angle) / 2.0;
                    last_angle = end_angle;
                    double lyc = yc;
                    double lzc = zc;
                    if (have_shift && shifts[iv2] > 0.0) {
                        double sht = (double)0.35f * shifts[iv2];
                        lyc = yc + sht * Math.cos(am);
                        lzc = zc - sht * Math.sin(am);
                    }
                    if (labels[iv2] != null) {
                        int yt;
                        int xt;
                        view.projection(xj, lyc + (double)0.35f * Math.cos(am), lzc - (double)0.35f * Math.sin(am), pj);
                        int xs = (int)pj.getX();
                        int ys = (int)pj.getY();
                        switch (r_labels[iv2].align) {
                            default: {
                                xt = r_labels[iv2].centerX();
                                yt = r_labels[iv2].bottom() + d.margin_ / 2;
                                break;
                            }
                            case 16: {
                                xt = r_labels[iv2].centerX();
                                yt = r_labels[iv2].top() - d.margin_ / 2;
                                break;
                            }
                            case 1: {
                                xt = r_labels[iv2].right() + d.margin_ / 2;
                                yt = r_labels[iv2].centerY();
                            }
                        }
                        d.gc_.drawLine(xs, ys, xt, yt);
                    }
                    ++iv2;
                }
            }
            if (loc != null) {
                throw loc;
            }
        }
    }

    private static void renderFace(AFace face, Polygon p3, Polygon p4, Polygon pN, Vector3D v, Vector3D view_vector, DefaultChartRenderData d, H3D h3d, boolean tore) throws DefaultRenderChartLocation {
        if (face instanceof FaceN) {
            FaceN f = (FaceN)face;
            pN.resize(f.ip.length);
            int ip = 0;
            while (ip < f.ip.length) {
                int ji = f.ip[ip];
                pN.setPoint(ip, (int)f.pj[ji].getX(), (int)f.pj[ji].getY());
                ++ip;
            }
            if (tore) {
                int i0 = 0;
                int i1 = (int)Math.round((double)f.ip.length / 3.0);
                int i2 = (int)Math.round((double)(2 * f.ip.length) / 3.0);
                v.vectorialProduct(f.pt[i1].getX() - f.pt[i0].getX(), f.pt[i1].getY() - f.pt[i0].getY(), f.pt[i1].getZ() - f.pt[i0].getZ(), f.pt[i2].getX() - f.pt[i1].getX(), f.pt[i2].getY() - f.pt[i1].getY(), f.pt[i2].getZ() - f.pt[i1].getZ());
                v.normalize();
            } else {
                v.setVector(1.0, 0.0, 0.0);
            }
            DefaultChartRenderPie3D.renderPolygon(f.item, d, h3d, IGCDStyle.GetBackColor(f.item), pN, v, view_vector);
        } else {
            Face f = (Face)face;
            if (f.ip3 < 0) {
                DefaultChartRenderPie3D.renderTriangle(f, d, h3d, p3, v, view_vector);
            } else {
                DefaultChartRenderPie3D.renderQuad(f, d, h3d, p4, v, view_vector);
            }
        }
    }

    private static abstract class AFace
    implements Comparable {
        public double pj_zavg;
        public int item_index;
        public IDItem item;
        public double medium_angle;

        private AFace() {
        }

        public int compareTo(Object o) {
            AFace f = (AFace)o;
            if (this.pj_zavg == f.pj_zavg) {
                return 0;
            }
            if (this.pj_zavg > f.pj_zavg) {
                return 1;
            }
            return -1;
        }
    }

    private static class Face
    extends AFace {
        public int ip0;
        public int ip1;
        public int ip2;
        public int ip3;
        public Point3D[] pj;
        public Point3D[] pt;

        public Face() {
        }

        public Face(int index, IDItem item, int p0, int p1, int p2, int p3, Point3D[] pt, Point3D[] pj) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = p3;
            this.pj = pj;
            this.pt = pt;
            this.item = item;
            this.item_index = index;
            this.pj_zavg = (pj[p0].getZ() + pj[p1].getZ() + pj[p2].getZ() + pj[p3].getZ()) / 4.0;
        }

        public Face(int index, IDItem item, int p0, int p1, int p2, Point3D[] pt, Point3D[] pj) {
            this.ip0 = p0;
            this.ip1 = p1;
            this.ip2 = p2;
            this.ip3 = -1;
            this.pj = pj;
            this.pt = pt;
            this.item = item;
            this.item_index = index;
            this.pj_zavg = (pj[p0].getZ() + pj[p1].getZ() + pj[p2].getZ()) / 3.0;
        }
    }

    private static class FaceN
    extends AFace {
        public int[] ip;
        public Point3D[] pj;
        public Point3D[] pt;

        public FaceN(int index, IDItem item, int[] ip, Point3D[] pt, Point3D[] pj) {
            this.item = item;
            this.ip = ip;
            this.pj = pj;
            this.pt = pt;
            this.item_index = index;
            int i = 0;
            while (i < ip.length) {
                double z = pj[ip[i]].getZ();
                this.pj_zavg += z;
                ++i;
            }
            this.pj_zavg /= (double)ip.length;
        }

        public int getCenterXj() {
            double x = 0.0;
            int i = 0;
            while (i < this.ip.length) {
                x += this.pj[this.ip[i]].getX();
                ++i;
            }
            return (int)Math.round(x / (double)this.ip.length);
        }

        public int getCenterYj() {
            double y = 0.0;
            int i = 0;
            while (i < this.ip.length) {
                y += this.pj[this.ip[i]].getY();
                ++i;
            }
            return (int)Math.round(y / (double)this.ip.length);
        }
    }

    static class H3D
    implements IDisposable {
        DAxis axis;
        Box3D bbox;
        float shadow;
        float light;

        H3D() {
        }

        public void dispose() {
        }
    }

    private static class LRect
    extends Rect {
        public int align;

        public LRect(int x, int y, int w, int h) {
            super(x, y, w, h);
        }
    }

    private static class XSort
    implements Comparable {
        public int xpj;
        public int index;

        public XSort(int index, int xpj) {
            this.xpj = xpj;
            this.index = index;
        }

        public int compareTo(Object o) {
            int oxpj = ((XSort)o).xpj;
            if (oxpj == this.xpj) {
                return 0;
            }
            if (this.xpj > oxpj) {
                return 1;
            }
            return -1;
        }
    }
}

