/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.internal.DefaultRenderChartLocation;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.chart.internal.MinMax;
import org.eclipse.tptp.platform.report.chart.internal.RenderPersistData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.igc.util.internal.LineStylePen;
import org.eclipse.tptp.platform.report.igc.util.internal.Polygon;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.SolidBrush;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;

public class DefaultChartRenderXY {
    private static final int aln_x_title = 4;
    private static final int aln_y_title = 128;
    private static final int aln_y2_title = 256;

    /*
     * Exception decompiling
     */
    public static void render(DefaultChartRenderData d, RenderPersistData rpd) throws DefaultRenderChartLocation {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int computeBarWidth(CurveStyle ccurve, XY p, DefaultChartRenderData d, RenderPersistData rpd) {
        int num_points = 0;
        int last_x = 0;
        boolean have_last_x = false;
        int bar_width = rpd.graphic_rect.getW();
        Object x_obj = null;
        IDItem item = ccurve.curve_.getFirstChild();
        while (item != null) {
            if (item instanceof DPoint) {
                ++num_points;
                DPoint point = (DPoint)item;
                IDItem itc = point.getFirstChild();
                while (itc != null) {
                    IDCoord coord;
                    if (itc instanceof IDCoord && (coord = (IDCoord)((Object)itc)).getAxis() == p.x_axis) {
                        int w;
                        if ((x_obj = coord.getValue(x_obj)) == null) break;
                        int x = (int)p.x_scale.toScale(x_obj);
                        if (have_last_x && (w = Math.abs(last_x - x)) > 0 && bar_width > w) {
                            bar_width = w;
                        }
                        last_x = x;
                        have_last_x = true;
                        break;
                    }
                    itc = itc.getNext();
                }
            }
            item = item.getNext();
        }
        if (num_points == 0) {
            return -1;
        }
        bar_width -= d.dpiX(2);
        bar_width = Math.max(bar_width, d.dpiX(3));
        return bar_width;
    }

    private static void renderCandleStickCurve(CurveStyle ccurve, XY p, DefaultChartRenderData d, RenderPersistData rpd, boolean render_lines) throws DefaultRenderChartLocation {
        int candle_width = p.ibar_width;
        int candle_width_2 = candle_width / 2;
        int fore = 0;
        int back = 0;
        int raising = 0;
        int falling = 0;
        if (d.drawing()) {
            fore = ccurve.style_.getFore();
            back = ccurve.style_.getBack();
            if (render_lines) {
                d.gc_.setPen(new LineStylePen(back));
                raising = falling = back;
            } else {
                d.gc_.setPen(new LineStylePen(fore));
                d.gc_.setBrush(new SolidBrush(back));
                raising = back;
                falling = fore;
            }
            Object prop = ccurve.curve_.getProperties().get("CS_FALL_COLOR.DCurve.core.jscrib");
            if (prop instanceof IDColor) {
                falling = IGCDStyle.GetRGBA((IDColor)prop);
            }
        }
        Object y_obj = null;
        Object x_obj = null;
        Rect rect = new Rect();
        int[] xy = new int[8];
        SolidBrush brush = new SolidBrush(-1);
        LineStylePen lsp = new LineStylePen(255);
        Polygon poly = new Polygon(null);
        IDItem item = ccurve.curve_.getFirstChild();
        while (item != null) {
            if (item instanceof DPoint) {
                DPoint point = (DPoint)item;
                IDCoord cx = null;
                int x = 0;
                int y_open = 0;
                int y_high = 0;
                int y_low = 0;
                int y_close = 0;
                int y_curr = 0;
                IDItem itc = point.getFirstChild();
                while (itc != null) {
                    if (itc instanceof IDCoord) {
                        IDCoord coord = (IDCoord)((Object)itc);
                        if (cx == null && coord.getAxis() == p.x_axis) {
                            if ((x_obj = coord.getValue(x_obj)) != null) {
                                cx = coord;
                                x = (int)p.x_scale.toScale(x_obj);
                            }
                        } else {
                            boolean good_y_axis = false;
                            boolean y2_axis = false;
                            if (coord.getAxis() == p.y_axis) {
                                good_y_axis = true;
                            } else if (coord.getAxis() == p.y2_axis) {
                                good_y_axis = true;
                                y2_axis = true;
                            }
                            if (good_y_axis) {
                                y_obj = coord.getValue(y_obj);
                                int py = y2_axis ? (int)p.y2_scale.toScale(y_obj) : (int)p.y_scale.toScale(y_obj);
                                switch (y_curr) {
                                    case 0: {
                                        y_open = py;
                                        y_curr = 1;
                                        break;
                                    }
                                    case 1: {
                                        y_high = py;
                                        y_curr = 2;
                                        break;
                                    }
                                    case 2: {
                                        y_low = py;
                                        y_curr = 3;
                                        break;
                                    }
                                    case 3: {
                                        y_close = py;
                                        y_curr = 4;
                                    }
                                }
                            }
                        }
                    }
                    itc = itc.getNext();
                }
                if (cx != null && y_curr == 4) {
                    boolean v_falling;
                    boolean bl = v_falling = y_close > y_open;
                    if (render_lines) {
                        if (d.drawing()) {
                            lsp.setRGBA(v_falling ? falling : raising);
                            d.gc_.setPen(lsp);
                            d.gc_.drawLine(x, y_high, x, y_low);
                            d.gc_.drawLine(x - candle_width_2, y_open, x, y_open);
                            d.gc_.drawLine(x, y_close, x + candle_width_2, y_close);
                        } else {
                            rect.setRect(x - candle_width_2, y_low, candle_width, y_high - y_low);
                            if (rect.contains(d.lx_, d.ly_)) {
                                throw new DefaultRenderChartLocation("CurvePoint", point, rect);
                            }
                        }
                    } else {
                        int ymh = 0;
                        int yml = 0;
                        if (v_falling) {
                            ymh = y_open;
                            yml = y_close;
                        } else {
                            ymh = y_close;
                            yml = y_open;
                        }
                        if (d.drawing()) {
                            xy[0] = xy[2] = x - candle_width_2;
                            xy[7] = xy[1] = yml;
                            xy[4] = xy[6] = x + candle_width_2;
                            xy[3] = xy[5] = ymh;
                            if (v_falling) {
                                brush.setRGBA(falling);
                                lsp.setRGBA(fore);
                            } else {
                                brush.setRGBA(raising);
                                lsp.setRGBA(fore);
                            }
                            poly.setPoints(xy);
                            d.gc_.setBrush(brush);
                            d.gc_.setPen(lsp);
                            d.gc_.fillPoly(poly);
                            d.gc_.drawPoly(poly);
                            if (y_high < ymh) {
                                d.gc_.drawLine(x, ymh, x, y_high);
                            }
                            if (y_low > yml) {
                                d.gc_.drawLine(x, yml, x, y_low);
                            }
                        } else {
                            rect.setRect(x - candle_width_2, y_low, candle_width, y_high - y_low);
                            if (rect.contains(d.lx_, d.ly_)) {
                                throw new DefaultRenderChartLocation("CurvePoint", point, rect);
                            }
                        }
                    }
                }
            }
            item = item.getNext();
        }
    }

    private static void renderVBar(CurveStyle ccurve, XY p, DefaultChartRenderData d, RenderPersistData rpd, int y_bar_zero, int y2_bar_zero) throws DefaultRenderChartLocation {
        int bar_width = p.ibar_width;
        int bar_width_2 = bar_width / 2;
        int back = 0;
        SolidBrush brush = new SolidBrush(-1);
        if (d.drawing()) {
            back = ccurve.style_.getBack();
            d.gc_.setPen(new LineStylePen(255));
            brush.setRGBA(back);
            d.gc_.setBrush(brush);
        }
        Object y_obj = null;
        Object x_obj = null;
        Rect rect = new Rect();
        IDItem item = ccurve.curve_.getFirstChild();
        while (item != null) {
            if (item instanceof DPoint) {
                DPoint point = (DPoint)item;
                IDCoord cx = null;
                IDCoord cy = null;
                boolean y2_axis = false;
                int x = 0;
                int y = 0;
                IDItem itc = point.getFirstChild();
                while (itc != null) {
                    if (itc instanceof IDCoord) {
                        IDCoord coord = (IDCoord)((Object)itc);
                        if (cx == null && coord.getAxis() == p.x_axis) {
                            if ((x_obj = coord.getValue(x_obj)) != null) {
                                cx = coord;
                                x = (int)p.x_scale.toScale(x_obj);
                            }
                        } else {
                            boolean good_y_axis = false;
                            if (coord.getAxis() == p.y_axis) {
                                good_y_axis = true;
                            } else if (coord.getAxis() == p.y2_axis) {
                                good_y_axis = true;
                                y2_axis = true;
                            }
                            if (good_y_axis) {
                                y_obj = coord.getValue(y_obj);
                                int py = y2_axis ? (int)p.y2_scale.toScale(y_obj) : (int)p.y_scale.toScale(y_obj);
                                cy = coord;
                                y = py;
                            }
                        }
                    }
                    itc = itc.getNext();
                }
                if (cx != null && cy != null) {
                    int ybz = y2_axis ? y2_bar_zero : y_bar_zero;
                    rect.setRect(x - bar_width_2, ybz, bar_width, y - ybz);
                    rect.normalize();
                    if (d.drawing()) {
                        brush.setRGBA(ccurve.style_.getBack());
                        d.gc_.setBrush(brush);
                        d.gc_.fillRect(rect.x(), rect.y(), rect.w(), rect.h());
                        d.gc_.drawRect(rect.x(), rect.y(), rect.w(), rect.h());
                    } else if (rect.contains(d.lx_, d.ly_)) {
                        throw new DefaultRenderChartLocation("CurveBar", point, rect);
                    }
                }
            }
            item = item.getNext();
        }
    }

    private static void renderAreas(XY p, DefaultChartRenderData d, RenderPersistData rpd, int y_bar_zero, int y2_bar_zero) {
        if (d.locating()) {
            return;
        }
        boolean reverse = d.locating();
        int ic_inc = reverse ? -1 : 1;
        int ic_size = rpd.curve_styles.length;
        int[] pts1 = new int[100];
        SolidBrush brush = new SolidBrush(-1);
        Polygon polygon = new Polygon();
        int ic = reverse ? ic_size - 1 : 0;
        while (!(reverse ? ic < 0 : ic >= ic_size)) {
            CurveStyle cs = rpd.curve_styles[ic];
            if (cs.curve_.isType("AREA_LINE.DCurve.core.jscrib") || cs.curve_.isType("AREA_LINE_POINTS.DCurve.core.jscrib")) {
                int pts1_top = 0;
                boolean known_y_axis = false;
                boolean primary_y_axis = true;
                IDItem ip = cs.curve_.getFirstChild();
                while (ip != null) {
                    if (ip instanceof DPoint) {
                        IDCoord xc = null;
                        IDCoord yc = null;
                        int px = 0;
                        int py = 0;
                        IDItem id = ip.getFirstChild();
                        while (id != null) {
                            if (id instanceof IDCoord) {
                                IDCoord cd = (IDCoord)((Object)id);
                                DAxis a = cd.getAxis();
                                if (a == p.x_axis) {
                                    xc = cd;
                                    px = (int)p.x_scale.toScale(cd.getValue(null));
                                } else if (a == p.y_axis && (!known_y_axis || primary_y_axis)) {
                                    yc = cd;
                                    known_y_axis = true;
                                    primary_y_axis = true;
                                    py = (int)p.y_scale.toScale(cd.getValue(null));
                                } else if (!(a != p.y2_axis || known_y_axis && primary_y_axis)) {
                                    yc = cd;
                                    known_y_axis = true;
                                    primary_y_axis = false;
                                    py = (int)p.y2_scale.toScale(cd.getValue(null));
                                }
                            }
                            id = id.getNext();
                        }
                        if (xc != null && yc != null) {
                            if (pts1_top + 2 >= pts1.length) {
                                int[] t = new int[pts1.length * 2];
                                System.arraycopy(pts1, 0, t, 0, pts1_top);
                                pts1 = t;
                            }
                            pts1[pts1_top++] = px;
                            pts1[pts1_top++] = py;
                        }
                    }
                    ip = ip.getNext();
                }
                if (pts1_top >= 4) {
                    int[] poly = new int[pts1_top + 4];
                    poly[0] = pts1[0];
                    poly[1] = primary_y_axis ? y_bar_zero : y2_bar_zero;
                    System.arraycopy(pts1, 0, poly, 2, pts1_top);
                    poly[pts1_top + 2] = pts1[pts1_top - 2];
                    int n = poly[pts1_top + 3] = primary_y_axis ? y_bar_zero : y2_bar_zero;
                    if (d.drawing()) {
                        brush.setRGBA(cs.style_.getBack());
                        d.gc_.setBrush(brush);
                        polygon.setPoints(poly);
                        d.gc_.fillPoly(polygon);
                    }
                }
            }
            ic += ic_inc;
        }
    }

    private static void renderStackedAreas(DefaultChartRenderData d, RenderPersistData rpd, StackedArea top_area, int y_bar_zero, IScale y_scale, IScale x_scale) {
        if (d.locating()) {
            return;
        }
        int[] line_above = null;
        StackedArea sa_above = null;
        boolean area_above = false;
        SolidBrush brush = new SolidBrush(-1);
        Polygon polygon = new Polygon();
        StackedArea sa = top_area;
        while (sa != null) {
            DCurve curve = rpd.curve_styles[sa.index].curve_;
            int size = sa.points.size();
            int[] curr_line = new int[size * 2];
            int ip = 0;
            for (SAPoint sp : sa.points) {
                double x = x_scale.toScale(sp.x_coord.getValue(null));
                double y = y_scale.toScale(sp.y_value);
                curr_line[ip++] = (int)x;
                curr_line[ip++] = (int)y;
            }
            if (area_above && sa_above != null) {
                int[] poly = new int[curr_line.length + line_above.length];
                System.arraycopy(line_above, 0, poly, 0, line_above.length);
                int j = curr_line.length;
                int i = curr_line.length - 2;
                while (i >= 0 && j < poly.length) {
                    poly[j++] = curr_line[i];
                    poly[j++] = curr_line[i + 1];
                    i -= 2;
                }
                brush.setRGBA(rpd.curve_styles[sa_above.index].style_.getBack());
                d.gc_.setBrush(brush);
                polygon.setPoints(poly);
                d.gc_.fillPoly(polygon);
            }
            line_above = curr_line;
            sa_above = sa;
            area_above = curve.isType("STACKED_AREA_LINE.DCurve.core.jscrib") || curve.isType("STACKED_AREA_LINE_POINTS.DCurve.core.jscrib");
            sa = sa.below;
        }
        if (area_above && line_above != null) {
            int[] poly = new int[line_above.length + 4];
            System.arraycopy(line_above, 0, poly, 0, line_above.length);
            int j = line_above.length;
            poly[j++] = line_above[line_above.length - 2];
            poly[j++] = y_bar_zero;
            poly[j++] = line_above[0];
            poly[j++] = y_bar_zero;
            brush.setRGBA(rpd.curve_styles[sa_above.index].style_.getBack());
            d.gc_.setBrush(brush);
            polygon.setPoints(poly);
            d.gc_.fillPoly(polygon);
        }
    }

    private static void renderStackedLineAndSymbol(DefaultChartRenderData d, RenderPersistData rpd, StackedArea top_area, IScale y_scale, IScale x_scale, int symbol_size, int symbol_size2) throws DefaultRenderChartLocation {
        ISymbol symbol = null;
        Rect rp = new Rect();
        SolidBrush brush = new SolidBrush();
        LineStylePen pen = new LineStylePen();
        StackedArea sa = top_area;
        while (sa != null) {
            int lx = 0;
            int ly = 0;
            DPoint last_point = null;
            symbol = rpd.curve_styles[sa.index].curve_.isType("STACKED_LINE_POINTS.DCurve.core.jscrib") || rpd.curve_styles[sa.index].curve_.isType("STACKED_AREA_LINE_POINTS.DCurve.core.jscrib") ? rpd.curve_styles[sa.index].symbol_ : null;
            IGCDStyle style = rpd.curve_styles[sa.index].style_;
            brush.setRGBA(style.getBack());
            d.gc_.setBrush(brush);
            int i = 0;
            while (i < sa.points.size()) {
                SAPoint sp = (SAPoint)sa.points.get(i);
                int px = (int)x_scale.toScale(sp.x_coord.getValue(null));
                int py = (int)y_scale.toScale(sp.y_value);
                if (i != 0) {
                    if (symbol != null) {
                        rp.setRect(lx - symbol_size, ly - symbol_size, symbol_size2, symbol_size2);
                    }
                    if (d.drawing()) {
                        pen.setRGBA(sa.area ? style.getFore() : style.getBack());
                        d.gc_.setPen(pen);
                        d.gc_.drawLine(lx, ly, px, py);
                        if (symbol != null) {
                            pen.setRGBA(style.getFore());
                            d.gc_.setPen(pen);
                            symbol.draw(d.gc_, rp);
                        }
                    } else {
                        if (symbol != null && symbol.contains(d.gc_, rp, d.lx_, d.ly_)) {
                            throw new DefaultRenderChartLocation("CurvePoint", last_point, rp);
                        }
                        if (DrawUtilIGC.segmentContains(lx, ly, px, py, d.lx_, d.ly_)) {
                            DefaultRenderChartLocation loc = new DefaultRenderChartLocation("CurveLine", sp.point, new Rect(lx, ly, px - lx, py - ly));
                            loc.setPreviousPoint(((SAPoint)sa.points.get((int)(i - 1))).point);
                            throw loc;
                        }
                    }
                }
                lx = px;
                ly = py;
                last_point = sp.point;
                ++i;
            }
            if (symbol != null) {
                rp.setRect(lx - symbol_size, ly - symbol_size, symbol_size2, symbol_size2);
                if (d.drawing()) {
                    symbol.draw(d.gc_, rp);
                } else if (symbol.contains(d.gc_, rp, d.lx_, d.ly_)) {
                    throw new DefaultRenderChartLocation("CurvePoint", last_point, rp);
                }
            }
            sa = sa.below;
        }
    }

    private static XY rebuildRPD(DefaultChartRenderData d, RenderPersistData rpd) {
        XY p;
        block92: {
            String type;
            CurveStyle ccurve;
            boolean have_y2;
            block93: {
                p = new XY();
                rpd.g = p;
                int have_axis = 0;
                IDItem item = rpd.graphic.getFirstChild();
                while (item != null) {
                    if (item instanceof DAxis) {
                        DAxis axis = (DAxis)item;
                        if (p.x_axis == null && "x".equals(axis.getName())) {
                            p.x_axis = axis;
                            have_axis |= 1;
                        } else if (p.y_axis == null && "y".equals(axis.getName())) {
                            p.y_axis = axis;
                            have_axis |= 2;
                        } else if (p.y2_axis == null && "y2".equals(axis.getName())) {
                            p.y2_axis = axis;
                            have_axis |= 4;
                        }
                        if (have_axis == 7) break;
                    }
                    item = item.getNext();
                }
                if (p.x_axis == null || p.y_axis == null) break block92;
                have_y2 = p.y2_axis != null;
                p.x_axis_style = new IGCDStyle(p.x_axis, d.scale_);
                p.y_axis_style = new IGCDStyle(p.y_axis, d.scale_);
                if (have_y2) {
                    p.y2_axis_style = new IGCDStyle(p.y2_axis, d.scale_);
                }
                if (!p.x_axis.useNumbers()) break block93;
                int icrv = 0;
                while (icrv < rpd.curve_styles.length) {
                    block95: {
                        boolean area;
                        block94: {
                            ccurve = rpd.curve_styles[icrv];
                            type = ccurve.curve_.getType();
                            area = true;
                            if ("STACKED_AREA_LINE.DCurve.core.jscrib".equals(type) || "STACKED_AREA_LINE_POINTS.DCurve.core.jscrib".equals(type)) break block94;
                            if (!"STACKED_LINE.DCurve.core.jscrib".equals(type) && !"STACKED_LINE_POINTS.DCurve.core.jscrib".equals(type)) break block95;
                            area = false;
                        }
                        boolean known_sa_axis = false;
                        boolean sa_axis_is_y1 = true;
                        ArrayList<SAPoint> pts = new ArrayList<SAPoint>(10);
                        boolean all_use_numbers = true;
                        IDItem item2 = ccurve.curve_.getFirstChild();
                        while (item2 != null) {
                            if (item2 instanceof DPoint) {
                                DPoint point = (DPoint)item2;
                                IDCoord xc = null;
                                IDCoord yc = null;
                                IDItem ic = point.getFirstChild();
                                while (ic != null) {
                                    if (ic instanceof IDCoord) {
                                        IDCoord c = (IDCoord)((Object)ic);
                                        DAxis a = c.getAxis();
                                        if (a == p.x_axis) {
                                            xc = c;
                                        } else if (a == p.y_axis && (!known_sa_axis || sa_axis_is_y1)) {
                                            yc = c;
                                        } else if (!(a != p.y2_axis || known_sa_axis && sa_axis_is_y1)) {
                                            yc = c;
                                        }
                                    }
                                    ic = ic.getNext();
                                }
                                if (xc != null && yc != null) {
                                    all_use_numbers = yc.getAxis().useNumbers();
                                    if (!all_use_numbers) break;
                                    if (!known_sa_axis) {
                                        known_sa_axis = true;
                                        sa_axis_is_y1 = yc.getAxis() == p.y_axis;
                                    }
                                    SAPoint pt = new SAPoint();
                                    pt.point = point;
                                    pt.x_coord = xc;
                                    pt.y_coord = yc;
                                    pt.y_value = yc.getValue(null);
                                    pts.add(pt);
                                }
                            }
                            item2 = item2.getNext();
                        }
                        if (all_use_numbers && pts.size() > 2) {
                            StackedArea top_area;
                            StackedArea sa = new StackedArea();
                            sa.index = icrv;
                            sa.below = top_area = sa_axis_is_y1 ? p.y1_top_area : p.y2_top_area;
                            sa.points = pts;
                            sa.area = area;
                            if (top_area != null) {
                                StackedArea sab = top_area;
                                int i = 0;
                                while (i < sa.points.size()) {
                                    SAPoint sp = (SAPoint)sa.points.get(i);
                                    Object vx = sp.x_coord.getValue(null);
                                    double dx = ((Number)vx).doubleValue();
                                    double base_y = 0.0;
                                    boolean found_candidate = false;
                                    StackedArea a = sab;
                                    while (a != null && !found_candidate) {
                                        Object prev_vx = null;
                                        SAPoint prev_pt = null;
                                        double pdx = 0.0;
                                        double pdy = 0.0;
                                        int j = 0;
                                        while (!found_candidate && j < a.points.size()) {
                                            SAPoint pt = (SAPoint)a.points.get(j);
                                            Object pvx = pt.x_coord.getValue(null);
                                            double cdx = ((Number)pvx).doubleValue();
                                            double cdy = ((Number)pt.y_value).doubleValue();
                                            if (prev_pt != null && vx instanceof Comparable && ((Comparable)vx).compareTo(prev_vx) >= 0 && ((Comparable)vx).compareTo(pvx) <= 0) {
                                                if (cdx == pdx) {
                                                    base_y = Math.max(pdy, cdy);
                                                } else {
                                                    double k = (dx - pdx) / (cdx - pdx);
                                                    base_y = pdy + k * (cdy - pdy);
                                                }
                                                found_candidate = true;
                                            }
                                            prev_pt = pt;
                                            prev_vx = pvx;
                                            pdx = cdx;
                                            pdy = cdy;
                                            ++j;
                                        }
                                        a = a.below;
                                    }
                                    double ny = ((Number)sp.y_coord.getValue(null)).doubleValue();
                                    sp.y_value = new Double(ny += base_y);
                                    if (i == 0) {
                                        sa.ymin = sa.ymax = ny;
                                    } else if (sa.ymin > ny) {
                                        sa.ymin = ny;
                                    } else if (sa.ymax < ny) {
                                        sa.ymax = ny;
                                    }
                                    ++i;
                                }
                            } else {
                                int i = 0;
                                while (i < sa.points.size()) {
                                    SAPoint sp = (SAPoint)sa.points.get(i);
                                    double ny = ((Number)sp.y_coord.getValue(null)).doubleValue();
                                    if (i == 0) {
                                        sa.ymin = sa.ymax = ny;
                                    } else if (ny < sa.ymin) {
                                        sa.ymin = ny;
                                    } else if (ny > sa.ymax) {
                                        ny = sa.ymax;
                                    }
                                    ++i;
                                }
                            }
                            if (sa_axis_is_y1) {
                                p.y1_top_area = sa;
                            } else {
                                p.y2_top_area = sa;
                            }
                        }
                    }
                    ++icrv;
                }
            }
            int icrv = 0;
            while (icrv < rpd.curve_styles.length) {
                ccurve = rpd.curve_styles[icrv];
                type = ccurve.curve_.getType();
                if ("BUBBLE.DCurve.core.jscrib".equals(type) || "CIRCLE.DCurve.core.jscrib".equals(type)) {
                    DefaultChartRenderXY.rebuildRPDForBubble(icrv, ccurve, p, rpd);
                }
                ++icrv;
            }
            boolean have_bubble = p.bubbles_data != null;
            Object x_min = p.x_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
            Object x_max = p.x_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
            Object y_min = p.y_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
            Object y_max = p.y_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
            Object y2_min = null;
            Object y2_max = null;
            if (have_y2) {
                y2_min = p.y2_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
                y2_max = p.y2_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
            }
            if (x_min == null || x_max == null || y_min == null || y_max == null || have_y2 && (y2_min == null || y2_max == null)) {
                SAPoint sp;
                MinMax x_mm = new MinMax(p.x_axis);
                MinMax y_mm = new MinMax(p.y_axis);
                MinMax y2_mm = have_y2 ? new MinMax(p.y2_axis) : null;
                VDouble vd = new VDouble();
                StackedArea a = p.y1_top_area;
                while (a != null) {
                    y_mm.update(vd.setValue(a.ymin));
                    y_mm.update(vd.setValue(a.ymax));
                    int i = 0;
                    while (i < a.points.size()) {
                        sp = (SAPoint)a.points.get(i);
                        x_mm.update(sp.x_coord);
                        ++i;
                    }
                    a = a.below;
                }
                a = p.y2_top_area;
                while (a != null) {
                    y2_mm.update(vd.setValue(a.ymin));
                    y2_mm.update(vd.setValue(a.ymax));
                    int i = 0;
                    while (i < a.points.size()) {
                        sp = (SAPoint)a.points.get(i);
                        x_mm.update(sp.x_coord);
                        ++i;
                    }
                    a = a.below;
                }
                int icrv2 = 0;
                while (icrv2 < rpd.curve_styles.length) {
                    CurveStyle ccurve2 = rpd.curve_styles[icrv2];
                    if (!(ccurve2.curve_.isType("STACKED_LINE.DCurve.core.jscrib") || ccurve2.curve_.isType("STACKED_LINE_POINTS.DCurve.core.jscrib") || ccurve2.curve_.isType("STACKED_AREA_LINE.DCurve.core.jscrib") || ccurve2.curve_.isType("STACKED_AREA_LINE_POINTS.DCurve.core.jscrib"))) {
                        IDItem item = ccurve2.curve_.getFirstChild();
                        while (item != null) {
                            if (item instanceof DPoint) {
                                IDItem ic = item.getFirstChild();
                                while (ic != null) {
                                    if (ic instanceof IDCoord) {
                                        IDCoord coord = (IDCoord)((Object)ic);
                                        DAxis a2 = coord.getAxis();
                                        if (a2 == p.x_axis) {
                                            x_mm.update(coord);
                                        } else if (a2 == p.y_axis) {
                                            y_mm.update(coord);
                                        } else if (have_y2 && a2 == p.y2_axis) {
                                            y2_mm.update(coord);
                                        }
                                    }
                                    ic = ic.getNext();
                                }
                            }
                            item = item.getNext();
                        }
                    }
                    ++icrv2;
                }
                if (x_min == null) {
                    x_min = x_mm.getVMin();
                }
                if (x_max == null) {
                    x_max = x_mm.getVMax();
                }
                if (y_min == null) {
                    y_min = y_mm.getVMin();
                }
                if (y_max == null) {
                    y_max = y_mm.getVMax();
                }
                if (have_y2) {
                    if (y2_min == null) {
                        y2_min = y2_mm.getVMin();
                    }
                    if (y2_max == null) {
                        y2_max = y2_mm.getVMax();
                    }
                }
                if (have_bubble) {
                    p.x_scale = DefaultChartRenderData.getScale(p.x_axis, rpd.ag_rect.left(), rpd.ag_rect.right(), x_min, x_max);
                    p.y_scale = DefaultChartRenderData.getScale(p.y_axis, rpd.ag_rect.bottom(), rpd.ag_rect.top(), y_min, y_max);
                    Insets bubble_insets = new Insets();
                    Insets bubble_insets2 = new Insets();
                    DefaultChartRenderXY.bubblesInsets(p, rpd, x_mm, y_mm, y2_mm, bubble_insets, bubble_insets2);
                    if (bubble_insets.getW() != 0) {
                        x_min = p.x_scale.toValue(rpd.ag_rect.left() - 2 * bubble_insets.getL(), x_min);
                        x_max = p.x_scale.toValue(rpd.ag_rect.right() + 2 * bubble_insets.getR(), x_max);
                    }
                    if (bubble_insets.getH() != 0) {
                        y_min = p.y_scale.toValue(rpd.ag_rect.bottom() + 2 * bubble_insets.getB(), y_min);
                        y_max = p.y_scale.toValue(rpd.ag_rect.top() - 2 * bubble_insets.getT(), y_max);
                    }
                    if (bubble_insets2.getH() != 0) {
                        y2_min = p.y2_scale.toValue(rpd.ag_rect.bottom() + 2 * bubble_insets.getB(), y2_min);
                        y2_max = p.y2_scale.toValue(rpd.ag_rect.top() - 2 * bubble_insets.getT(), y2_max);
                    }
                }
            }
            if (p.x_scale == null) {
                p.x_scale = DefaultChartRenderData.getScale(p.x_axis, rpd.ag_rect.left(), rpd.ag_rect.right(), x_min, x_max);
            } else {
                p.x_scale.setValueRange(x_min, x_max);
            }
            if (p.y_scale == null) {
                p.y_scale = DefaultChartRenderData.getScale(p.y_axis, rpd.ag_rect.bottom(), rpd.ag_rect.top(), y_min, y_max);
            } else {
                p.y_scale.setValueRange(y_min, y_max);
            }
            if (!p.x_scale.isValid()) {
                return p;
            }
            if (!p.y_scale.isValid()) {
                return p;
            }
            d.gc_.setFont(p.x_axis_style.getFont());
            p.xam = d.computeXAxisAmounts(p.x_axis, p.x_scale, rpd.ag_rect, 4, null);
            d.gc_.setFont(p.y_axis_style.getFont());
            p.yam = d.computeYAxisAmounts(true, true, p.y_axis, p.y_scale, rpd.ag_rect, 128, null);
            if (have_y2) {
                if (p.y2_scale == null) {
                    p.y2_scale = DefaultChartRenderData.getScale(p.y2_axis, rpd.ag_rect.bottom(), rpd.ag_rect.top(), y2_min, y2_max);
                } else {
                    p.y2_scale.setValueRange(y2_min, y2_max);
                }
                if (!p.y2_scale.isValid()) {
                    return p;
                }
                d.gc_.setFont(p.y2_axis_style.getFont());
                p.y2am = d.computeYAxisAmounts(true, false, p.y2_axis, p.y2_scale, rpd.ag_rect, 256, null);
            }
            rpd.ag_rect.setLeft(rpd.ag_rect.left() + Math.max(p.xam.getL(), p.yam.getL()));
            rpd.ag_rect.setTop(rpd.ag_rect.top() + Math.max(p.yam.getT(), have_y2 ? p.y2am.getT() : 0));
            rpd.ag_rect.setRight(rpd.ag_rect.right() - Math.max(p.xam.getR(), have_y2 ? p.y2am.getR() : 0));
            rpd.ag_rect.setBottom(rpd.ag_rect.bottom() - Math.max(Math.max(p.xam.getB(), p.yam.getB()), have_y2 ? p.y2am.getB() : 0));
            p.x_scale.setScaleRange(rpd.ag_rect.left(), rpd.ag_rect.right());
            p.y_scale.setScaleRange(rpd.ag_rect.bottom(), rpd.ag_rect.top());
            if (have_y2) {
                p.y2_scale.setScaleRange(rpd.ag_rect.bottom(), rpd.ag_rect.top());
            }
            if (have_bubble) {
                p.Rmax = Math.min(rpd.graphic_rect.getW(), rpd.graphic_rect.getH()) / 4;
                p.Rmin = Math.min(p.Rmax / 2, 4);
                int ib = 0;
                while (ib < p.bubbles_data.length) {
                    BubbleData bdata = p.bubbles_data[ib];
                    if (bdata != null) {
                        if (bdata.r_scale == null) {
                            bdata.r_scale = DefaultChartRenderData.getScale(bdata.r_axis, p.Rmin, p.Rmax, bdata.r_min, bdata.r_max);
                        } else {
                            bdata.r_scale.setScaleRange(p.Rmin, p.Rmax);
                        }
                    }
                    ++ib;
                }
            }
            p.ibar_width = -1;
            int icrv3 = 0;
            while (icrv3 < rpd.curve_styles.length) {
                int lbw;
                CurveStyle ccurve3 = rpd.curve_styles[icrv3];
                if ((ccurve3.curve_.isType("CANDLESTICK.DCurve.core.jscrib") || ccurve3.curve_.isType("CANDLESTICK_LINE.DCurve.core.jscrib") || ccurve3.curve_.isType("VBAR.DCurve.core.jscrib")) && (lbw = DefaultChartRenderXY.computeBarWidth(ccurve3, p, d, rpd)) > 0) {
                    p.ibar_width = p.ibar_width < 0 ? lbw : Math.min(p.ibar_width, lbw);
                }
                ++icrv3;
            }
        }
        return p;
    }

    private static void bubblesInsets(XY p, RenderPersistData rpd, MinMax x_mm, MinMax y_mm, MinMax y2_mm, Insets bubble_insets, Insets bubble_insets2) {
        p.Rmax = Math.min(rpd.graphic_rect.getW(), rpd.graphic_rect.getH()) / 4;
        p.Rmin = Math.min(p.Rmax / 2, 4);
        Object r_value = null;
        Object x_value = null;
        Object y_value = null;
        Rect brect = new Rect();
        int ib = 0;
        while (ib < p.bubbles_data.length) {
            BubbleData bdata = p.bubbles_data[ib];
            bdata.r_scale = DefaultChartRenderData.getScale(bdata.r_axis, p.Rmin, p.Rmax, bdata.r_min, bdata.r_max);
            int jb = 0;
            while (jb < bdata.bubbles.length) {
                Insets y_insets;
                int cy;
                Bubble bubble = bdata.bubbles[jb];
                x_value = bubble.cx.getValue(x_value);
                y_value = bubble.cy.getValue(y_value);
                x_mm.update(x_value);
                int cx = (int)p.x_scale.toScale(x_value);
                if (bdata.use_y2) {
                    y2_mm.update(y_value);
                    cy = (int)p.y2_scale.toScale(y_value);
                    y_insets = bubble_insets2;
                } else {
                    y_mm.update(y_value);
                    cy = (int)p.y_scale.toScale(y_value);
                    y_insets = bubble_insets;
                }
                r_value = bubble.cr.getValue(r_value);
                int radius = (int)bdata.r_scale.toScale(r_value);
                brect.setRect(cx - radius, cy - radius, 2 * radius, 2 * radius);
                int outside = brect.left() - rpd.ag_rect.left();
                if (outside < 0) {
                    bubble_insets.maxL(-outside);
                }
                if ((outside = rpd.ag_rect.right() - brect.right()) < 0) {
                    bubble_insets.maxR(-outside);
                }
                if ((outside = brect.top() - rpd.ag_rect.top()) < 0) {
                    y_insets.maxT(-outside);
                }
                if ((outside = rpd.ag_rect.bottom() - brect.bottom()) < 0) {
                    y_insets.maxB(-outside);
                }
                ++jb;
            }
            ++ib;
        }
    }

    private static void rebuildRPDForBubble(int icrv, CurveStyle ccurve, XY p, RenderPersistData rpd) {
        BubbleData bdata = null;
        MinMax mm = null;
        ArrayList<Bubble> bubbles = new ArrayList<Bubble>();
        int y_axis_is = 0;
        IDItem item = ccurve.curve_.getFirstChild();
        while (item != null) {
            if (item instanceof DPoint) {
                IDCoord cx = null;
                IDCoord cy = null;
                IDCoord cy2 = null;
                IDCoord cr = null;
                IDItem ic = item.getFirstChild();
                while (ic != null) {
                    if (ic instanceof IDCoord) {
                        IDCoord coord = (IDCoord)((Object)ic);
                        DAxis axis = coord.getAxis();
                        if (axis == p.x_axis) {
                            if (cx == null) {
                                cx = coord;
                            }
                        } else if (axis == p.y_axis) {
                            if (cy == null && y_axis_is != 2) {
                                cy = coord;
                            }
                            if (y_axis_is == 0) {
                                y_axis_is = 1;
                            }
                        } else if (axis == p.y2_axis && y_axis_is != 1) {
                            if (cy2 == null && y_axis_is != 1) {
                                cy2 = coord;
                            }
                            if (y_axis_is == 0) {
                                y_axis_is = 2;
                            }
                        } else if (bdata == null) {
                            bdata = new BubbleData();
                            if (p.bubbles_data == null) {
                                p.bubbles_data = new BubbleData[rpd.curve_styles.length];
                            }
                            p.bubbles_data[icrv] = bdata;
                            bdata.r_axis = axis;
                            bdata.r_min = bdata.r_axis.getProperties().get("P_MIN.DAxis.core.jscrib");
                            bdata.r_max = bdata.r_axis.getProperties().get("P_MAX.DAxis.core.jscrib");
                            if (bdata.r_min == null || bdata.r_max == null) {
                                mm = new MinMax(bdata.r_axis);
                                mm.update(bdata.r_min);
                                mm.update(bdata.r_max);
                            }
                            cr = coord;
                        } else if (axis == bdata.r_axis && cr == null) {
                            cr = coord;
                        }
                    }
                    ic = ic.getNext();
                }
                if (cx != null && (cy != null || cy2 != null) && cr != null) {
                    if (mm != null) {
                        mm.update(cr);
                    }
                    Bubble b = new Bubble();
                    b.cx = cx;
                    b.cy = cy;
                    b.cr = cr;
                    b.point = (DPoint)item;
                    bubbles.add(b);
                }
            }
            item = item.getNext();
        }
        if (bdata == null) {
            return;
        }
        boolean bl = bdata.use_y2 = y_axis_is == 2;
        if (mm != null) {
            mm.update(bdata.r_axis.getProperties().get("P_MIN_HINT.DAxis.core.jscrib"));
            mm.update(bdata.r_axis.getProperties().get("P_MAX_HINT.DAxis.core.jscrib"));
            bdata.r_min = mm.getVMin();
            bdata.r_max = mm.getVMax();
        }
        bdata.bubbles = new Bubble[bubbles.size()];
        bubbles.toArray(bdata.bubbles);
        Arrays.sort(bdata.bubbles);
        int mid = bdata.bubbles.length / 2;
        int i = 0;
        int j = bdata.bubbles.length - 1;
        while (i < mid) {
            Bubble b = bdata.bubbles[i];
            bdata.bubbles[i] = bdata.bubbles[j];
            bdata.bubbles[j] = b;
            ++i;
            --j;
        }
    }

    private static void renderBubble(int icrv, CurveStyle ccurve, XY p, DefaultChartRenderData d, RenderPersistData rpd, boolean circle) throws DefaultRenderChartLocation {
        if (p.bubbles_data == null) {
            return;
        }
        SolidBrush brush = new SolidBrush(-1);
        BubbleData bdata = p.bubbles_data[icrv];
        if (bdata == null) {
            String title = DefaultChartRenderData.getResourceString(ccurve.curve_.getName(), (DI18N)rpd.graphic.getChildOfClass(DI18N.class));
            d.error("No valid points found for " + (circle ? "T_CIRCLE" : "T_BUBBLE") + " curve (name:" + title + ")", rpd);
            return;
        }
        if (bdata.r_axis == null) {
            if (circle) {
                d.error("Missing axis for circle radius", rpd);
            } else {
                d.error("Missing axis for bubble radius", rpd);
            }
            return;
        }
        Object y_obj = null;
        Object x_obj = null;
        Object r_obj = null;
        LineStylePen pen = new LineStylePen(255);
        DefaultRenderChartLocation loc = null;
        int ib = 0;
        while (ib < bdata.bubbles.length) {
            int n;
            Bubble bubble = bdata.bubbles[ib];
            x_obj = bubble.cx.getValue(x_obj);
            int x = (int)p.x_scale.toScale(x_obj);
            if (bdata.use_y2) {
                y_obj = bubble.cy.getValue(y_obj);
                n = (int)p.y2_scale.toScale(y_obj);
            } else {
                y_obj = bubble.cy.getValue(y_obj);
                n = (int)p.y_scale.toScale(y_obj);
            }
            int y = n;
            r_obj = bubble.cr.getValue(r_obj);
            int r = (int)bdata.r_scale.toScale(r_obj);
            if (circle) {
                if (d.drawing()) {
                    pen.setRGBA(ccurve.style_.getBack());
                    d.gc_.setPen(pen);
                    d.gc_.drawCircle(x, y, r);
                } else if (DrawUtilIGC.ovalUnder(x - r, y - r, 2 * r, 2 * r, d.lx_, d.ly_)) {
                    loc = new DefaultRenderChartLocation("CurvePoint", bubble.point, new Rect(d.lx_, d.ly_, 0, 0));
                }
            } else if (d.drawing()) {
                brush.setRGBA(ccurve.style_.getBack());
                d.gc_.setBrush(brush);
                d.gc_.fillCircle(x, y, r);
                d.gc_.drawCircle(x, y, r);
            } else if (DrawUtilIGC.ovalContains(x - r, y - r, 2 * r, 2 * r, d.lx_, d.ly_)) {
                loc = new DefaultRenderChartLocation("CurvePoint", bubble.point, new Rect(d.lx_, d.ly_, 0, 0));
            }
            ++ib;
        }
        if (loc != null) {
            throw loc;
        }
    }

    private static class Bubble
    implements Comparable {
        IDCoord cx;
        IDCoord cy;
        IDCoord cr;
        DPoint point;

        private Bubble() {
        }

        public int compareTo(Object o) {
            Bubble b2 = (Bubble)o;
            return ((Comparable)this.cr.getValue(null)).compareTo(b2.cr.getValue(null));
        }
    }

    private static class BubbleData {
        DAxis r_axis;
        Object r_min;
        Object r_max;
        IScale r_scale;
        boolean use_y2;
        Bubble[] bubbles;

        private BubbleData() {
        }
    }

    private static class SAPoint {
        public DPoint point;
        public IDCoord x_coord;
        public IDCoord y_coord;
        public Object y_value;

        private SAPoint() {
        }
    }

    private static class StackedArea {
        StackedArea below;
        int index;
        ArrayList points;
        double ymin;
        double ymax;
        boolean area;

        private StackedArea() {
        }
    }

    private static class XY
    implements IDisposable {
        DAxis x_axis;
        DAxis y_axis;
        DAxis y2_axis;
        IGCDStyle x_axis_style;
        IGCDStyle y_axis_style;
        IGCDStyle y2_axis_style;
        IScale x_scale;
        IScale y_scale;
        IScale y2_scale;
        Insets xam;
        Insets yam;
        Insets y2am;
        StackedArea y1_top_area;
        StackedArea y2_top_area;
        int ibar_width;
        int Rmin;
        int Rmax;
        BubbleData[] bubbles_data;

        private XY() {
        }

        public void dispose() {
        }
    }
}

