/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.text.UFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.Date;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.tools.internal.CalendarField;
import org.eclipse.tptp.platform.report.tools.internal.VLong;

public class LinearDateScale
implements IScale {
    protected double smin_;
    protected double smax_;
    protected Date dmin_;
    protected Date dmax_;
    protected long tmin_;
    protected long tmax_;
    protected double k_;
    protected boolean reverse_;
    protected UFormat format_;
    protected boolean date_;
    protected ULocale locale_;
    private boolean output_once = false;

    public LinearDateScale(double smin, double smax, Object _vmin, Object _vmax) {
        this.smin_ = smin;
        this.smax_ = smax;
        this.reverse_ = false;
        this.date_ = false;
        this.setValueRange(_vmin, _vmax);
    }

    public void setValueRange(Object v1, Object v2) {
        this.tmax_ = 0L;
        this.tmin_ = 0L;
        if (v1 instanceof Date) {
            this.dmin_ = (Date)v1;
            this.tmin_ = this.dmin_.getTime();
        } else {
            this.tmin_ = 0L;
        }
        if (v2 instanceof Date) {
            this.dmax_ = (Date)v2;
            this.tmax_ = this.dmax_.getTime();
        } else {
            this.tmax_ = 0L;
        }
        if (this.tmin_ > this.tmax_) {
            long l = this.tmin_;
            this.tmin_ = this.tmax_;
            this.tmax_ = l;
            Date d = this.dmin_;
            this.dmin_ = this.dmax_;
            this.dmax_ = d;
        }
        this.k_ = this.tmax_ == this.tmin_ ? Double.NaN : (this.smax_ - this.smin_) / (double)(this.tmax_ - this.tmin_);
    }

    public boolean isValid() {
        return this.tmin_ < this.tmax_;
    }

    public void setTextFormat(UFormat _format) {
        this.format_ = _format;
    }

    public String valueText(Object _value) {
        Date date = null;
        if (_value instanceof Date) {
            date = (Date)_value;
        } else if (_value instanceof VLong) {
            date = new Date(((VLong)_value).longValue());
        } else {
            return null;
        }
        if (this.format_ == null) {
            this.format_ = this.locale_ == null ? SimpleDateFormat.getDateInstance((int)3) : SimpleDateFormat.getDateInstance((int)3, (ULocale)this.locale_);
        }
        try {
            String txt = this.format_.format((Object)date);
            return txt;
        }
        catch (IllegalArgumentException e) {
            if (!this.output_once) {
                System.err.println("For object's class =" + (date == null ? null : date.getClass().getName()));
                e.printStackTrace();
                this.output_once = true;
            }
            return null;
        }
    }

    public void setReversed(boolean b) {
        this.reverse_ = b;
    }

    public boolean isReversed() {
        return this.reverse_;
    }

    public Object getValueMax(Object _value) {
        if (this.date_) {
            Date date = _value instanceof Date ? (Date)_value : new Date();
            date.setTime(this.tmax_);
            return date;
        }
        return null;
    }

    public Object getValueMin(Object _value) {
        if (this.date_) {
            Date date = _value instanceof Date ? (Date)_value : new Date();
            date.setTime(this.tmin_);
            return date;
        }
        return null;
    }

    public double getScaleMin() {
        return this.smin_;
    }

    public double getScaleMax() {
        return this.smax_;
    }

    public double toScale(Object _value) {
        long value;
        if (_value instanceof Date) {
            value = ((Date)_value).getTime();
        } else if (_value instanceof VLong) {
            value = ((VLong)_value).longValue();
        } else {
            return -1.0;
        }
        double scl = this.reverse_ ? this.smax_ - this.k_ * (double)(value - this.tmin_) : this.smin_ + this.k_ * (double)(value - this.tmin_);
        return scl;
    }

    public Object toValue(double scale, Object _value) {
        double val = this.reverse_ ? (double)this.tmin_ + (this.smax_ - scale) / this.k_ : (double)this.tmin_ + (scale - this.smin_) / this.k_;
        Date date = _value instanceof Date ? (Date)_value : new Date();
        date.setTime((long)val);
        return date;
    }

    public void setScaleRange(double scale_min, double scale_max) {
        this.smin_ = scale_min;
        this.smax_ = scale_max;
        this.k_ = this.tmax_ == this.tmin_ ? Double.NaN : (this.smax_ - this.smin_) / (double)(this.tmax_ - this.tmin_);
    }

    public Object stepFirst(Object _step) {
        long first = -1L;
        if (_step instanceof Number) {
            long step = ((Number)_step).longValue();
            if ((float)step <= 0.0f) {
                return null;
            }
            long vdn = (long)Math.ceil((double)this.tmin_ / (double)step);
            if ((double)Math.abs(vdn) < 1.0E-6) {
                vdn = 0L;
            }
            first = vdn * step;
        } else if (_step instanceof CalendarField) {
            CalendarField cal_step = (CalendarField)_step;
            Calendar val = this.locale_ == null ? Calendar.getInstance() : Calendar.getInstance((ULocale)this.locale_);
            val.setTimeInMillis(this.tmin_);
            int fidx = 0;
            while (fidx < val.getFieldCount()) {
                if (cal_step.isSet(fidx)) {
                    int o_val = val.get(fidx);
                    int r_val = cal_step.get(fidx);
                    int n_val = r_val > 0 ? r_val * (int)Math.ceil((double)o_val / (double)r_val) : o_val;
                    val.set(fidx, n_val);
                }
                ++fidx;
            }
            first = val.getTimeInMillis();
        } else {
            return null;
        }
        return new VLong(first);
    }

    public Object stepNext(Object _step, Object _last) {
        if (!(_last instanceof VLong)) {
            return null;
        }
        VLong v_last = (VLong)_last;
        long next = v_last.longValue();
        if (_step instanceof Number) {
            long step = -1L;
            if (_step instanceof Number) {
                step = ((Number)_step).longValue();
            }
            next += step;
        } else if (_step instanceof CalendarField) {
            CalendarField cal_step = (CalendarField)_step;
            Calendar val = this.locale_ == null ? Calendar.getInstance() : Calendar.getInstance((ULocale)this.locale_);
            val.setTimeInMillis(v_last.longValue());
            int fidx = 0;
            while (fidx < val.getFieldCount()) {
                if (cal_step.isSet(fidx)) {
                    int o_val = val.get(fidx);
                    int r_val = cal_step.get(fidx);
                    int n_val = o_val + r_val;
                    val.set(fidx, n_val);
                }
                ++fidx;
            }
            next = val.getTimeInMillis();
        } else {
            return null;
        }
        if (next > this.tmax_) {
            return null;
        }
        v_last.setValue(next);
        return v_last;
    }

    public double getScaleForBar() {
        return this.smin_;
    }

    public void setLocale(ULocale _locale) {
        this.locale_ = _locale;
    }
}

