/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.chart.internal.LinearNumberScale;
import org.eclipse.tptp.platform.report.tools.internal.VDouble;

public class LogNumberScale
extends LinearNumberScale {
    private double log_vmin_;
    private double log_vmax_;
    private double curr_step_;
    private double nlog_chgt_;

    public LogNumberScale(double scale_min, double scale_max, double vmin, double vmax) {
        super(scale_min, scale_max, Math.max(1.0E-10, vmin), Math.max(1.0E-10, vmax));
        this.setValueRange(vmin, vmax);
    }

    public LogNumberScale(double scale_min, double scale_max, Object vmin, Object vmax) {
        super(scale_min, scale_max, 0.0, 0.0);
        this.setValueRange(vmin, vmax);
    }

    public boolean isValid() {
        return this.log_vmin_ < this.log_vmax_;
    }

    public void setValueRange(Object v1, Object v2) {
        this.log_vmin_ = -1.0;
        this.log_vmax_ = -2.0;
        this.vmin_ = -1.0;
        this.vmax_ = -2.0;
        this.k_ = Double.NaN;
        if (!(v1 instanceof Number)) {
            return;
        }
        if (!(v2 instanceof Number)) {
            return;
        }
        this.setValueRange(((Number)v1).doubleValue(), ((Number)v2).doubleValue());
    }

    public void setValueRange(double d1, double d2) {
        if (d1 < d2) {
            this.vmin_ = d1;
            this.vmax_ = d2;
        } else {
            this.vmin_ = d2;
            this.vmax_ = d1;
        }
        this.vmin_ = Math.max(1.0E-10, this.vmin_);
        this.vmax_ = Math.max(1.0E-10, this.vmax_);
        this.log_vmin_ = Math.log(this.vmin_);
        this.log_vmax_ = Math.log(this.vmax_);
        this.k_ = this.log_vmax_ == this.log_vmin_ ? Double.NaN : (this.dmax_ - this.dmin_) / (this.log_vmax_ - this.log_vmin_);
    }

    public double toScale(Object _value) {
        if (!(_value instanceof Number)) {
            return -1.0;
        }
        double value = ((Number)_value).doubleValue();
        double scl = this.reverse_ ? this.dmax_ - (Math.log(value) - this.log_vmin_) / this.k_ : this.dmin_ + this.k_ * (Math.log(value) - this.log_vmin_);
        return scl;
    }

    public void setScaleRange(double scale_min, double scale_max) {
        super.setScaleRange(scale_min, scale_max);
        this.k_ = this.log_vmax_ == this.log_vmin_ ? Double.NaN : (this.dmax_ - this.dmin_) / (this.log_vmax_ - this.log_vmin_);
    }

    public Object toValue(double scale, Object _value) {
        double val = this.reverse_ ? Math.exp(this.log_vmin_ + (this.dmax_ - scale) / this.k_) : Math.exp(this.log_vmin_ + (scale - this.dmin_) / this.k_);
        if (_value instanceof VDouble) {
            return ((VDouble)_value).setValue(val);
        }
        return new VDouble(val);
    }

    public Object stepFirst(Object _step) {
        double step = -1.0;
        if (_step instanceof Number) {
            step = ((Number)_step).doubleValue();
        }
        if (step <= 0.0) {
            return null;
        }
        double base0 = 1.0;
        double v = this.vmin_;
        while (v < 1.0) {
            v *= 10.0;
            base0 *= (double)0.1f;
        }
        while (v > 10.0) {
            v /= 10.0;
            base0 *= 10.0;
        }
        double v_for_step = step * Math.ceil(v / step);
        double vdn = v_for_step * base0;
        this.nlog_chgt_ = base0 * 10.0;
        this.curr_step_ = step * base0;
        return new VDouble(vdn);
    }

    public Object stepNext(Object _step, Object _last) {
        if (!(_last instanceof VDouble)) {
            return null;
        }
        VDouble last_value = (VDouble)_last;
        double next = last_value.doubleValue();
        if ((next += this.curr_step_) > this.nlog_chgt_) {
            this.curr_step_ *= 10.0;
            next = this.curr_step_ * Math.ceil(next / this.curr_step_);
            this.nlog_chgt_ *= 10.0;
        }
        if (next > this.vmax_) {
            return null;
        }
        return last_value.setValue(next);
    }
}

