/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;

public class MinMax {
    private Comparable vmin;
    private Comparable vmax;
    private int invalid_values;
    private boolean check_null_range;
    private boolean null_range;

    public MinMax(DAxis axis) {
        this.reset(axis);
    }

    public boolean isValid() {
        return this.vmin != null && this.vmax != null;
    }

    public boolean isNullRange() {
        if (this.check_null_range) {
            return this.null_range;
        }
        this.check_null_range = false;
        this.null_range = this.vmin == null || this.vmax == null || this.vmin.compareTo(this.vmax) == 0;
        return this.null_range;
    }

    public Comparable getVMin() {
        return this.vmin;
    }

    public Comparable getVMax() {
        return this.vmax;
    }

    public void reset() {
        this.vmax = null;
        this.vmin = null;
        this.invalid_values = 0;
        this.check_null_range = true;
        this.null_range = true;
    }

    public void reset(DAxis axis) {
        this.reset();
        if (axis == null) {
            return;
        }
        Object min_hint = axis.getProperties().get("P_MIN_HINT.DAxis.core.jscrib");
        Object max_hint = axis.getProperties().get("P_MAX_HINT.DAxis.core.jscrib");
        if (min_hint instanceof Comparable) {
            this.vmin = MinMax.toComparable(min_hint);
        }
        if (max_hint instanceof Comparable) {
            this.vmax = MinMax.toComparable(max_hint);
        }
    }

    public boolean update(IDCoord coord) {
        if (coord == null) {
            return false;
        }
        Object vo = coord.getValue(null);
        return this.update(vo);
    }

    public boolean update(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof Comparable)) {
            ++this.invalid_values;
            return false;
        }
        Comparable v = MinMax.toComparable(value);
        boolean changes = false;
        if (this.vmin == null || this.vmin.compareTo(v) > 0) {
            this.vmin = v;
            changes = true;
        }
        if (this.vmax == null || this.vmax.compareTo(v) < 0) {
            this.vmax = v;
            changes = true;
        }
        return changes;
    }

    public int invalidValueCount() {
        return this.invalid_values;
    }

    private static Comparable toComparable(Object o) {
        if (o instanceof Number) {
            return new Double(((Number)o).doubleValue());
        }
        return (Comparable)o;
    }

    public String toString() {
        String s = super.toString();
        s = String.valueOf(s) + "{ valid=" + this.isValid() + " null_range=" + this.null_range + " vmin=" + this.vmin + "..vmax=" + this.vmax + "}";
        return s;
    }
}

