/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.internal;

import com.ibm.icu.util.ULocale;
import org.eclipse.tptp.platform.report.chart.internal.CurveStyle;
import org.eclipse.tptp.platform.report.chart.internal.IScale;
import org.eclipse.tptp.platform.report.chart.internal.Insets;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.IDAlignment;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.tools.internal.DAlignmentPair;
import org.eclipse.tptp.platform.report.tools.internal.IDisposable;

public class RenderPersistData
implements IDisposable {
    public static final int V_TITLE = 1;
    public static final int V_LEGEND = 2;
    int validity;
    public DGraphic graphic;
    public ULocale locale;
    public Rect graphic_rect;
    public String graphic_type;
    public IImage g_wallpaper;
    public int e_wallpaper;
    public IGCDStyle g_style;
    boolean title_displayed;
    DAlignmentPair title_aln;
    String title_text;
    Rect title_rect;
    String title_displayed_text;
    int title_render_aln;
    boolean legend_displayed;
    DAlignmentPair legend_aln;
    Rect legend_rect;
    int entry_max_width;
    int entry_max_height;
    int legend_symbol_size;
    boolean legend_vertical_layout;
    int legend_n_lines;
    int legend_n_entry_by_line;
    CurveStyle[] curve_styles;
    Rect ag_rect;
    IDisposable g;

    public RenderPersistData(DGraphic gph) {
        this.graphic = gph;
        this.validity = 0;
        this.locale = this.graphic != null ? this.graphic.getLocale() : null;
    }

    public boolean isValid(int mask) {
        return (this.validity & mask) != 0;
    }

    public void validate(int mask) {
        this.validity |= mask;
    }

    public void invalidate(int mask) {
        this.validity &= ~mask;
        if (this.g != null) {
            this.g.dispose();
        }
        this.g = null;
    }

    public void dispose() {
        if (this.g != null) {
            this.g.dispose();
            this.g = null;
        }
    }

    public void rebuildCurveStyles(int n_curves, float _scale) {
        if (this.curve_styles != null && n_curves != this.curve_styles.length) {
            this.curve_styles = null;
        }
        if (this.curve_styles == null) {
            this.curve_styles = new CurveStyle[n_curves];
        }
        int ic = 0;
        IDItem item = this.graphic.getFirstChild();
        while (item != null) {
            if (item instanceof DCurve) {
                DCurve curve = (DCurve)item;
                this.curve_styles[ic++] = new CurveStyle(curve, _scale);
            }
            item = item.getNext();
        }
    }

    static class Histogram
    implements IDisposable {
        DAxis axis;
        IGCDStyle axis_style;
        IScale y_scale;
        Insets yam;
        int n_bar;
        int n_max_points_by_curve;
        int h_label_height;
        float wbartobar;
        float wbar;
        float xdecbar;
        int _3d_z;
        boolean thin_bar;
        IDAlignment h_axis_alignment;

        Histogram() {
        }

        public void dispose() {
            if (this.axis_style != null) {
                this.axis_style = null;
            }
        }
    }
}

