/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;

public class SVGGeneratorPreferences {
    public static final String PREF_DELIMINATOR = ",";
    public static final String FONT_PREF_DELIMINATOR = ";";
    public static final String FONT_VAL_PREF_DELIMINATOR = ":";
    protected boolean showValues = false;
    protected boolean defaultSet = true;
    protected boolean showPercentage = false;
    protected String fontFamily = "arial";
    protected String fontWeight = "normal";
    protected String fontStyle = "normal";
    protected int fontSize = 11;
    protected String fontColor = "#000000";
    protected String paletteId = "SPRING";
    protected String userPreferenceString;

    public String getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(String fontColor) {
        this.fontColor = fontColor;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public String getPaletteId() {
        return this.paletteId;
    }

    public void setPaletteId(String paletteId) {
        this.paletteId = paletteId;
    }

    public boolean getShowPercentage() {
        return this.showPercentage;
    }

    public void setShowPercentage(boolean showPercentage) {
        this.showPercentage = showPercentage;
    }

    public boolean getShowValues() {
        return this.showValues;
    }

    public void setShowValues(boolean showValues) {
        this.showValues = showValues;
        this.defaultSet = false;
    }

    public String getUserPreferenceString() {
        this.userPreferenceString = String.valueOf(this.paletteId) + PREF_DELIMINATOR + this.fontSize + PREF_DELIMINATOR + "font-weight" + FONT_VAL_PREF_DELIMINATOR + this.fontWeight + FONT_PREF_DELIMINATOR + "font-style" + FONT_VAL_PREF_DELIMINATOR + this.fontStyle + FONT_PREF_DELIMINATOR + "font-family" + FONT_VAL_PREF_DELIMINATOR + this.fontFamily + FONT_PREF_DELIMINATOR + "fill" + FONT_VAL_PREF_DELIMINATOR + this.fontColor + FONT_PREF_DELIMINATOR + PREF_DELIMINATOR + (this.showValues ? "1" : "0") + PREF_DELIMINATOR + (this.showValues ? "1" : "0") + PREF_DELIMINATOR + (this.showPercentage ? "1" : "0");
        return this.userPreferenceString;
    }

    public void setUserPreferenceString(String userPreferenceString) {
        this.userPreferenceString = userPreferenceString;
        this.updatePreferences();
    }

    protected void updatePreferences() {
        if (this.userPreferenceString == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.userPreferenceString, PREF_DELIMINATOR);
        if (st.hasMoreTokens()) {
            this.paletteId = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.fontSize = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            String fontPreferences = st.nextToken();
            StringTokenizer fontSt = new StringTokenizer(fontPreferences, FONT_PREF_DELIMINATOR);
            while (fontSt.hasMoreTokens()) {
                this.setFontPreferences(fontSt.nextToken());
            }
        }
        if (st.hasMoreTokens()) {
            boolean bl = this.showValues = Integer.parseInt(st.nextToken()) == 1;
        }
        if (st.hasMoreTokens()) {
            boolean showActual;
            boolean bl = showActual = Integer.parseInt(st.nextToken()) == 1;
            if (showActual) {
                this.showValues = showActual;
            }
        }
        if (st.hasMoreTokens()) {
            this.showPercentage = Integer.parseInt(st.nextToken()) == 1;
        }
    }

    protected boolean setFontPreferences(String preference) {
        StringTokenizer fontPrefSt = new StringTokenizer(preference, FONT_VAL_PREF_DELIMINATOR);
        if (fontPrefSt.hasMoreTokens()) {
            String name = fontPrefSt.nextToken();
            if (name.trim().equalsIgnoreCase("font-weight")) {
                if (fontPrefSt.hasMoreTokens()) {
                    this.fontWeight = fontPrefSt.nextToken();
                }
            } else if (name.trim().equalsIgnoreCase("font-style")) {
                if (fontPrefSt.hasMoreTokens()) {
                    this.fontStyle = fontPrefSt.nextToken();
                }
            } else if (name.trim().equalsIgnoreCase("font-family")) {
                if (fontPrefSt.hasMoreTokens()) {
                    this.fontFamily = fontPrefSt.nextToken();
                }
            } else if (name.trim().equalsIgnoreCase("fill")) {
                if (fontPrefSt.hasMoreTokens()) {
                    this.fontColor = fontPrefSt.nextToken();
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public Chart applyPreferences(Chart inputModel) {
        Configuration configuration = inputModel.getConfiguration();
        configuration.getPalettes().setPaletteId(this.getPaletteId());
        if (this.defaultSet) {
            if (inputModel.getType().equals("pie") || inputModel.getType().equals("pie3D")) {
                this.showValues = true;
                this.showPercentage = true;
            } else {
                this.showValues = false;
                this.showPercentage = false;
            }
        }
        inputModel.getConfiguration().getDataValue().setPercentageVisibility(this.showPercentage ? "visible" : "hidden");
        inputModel.getConfiguration().getDataValue().setValueVisibility(this.showPercentage ? "visible" : "hidden");
        configuration.getPreferences().setStoredPreferences(this.getUserPreferenceString());
        return inputModel;
    }
}

