/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGContainerBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGGroup
extends SVGContainerBase
implements Serializable,
ISVGGroup {
    private Element implementation;
    private String transformation;
    private String fill;
    private String stroke;
    static final long serialVersionUID = 1454137114058834968L;
    Hashtable userEvents = null;

    public SVGGroup() {
        this.setTagName("g");
    }

    public Element doImplementation(Document svgDocument) throws NullPointerException {
        try {
            this.implementation = super.doImplementation(svgDocument);
            if (this.transformation != null) {
                this.implementation.setAttribute("transform", this.transformation);
            }
            if (this.fill != null) {
                this.implementation.setAttribute("fill", this.fill);
            }
            if (this.stroke != null) {
                this.implementation.setAttribute("stroke", this.stroke);
            }
            if (this.userEvents != null) {
                Enumeration e = this.userEvents.keys();
                while (e.hasMoreElements()) {
                    String event = (String)e.nextElement();
                    this.implementation.setAttribute(event, (String)this.userEvents.get(event));
                }
            }
        }
        catch (DOMException dOMException) {}
        return this.implementation;
    }

    public Element doImplementation(Document svgDocument, SVGBase[] children) throws NullPointerException {
        this.setChildren(children);
        try {
            this.implementation = super.doImplementation(svgDocument);
            if (this.userEvents != null) {
                Enumeration e = this.userEvents.keys();
                while (e.hasMoreElements()) {
                    String event = (String)e.nextElement();
                    this.implementation.setAttribute(event, (String)this.userEvents.get(event));
                }
            }
        }
        catch (DOMException dOMException) {}
        return this.implementation;
    }

    public Element doImplementation(Document svgDocument, SVGBase[] children, String title, String description) throws NullPointerException {
        this.setChildren(children);
        this.setTitle(title);
        this.setDesc(description);
        try {
            this.implementation = super.doImplementation(svgDocument);
            if (this.userEvents != null) {
                Enumeration e = this.userEvents.keys();
                while (e.hasMoreElements()) {
                    String event = (String)e.nextElement();
                    this.implementation.setAttribute(event, (String)this.userEvents.get(event));
                }
            }
        }
        catch (DOMException dOMException) {}
        return this.implementation;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public void addEvent(String event, String action) {
        if (this.userEvents == null) {
            this.userEvents = new Hashtable();
        }
        this.userEvents.put(event, action);
    }

    public String getTransformation() {
        return this.transformation;
    }

    public void setTransformation(String tTransformation) {
        this.transformation = tTransformation;
    }

    public String getFill() {
        return this.fill;
    }

    public String getStroke() {
        return this.stroke;
    }

    public void setFill(String string) {
        if (string != null && !string.trim().equals("")) {
            this.fill = string;
        }
    }

    public void setStroke(String string) {
        if (string != null && !string.trim().equals("")) {
            this.stroke = string;
        }
    }
}

