/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGRotateText
extends SVGText {
    static final long serialVersionUID = 195789502628577102L;
    protected Dimension2D boundingBox = new Dimension(0, 0);
    protected int anchorStyle = 1;
    protected double degrees;
    protected Font measureFont;
    protected static BufferedImage bi = new BufferedImage(1, 1, 1);
    protected static Graphics2D graphics = bi.createGraphics();

    public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
        return super.doImplementation(svgDocument);
    }

    public String getFontSize() {
        if (super.getFontSize() == null) {
            return "8";
        }
        return super.getFontSize();
    }

    public String getFontFamily() {
        if (super.getFontFamily() == null) {
            return "arial";
        }
        return super.getFontFamily();
    }

    public String getFontStyle() {
        if (super.getFontStyle() == null) {
            return "normal";
        }
        return super.getFontStyle();
    }

    public static Dimension2D getBoundingBox(String text, double degrees, Font measureFont) {
        Rectangle2D rectangle = measureFont.getStringBounds(text, graphics.getFontRenderContext());
        double radDegrees = degrees * Math.PI / 180.0;
        Dimension boundingBox = new Dimension(0, 0);
        ((Dimension2D)boundingBox).setSize(rectangle.getWidth() * Math.cos(radDegrees) + rectangle.getHeight() * Math.sin(radDegrees), rectangle.getWidth() * Math.sin(radDegrees) + rectangle.getHeight() * Math.cos(radDegrees));
        return boundingBox;
    }

    private int getFontAWTStyle() {
        if (this.getFontStyle() != null && this.getFontStyle().trim().equalsIgnoreCase("bold")) {
            return 1;
        }
        if (this.getFontStyle() != null && this.getFontStyle().trim().equalsIgnoreCase("italic")) {
            return 2;
        }
        return 0;
    }

    public Dimension2D getBoundingBox() {
        this.measureFont = new Font(this.getFontFamily(), this.getFontAWTStyle(), Integer.parseInt(this.getFontSize()));
        Rectangle2D rectangle = this.measureFont.getStringBounds(this.getText(), graphics.getFontRenderContext());
        double radDegreees = this.degrees * Math.PI / 180.0;
        this.boundingBox.setSize(rectangle.getWidth() * Math.cos(radDegreees) + rectangle.getHeight() * Math.sin(radDegreees), rectangle.getWidth() * Math.sin(radDegreees) + rectangle.getHeight() * Math.cos(radDegreees));
        return this.boundingBox;
    }

    public int getAnchorStyle() {
        return this.anchorStyle;
    }

    public double getDegrees() {
        return this.degrees;
    }

    public void setDegrees(double degrees) {
        this.degrees = degrees;
    }

    public void setAnchorStyle(int anchorStyle) {
        this.anchorStyle = anchorStyle;
    }
}

