/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.generator;

import java.io.Serializable;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.ISVGTextBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGraphicBase;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SVGTextBase
extends SVGGraphicBase
implements ISVGTextBase,
Serializable {
    private String text;
    private String fontFamily;
    private String fontSize;
    private String fontWeight;
    private String fontStyle;
    private String textDecoration;
    private String wordSpacing;
    private String letterSpacing;
    private String textAnchor;

    public Element doImplementation(Document svgDocument) throws DOMException, NullPointerException {
        if (this.text == null) {
            return null;
        }
        Element textElement = super.doImplementation(svgDocument);
        if (textElement != null) {
            textElement.appendChild(svgDocument.createTextNode(this.text));
            if (this.fontFamily != null) {
                textElement.setAttribute("font-family", this.fontFamily);
            }
            if (this.fontSize != null) {
                textElement.setAttribute("font-size", this.fontSize);
            }
            if (this.fontWeight != null) {
                textElement.setAttribute("font-weight", this.fontWeight);
            }
            if (this.fontStyle != null) {
                textElement.setAttribute("font-style", this.fontStyle);
            }
            if (this.textDecoration != null) {
                textElement.setAttribute("text-decoration", this.textDecoration);
            }
            if (this.wordSpacing != null) {
                textElement.setAttribute("word-spacing", this.wordSpacing);
            }
            if (this.letterSpacing != null) {
                textElement.setAttribute("letter-spacing", this.letterSpacing);
            }
            if (this.textAnchor != null) {
                textElement.setAttribute("text-anchor", this.textAnchor);
            }
        }
        return textElement;
    }

    public String getText() {
        return this.text;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public String getFontStyle() {
        return this.fontStyle;
    }

    public String getTextDecoration() {
        return this.textDecoration;
    }

    public String getWordSpacing() {
        return this.wordSpacing;
    }

    public String getLetterSpacing() {
        return this.letterSpacing;
    }

    public String getTextAnchor() {
        return this.textAnchor;
    }

    public void setFontFamily(String fontFamily) {
        this.fontFamily = fontFamily;
    }

    public void setFontSize(String fontSize) {
        this.fontSize = fontSize;
    }

    public void setFontStyle(String fontStyle) {
        this.fontStyle = fontStyle;
    }

    public void setFontWeight(String fontWeight) {
        this.fontWeight = fontWeight;
    }

    public void setLetterSpacing(String letterSpacing) {
        this.letterSpacing = letterSpacing;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTextAnchor(String textAnchor) {
        this.textAnchor = textAnchor;
    }

    public void setTextDecoration(String textDecoration) {
        this.textDecoration = textDecoration;
    }

    public void setWordSpacing(String wordSpacing) {
        this.wordSpacing = wordSpacing;
    }
}

