/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CustomFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DateFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGCustomFormatImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDateFormatImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerLineImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGMarkerRegionImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGNumberFormatImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGUnitDefinitionImpl;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;

public class SVGAxisDefinitionImpl
extends SVGInputBase
implements AxisDefinition {
    protected static final String ID_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = null;
    protected static final double LABEL_ROTATION_EDEFAULT = 0.0;
    protected double labelRotation = 0.0;
    protected boolean labelRotationESet = false;
    protected static final double MAX_EDEFAULT = 0.0;
    protected double max = 0.0;
    protected boolean maxESet = false;
    protected static final double MIN_EDEFAULT = 0.0;
    protected double min = 0.0;
    protected boolean minESet = false;
    protected static final String SCALE_EDEFAULT = null;
    protected String scale = SCALE_EDEFAULT;
    protected UnitDefinition majorUnit = null;
    protected UnitDefinition minorUnit = null;
    protected List markerLine = null;
    protected List markerRegion = null;
    protected NumberFormat numberFormat = null;
    protected DateFormat dateFormat = null;
    protected CustomFormat customFormat = null;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;
    protected DAxis axis;

    protected SVGAxisDefinitionImpl() {
    }

    public SVGAxisDefinitionImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGAxisDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.axis = axis;
    }

    public String getId() {
        return this.axis.getName();
    }

    public void setId(String newId) {
        this.axis.setName(newId);
    }

    public String getLabel() {
        return this.axis.getTitle();
    }

    public void setLabel(String newLabel) {
        this.axis.setTitle(newLabel);
    }

    public double getLabelRotation() {
        String rotationId;
        if (this.axis.getProperties().get("P_LABEL_ROTATION.DAxis.core.jscrib") != null) {
            this.labelRotationESet = true;
        }
        if ((rotationId = this.axis.getProperties().get("P_LABEL_ROTATION.DAxis.core.jscrib", "zeroDegree")).equals("plusNinetyDegrees")) {
            return 90.0;
        }
        if (rotationId.equals("minusNinetyDegrees")) {
            return -90.0;
        }
        return 0.0;
    }

    public void setLabelRotation(double newLabelRotation) {
        this.axis.getProperties().store("P_LABEL_ROTATION.DAxis.core.jscrib", newLabelRotation);
        this.labelRotationESet = true;
    }

    public void unsetLabelRotation() {
        this.labelRotationESet = false;
        this.axis.getProperties().remove("P_LABEL_ROTATION.DAxis.core.jscrib");
    }

    public boolean isSetLabelRotation() {
        if (!this.labelRotationESet) {
            this.getLabelRotation();
        }
        return this.labelRotationESet;
    }

    public double getMax() {
        if (this.axis.getProperties().get("P_MAX.DAxis.core.jscrib") != null) {
            this.maxESet = true;
        }
        return this.axis.getProperties().get("P_MAX.DAxis.core.jscrib", 0.0);
    }

    public void setMax(double newMax) {
        this.axis.getProperties().store("P_MAX.DAxis.core.jscrib", newMax);
        this.maxESet = true;
    }

    public void unsetMax() {
        this.maxESet = false;
        this.axis.getProperties().remove("P_MAX.DAxis.core.jscrib");
    }

    public boolean isSetMax() {
        if (!this.maxESet) {
            this.getMax();
        }
        return this.maxESet;
    }

    public double getMin() {
        if (this.axis.getProperties().get("P_MIN.DAxis.core.jscrib") != null) {
            this.minESet = true;
        }
        return this.axis.getProperties().get("P_MIN.DAxis.core.jscrib", 0.0);
    }

    public void setMin(double newMin) {
        this.axis.getProperties().store("P_MIN.DAxis.core.jscrib", newMin);
        this.minESet = true;
    }

    public void unsetMin() {
        this.minESet = false;
        this.axis.getProperties().remove("P_MIN.DAxis.core.jscrib");
    }

    public boolean isSetMin() {
        if (!this.minESet) {
            this.getMin();
        }
        return this.minESet;
    }

    public String getScale() {
        if (this.axis.getScaleType() != null && this.axis.getScaleType().equals("S_LOG.DAxis.core.jscrib")) {
            return "log";
        }
        return "linear";
    }

    public void setScale(String newScale) {
        this.axis.setScaleType(newScale);
    }

    public UnitDefinition getMajorUnit() {
        if (this.majorUnit == null && this.axis != null && this._dgraphic != null) {
            this.majorUnit = new SVGUnitDefinitionImpl(this._chart, this._dgraphic, this.axis, "P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", "P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", "P_MAJUNIT_VALUE.DAxis.core.jscrib");
        }
        return this.majorUnit;
    }

    public void setMajorUnit(UnitDefinition newMajorUnit) {
        this.majorUnit = newMajorUnit;
    }

    public void assignMajorUnit(UnitDefinition source) {
        this.majorUnit = new SVGUnitDefinitionImpl(this._chart, this._dgraphic, this.axis, "P_MAJUNIT_SHOW_TICK.DAxis.core.jscrib", "P_MAJUNIT_SHOWGRID.DAxis.core.jscrib", "P_MAJUNIT_VALUE.DAxis.core.jscrib");
        ((SVGUnitDefinitionImpl)this.majorUnit).assign(source);
    }

    public UnitDefinition getMinorUnit() {
        if (this.minorUnit == null && this._dgraphic != null) {
            this.minorUnit = new SVGUnitDefinitionImpl(this._chart, this._dgraphic, this.axis, "P_MINUNIT_SHOW_TICK.DAxis.core.jscrib", "P_MINUNIT_SHOWGRID.DAxis.core.jscrib", "P_MINUNIT_VALUE.DAxis.core.jscrib");
        }
        return this.minorUnit;
    }

    public void setMinorUnit(UnitDefinition newMinorUnit) {
        this.minorUnit = newMinorUnit;
    }

    public void assignMinorUnit(UnitDefinition source) {
        this.minorUnit = new SVGUnitDefinitionImpl(this._chart, this._dgraphic, this.axis, "P_MINUNIT_SHOW_TICK.DAxis.core.jscrib", "P_MINUNIT_SHOWGRID.DAxis.core.jscrib", "P_MINUNIT_VALUE.DAxis.core.jscrib");
        ((SVGUnitDefinitionImpl)this.minorUnit).assign(source);
    }

    public List getMarkerLine() {
        if (this.markerLine == null) {
            if (this.axis != null) {
                List dgraphicList = this.axis.getChildrenOfClass(DMarkerLine.class);
                this.markerLine = new ArrayList();
                int i = 0;
                while (i < dgraphicList.size()) {
                    this.markerLine.add(new SVGMarkerLineImpl(this._chart, this._dgraphic, (DMarkerLine)dgraphicList.get(i)));
                    ++i;
                }
            } else {
                this.markerLine = new ArrayList();
            }
        }
        return this.markerLine;
    }

    public void setMarkerLine(List newMarkerLine) {
        this.markerLine = newMarkerLine;
        int i = 0;
        while (i < newMarkerLine.size()) {
            DMarkerLine markerline = ((SVGMarkerLineImpl)newMarkerLine.get(i)).getDMarkerLine();
            this.axis.addChild(markerline);
            ++i;
        }
    }

    public List getMarkerRegion() {
        if (this.markerRegion == null) {
            if (this._dgraphic != null) {
                List dgraphicList = this.axis.getChildrenOfClass(DMarkerRegion.class);
                this.markerRegion = new ArrayList();
                int i = 0;
                while (i < dgraphicList.size()) {
                    this.markerRegion.add(new SVGMarkerRegionImpl(this._chart, this._dgraphic, (DMarkerRegion)dgraphicList.get(i)));
                    ++i;
                }
            } else {
                this.markerRegion = new ArrayList();
            }
        }
        return this.markerRegion;
    }

    public void setMarkerRegion(List newMarkerRegion) {
        this.markerRegion = newMarkerRegion;
        int i = 0;
        while (i < newMarkerRegion.size()) {
            DMarkerRegion markerregion = ((SVGMarkerRegionImpl)newMarkerRegion.get(i)).getDMarkerRegion();
            this.axis.addChild(markerregion);
            ++i;
        }
    }

    public NumberFormat getNumberFormat() {
        String type = (String)this.axis.getProperties().get("P_LABEL_FORMATTYPE.DAxis.core.jscrib");
        if (this.numberFormat == null && this._dgraphic != null && type != null && type.equals("number")) {
            this.numberFormat = new SVGNumberFormatImpl(this._chart, this._dgraphic, (String)this.axis.getProperties().get("P_LABEL_FORMAT.DAxis.core.jscrib"));
        }
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.numberFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", "number");
    }

    public void assignNumberFormat(NumberFormat source) {
        this.numberFormat = new SVGNumberFormatImpl(this._chart, this._dgraphic, SVGNumberFormatImpl.PATTERN_EDEFAULT);
        ((SVGNumberFormatImpl)this.numberFormat).assign(source);
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.numberFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", "number");
    }

    public DateFormat getDateFormat() {
        String type = (String)this.axis.getProperties().get("P_LABEL_FORMATTYPE.DAxis.core.jscrib");
        if (this.dateFormat == null && this._dgraphic != null && type != null && type.equals("date")) {
            this.dateFormat = new SVGDateFormatImpl(this._chart, this._dgraphic, (String)this.axis.getProperties().get("P_LABEL_FORMAT.DAxis.core.jscrib"));
        }
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat newDateFormat) {
        this.dateFormat = newDateFormat;
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.dateFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", "date");
    }

    public void assignDateFormat(DateFormat source) {
        this.dateFormat = new SVGDateFormatImpl(this._chart, this._dgraphic, SVGDateFormatImpl.PATTERN_EDEFAULT);
        ((SVGDateFormatImpl)this.dateFormat).assign(source);
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.dateFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", "date");
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = this.getAccessibility(this.axis);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        super.constructAccessibilityModel(this.accessibility, this.axis);
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this.axis);
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        this.eventHandler = newEventHandler;
        super.constructEventHandlerModel(this.eventHandler, this.axis);
    }

    public Tooltip getTooltip() {
        if (this.tooltip == null && this._dgraphic != null && this.axis.getTooltip() != null) {
            this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, this.axis.getTooltip());
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        this.axis.setTooltip(newTooltip.getLabel());
    }

    public void assignTooltip(Tooltip source) {
        this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
        ((SVGTooltipImpl)this.tooltip).assign(source);
        this.axis.setTooltip(this.tooltip.getLabel());
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.getId());
        result.append(", label: ");
        result.append(this.getLabel());
        result.append(", max: ");
        if (this.maxESet) {
            result.append(this.max);
        } else {
            result.append("<unset>");
        }
        result.append(", min: ");
        if (this.minESet) {
            result.append(this.min);
        } else {
            result.append("<unset>");
        }
        result.append(", scale: ");
        result.append(this.scale);
        result.append(')');
        return result.toString();
    }

    public CustomFormat getCustomFormat() {
        String type = (String)this.axis.getProperties().get("P_LABEL_FORMATTYPE.DAxis.core.jscrib");
        if (this.customFormat == null && this._dgraphic != null && type != null && !type.equals("date") && !type.equals("number")) {
            this.customFormat = new SVGCustomFormatImpl(this._chart, this._dgraphic, (String)this.axis.getProperties().get("P_LABEL_FORMAT.DAxis.core.jscrib"), (String)this.axis.getProperties().get("P_LABEL_FORMATTYPE.DAxis.core.jscrib"));
        }
        return this.customFormat;
    }

    public void setCustomFormat(CustomFormat newCustomFormat) {
        this.customFormat = newCustomFormat;
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.customFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", this.customFormat.getFormatClass());
    }

    public void assignCustomFormat(CustomFormat source) {
        this.customFormat = new SVGCustomFormatImpl(this._chart, this._dgraphic, "", SVGCustomFormatImpl.FORMAT_CLASS_EDEFAULT);
        ((SVGCustomFormatImpl)this.customFormat).assign(source);
        this.axis.getProperties().store("P_LABEL_FORMAT.DAxis.core.jscrib", this.customFormat.getPattern());
        this.axis.getProperties().store("P_LABEL_FORMATTYPE.DAxis.core.jscrib", this.customFormat.getFormatClass());
    }
}

