/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGTooltipImpl;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDCoord;

public class SVGCategoricalDataImpl
extends SVGInputBase
implements CategoricalData {
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String TYPE_EDEFAULT = "actual";
    protected boolean typeESet = false;
    protected static final double VALUE_EDEFAULT = 0.0;
    protected boolean valueESet = false;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;
    protected Object categoryId = null;
    protected DPoint point = null;
    protected IDCoord categoryCoord = null;
    protected IDCoord valueCoord = null;

    protected SVGCategoricalDataImpl() {
    }

    public SVGCategoricalDataImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null, null, null);
    }

    public SVGCategoricalDataImpl(Chart chart, DGraphic dgraphic, DPoint point, IDCoord categoryCoord, IDCoord valueCoord) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.point = point;
        this.categoryCoord = categoryCoord;
        this.valueCoord = valueCoord;
    }

    public String getId() {
        return this.point.getId();
    }

    public void setId(String newId) {
        this.point.setId(newId);
    }

    public String getType() {
        if (this.point.getType() != TYPE_EDEFAULT) {
            this.typeESet = true;
        }
        return this.point.getType();
    }

    public void setType(String newType) {
        this.point.setType(newType);
        this.typeESet = true;
    }

    public void unsetType() {
        this.typeESet = false;
        this.point.setType(TYPE_EDEFAULT);
    }

    public boolean isSetType() {
        if (!this.typeESet) {
            this.getType();
        }
        return this.typeESet;
    }

    public double getValue() {
        if (this.valueCoord instanceof DCoord) {
            this.valueESet = true;
            return ((DCoord)this.valueCoord).getValue();
        }
        if (this.valueCoord instanceof DCoordObject) {
            this.valueESet = true;
            return Double.parseDouble(((DCoordObject)this.valueCoord).getValue(null).toString());
        }
        return 0.0;
    }

    public void setValue(double newValue) {
        if (this.valueCoord instanceof DCoord) {
            ((DCoord)this.valueCoord).setValue(newValue);
        } else if (this.valueCoord instanceof DCoordObject) {
            ((DCoordObject)this.valueCoord).setValue(new Double(newValue));
        }
        this.valueESet = true;
    }

    public void unsetValue() {
        if (this.valueCoord instanceof DCoord) {
            this.valueESet = false;
            ((DCoord)this.valueCoord).setValue(0.0);
        }
    }

    public boolean isSetValue() {
        if (!this.valueESet) {
            this.getValue();
        }
        return this.valueESet;
    }

    public Accessibility getAccessibility() {
        if (this.accessibility == null) {
            this.accessibility = this.getAccessibility(this.point);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
    }

    public void assignAccessibility(Accessibility source) {
        this.accessibility = new SVGAccessibilityImpl(this._chart, this._dgraphic, SVGAccessibilityImpl.TITLE_EDEFAULT, SVGAccessibilityImpl.DESCRIPTION_EDEFAULT);
        ((SVGAccessibilityImpl)this.accessibility).assign(source);
        super.constructAccessibilityModel(this.accessibility, this.point);
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            this.eventHandler = this.getEventHandler(this.point);
        }
        return this.eventHandler;
    }

    public void setEventHandler(List newEventHandler) {
        this.eventHandler = newEventHandler;
        super.constructEventHandlerModel(this.eventHandler, this.point);
    }

    public Tooltip getTooltip() {
        if (this.tooltip == null && this._dgraphic != null && this.point.getTooltip() != null) {
            this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, this.point.getTooltip());
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        this.point.setTooltip(this.tooltip.getLabel());
    }

    public void assignTooltip(Tooltip source) {
        this.tooltip = new SVGTooltipImpl(this._chart, this._dgraphic, SVGTooltipImpl.LABEL_EDEFAULT);
        ((SVGTooltipImpl)this.tooltip).assign(source);
        this.point.setTooltip(this.tooltip.getLabel());
    }

    public Object getCategoryId() {
        if (this.categoryId == null && this._dgraphic != null) {
            String refId = this.categoryCoord.getValue(null).toString();
            Data data = this._chart.getData();
            Categories categories = data.getCategories();
            List categoryList = categories.getCategory();
            int i = 0;
            while (i < categoryList.size()) {
                Category category = (Category)categoryList.get(i);
                if (category.getId().equals(refId)) {
                    this.categoryId = category;
                    break;
                }
                ++i;
            }
        }
        return this.categoryId;
    }

    public void setCategoryId(Object newCategoryId) {
        this.categoryId = newCategoryId;
        Category category = null;
        try {
            category = (Category)newCategoryId;
            String categoryIdStr = category.getId();
            this.categoryCoord.setValue(categoryIdStr);
        }
        catch (ClassCastException classCastException) {}
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(", type: ");
        if (this.typeESet) {
            result.append(this.getType());
        } else {
            result.append("<unset>");
        }
        result.append(", value: ");
        if (this.valueESet) {
            result.append(this.getValue());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

