/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAxisDefinitionImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetAssociationsImpl;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class SVGDependentAxisDefinitionImpl
extends SVGAxisDefinitionImpl
implements DependentAxisDefinition {
    protected DataSetAssociations dataSetAssociations = null;
    protected String dependantId;
    public static final String DEFAULT_DEPENDANT_ID = "y";

    protected SVGDependentAxisDefinitionImpl() {
    }

    public SVGDependentAxisDefinitionImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null, DEFAULT_DEPENDANT_ID);
    }

    public SVGDependentAxisDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis, String dependantId) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.axis = axis;
        this.dependantId = dependantId;
    }

    public DataSetAssociations getDataSetAssociations() {
        if (this.dataSetAssociations == null && this._dgraphic != null) {
            ArrayList<IDItem> curves = new ArrayList<IDItem>();
            IDItem item = this._dgraphic.getFirstChild();
            while (item != null) {
                if (item instanceof DCurve) {
                    ArrayList<DAxis> axis = new ArrayList<DAxis>();
                    IDItem point = ((DCurve)item).getFirstChild();
                    while (point != null) {
                        if (point instanceof DPoint) {
                            IDItem coord = ((DPoint)point).getFirstChild();
                            while (coord != null) {
                                if (coord instanceof DCoord) {
                                    axis.add(((DCoord)coord).getAxis());
                                }
                                coord = coord.getNext();
                            }
                            if (axis.size() != 0) break;
                        }
                        if (axis.size() != 0) break;
                        point = point.getNext();
                    }
                    if (axis.size() != 0) {
                        int j = 0;
                        while (j < axis.size()) {
                            if (((DAxis)axis.get(j)).getName().equals(this.dependantId)) {
                                curves.add(item);
                            }
                            ++j;
                        }
                    }
                }
                item = item.getNext();
            }
            this.dataSetAssociations = new SVGDataSetAssociationsImpl(this._chart, this._dgraphic, curves);
        }
        return this.dataSetAssociations;
    }

    public void setDataSetAssociations(DataSetAssociations newDataSetAssociations) {
        this.dataSetAssociations = newDataSetAssociations;
    }

    public void assignDataSetAssociations(DataSetAssociations source) {
        this.dataSetAssociations = new SVGDataSetAssociationsImpl(this._chart, this._dgraphic, null);
        ((SVGDataSetAssociationsImpl)this.dataSetAssociations).assign(source);
    }
}

