/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGAccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGEventHandlerImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityDesc;
import org.eclipse.tptp.platform.report.core.internal.DAccessibilityTitle;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DEvent;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DItemContainer;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.w3c.dom.Element;

public abstract class SVGInputBase {
    protected static DColorRegistry colors;
    protected Chart _chart;
    protected DGraphic _dgraphic;
    protected static Hashtable colorTable;

    static {
        colorTable = new Hashtable();
    }

    public DGraphic getDGraphic() {
        return this._dgraphic;
    }

    public void setDGraphic(DGraphic _dgraphic) {
        this._dgraphic = _dgraphic;
    }

    public Element getElement() {
        return null;
    }

    public void setElement(Element element) {
    }

    public void constructModel() {
    }

    public void log(String text) {
    }

    public void logln(String text) {
    }

    protected Accessibility getAccessibility(IDItem container) {
        if (this._dgraphic != null) {
            String title = null;
            String desc = null;
            IDItem item = container.getFirstChild();
            while (item != null) {
                if (item.getParent() == container) {
                    if (item instanceof DAccessibilityTitle) {
                        title = ((DAccessibilityTitle)item).getText();
                    } else if (item instanceof DAccessibilityDesc) {
                        desc = ((DAccessibilityDesc)item).getText();
                    }
                }
                if (title != null && desc != null) {
                    return new SVGAccessibilityImpl(this._chart, this._dgraphic, title, desc);
                }
                item = item.getNext();
            }
        }
        return null;
    }

    protected List getEventHandler(DItemContainer container) {
        ArrayList<SVGEventHandlerImpl> eventHandler = new ArrayList<SVGEventHandlerImpl>();
        if (this._dgraphic != null) {
            eventHandler = new ArrayList();
            IDItem item = container.getFirstChild();
            while (item != null) {
                if (item instanceof DEvent && item.getParent() == container) {
                    eventHandler.add(new SVGEventHandlerImpl(this._chart, this._dgraphic, (DEvent)item));
                }
                item = item.getNext();
            }
        }
        return eventHandler;
    }

    protected List getEventHandler(DPropertyStore propertyStore, String property) {
        ArrayList<SVGEventHandlerImpl> eventHandler = new ArrayList<SVGEventHandlerImpl>();
        if (this._dgraphic != null) {
            eventHandler = new ArrayList();
            List list = (List)propertyStore.get(property);
            if (list != null) {
                int x = 0;
                while (x < list.size()) {
                    Object item = list.get(x);
                    if (item instanceof DEvent) {
                        eventHandler.add(new SVGEventHandlerImpl(this._chart, this._dgraphic, (DEvent)item));
                    }
                    ++x;
                }
            }
        }
        return eventHandler;
    }

    protected void constructAccessibilityModel(Accessibility acc, IDItem parent) {
        DAccessibilityTitle accTitle = ((SVGAccessibilityImpl)acc).getDAccessibilityTitle();
        DAccessibilityDesc accDesc = ((SVGAccessibilityImpl)acc).getDAccessibilityDesc();
        parent.addChild(accTitle);
        parent.addChild(accDesc);
    }

    protected void constructEventHandlerModel(List eventhandler, IDItem parent) {
        int i = 0;
        while (i < eventhandler.size()) {
            DEvent event = ((SVGEventHandlerImpl)eventhandler.get(i)).getDEvent();
            parent.addChild(event);
            ++i;
        }
    }

    private int search(Method[] list, String name) {
        int i = 0;
        while (i < list.length) {
            if (list[i].toString().indexOf(name) != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private Object getObject(Method method, Object source) {
        Object[] arg = new Object[]{};
        Object get_result = null;
        try {
            get_result = method.invoke(source, arg);
            this.log(String.valueOf(method.getName()) + " = " + get_result + " ");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return get_result;
    }

    private Object getObject(Method[] list, String name, Object source) {
        int index = this.search(list, name);
        Object[] arg = new Object[]{};
        Object get_result = null;
        try {
            if (index >= 0) {
                get_result = list[index].invoke(source, arg);
                this.log(String.valueOf(list[index].getName()) + " = " + get_result + " ");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return get_result;
    }

    private void setObject(Method[] list, String name, Object source, Object[] arg) {
        int index = this.search(list, name);
        try {
            if (index >= 0) {
                list[index].invoke(source, arg);
                this.logln(" >> " + list[index].getName());
            } else {
                this.logln(" >> Set method not found");
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public void assign(Object source) {
        Class<?> c = source.getClass();
        this.logln("\n current class: " + c.getName());
        Method[] sourceMethod = source.getClass().getMethods();
        Method[] selfMethod = this.getClass().getMethods();
        String methodSubstring = null;
        int i = 0;
        while (i < sourceMethod.length) {
            if (sourceMethod[i].getName().substring(0, 3).equals("get")) {
                Object get_result;
                this.log(String.valueOf(sourceMethod[i].getName().substring(3)) + " - ");
                Class<?> returnType = sourceMethod[i].getReturnType();
                if (returnType.isPrimitive() || returnType.getName().equals("java.lang.String")) {
                    this.log("primitive: ");
                    get_result = this.getObject(sourceMethod[i], source);
                    if (get_result != null) {
                        methodSubstring = ".isSet" + sourceMethod[i].getName().substring(3) + "(";
                        Object isSet_result = this.getObject(sourceMethod, methodSubstring, source);
                        if (isSet_result == null || isSet_result.toString().equals("true")) {
                            methodSubstring = ".set" + sourceMethod[i].getName().substring(3) + "(";
                            this.setObject(selfMethod, methodSubstring, this, new Object[]{get_result});
                        } else {
                            this.logln("   do not set");
                        }
                    } else {
                        this.logln("");
                    }
                } else if (returnType.getName().equals("java.util.List")) {
                    this.log("List: ");
                    List result = null;
                    List resultList = (List)this.getObject(sourceMethod[i], source);
                    if (resultList != null && resultList.size() != 0) {
                        result = sourceMethod[i].getName().substring(3).indexOf("Id") != -1 ? null : this.listFactory(resultList);
                        if (result == null) {
                            methodSubstring = ".assign" + sourceMethod[i].getName().substring(3) + "(";
                            this.setObject(selfMethod, methodSubstring, this, new Object[]{resultList});
                        } else {
                            methodSubstring = ".set" + sourceMethod[i].getName().substring(3) + "(";
                            this.setObject(selfMethod, methodSubstring, this, new Object[]{result});
                        }
                    } else {
                        this.logln("");
                    }
                } else if (returnType.getName().toString().indexOf("org.eclipse.tptp.platform.report.chart.svg.internal.input") != -1 || returnType.getName().toString().indexOf("java.lang.Object") != -1) {
                    this.log("Object: ");
                    get_result = (InputBase)this.getObject(sourceMethod[i], source);
                    if (get_result != null) {
                        methodSubstring = ".assign" + sourceMethod[i].getName().substring(3) + "(";
                        this.setObject(selfMethod, methodSubstring, this, new Object[]{get_result});
                    } else {
                        this.logln("");
                    }
                } else {
                    this.logln(returnType.getName());
                }
            } else if (sourceMethod[i].getName().substring(0, 2).equals("is") && !sourceMethod[i].getName().substring(2, 5).equals("Set")) {
                this.log(String.valueOf(sourceMethod[i].getName().substring(2)) + " - ");
                methodSubstring = ".isSet" + sourceMethod[i].getName().substring(2) + "(";
                Object isSet_result = this.getObject(sourceMethod, methodSubstring, source);
                if (isSet_result.toString().equals("true")) {
                    Object is_result = this.getObject(sourceMethod[i], source);
                    if (is_result != null) {
                        methodSubstring = ".set" + sourceMethod[i].getName().substring(2) + "(";
                        this.setObject(selfMethod, methodSubstring, this, new Object[]{is_result});
                    } else {
                        this.logln("");
                    }
                } else {
                    this.logln("");
                }
            }
            ++i;
        }
        this.constructModel();
        this.logln("return");
    }

    protected List listFactory(List sourceList) {
        int con;
        Constructor<?>[] theConstructors;
        Class[] parameter;
        ArrayList<SVGInputBase> newList;
        block12: {
            newList = new ArrayList<SVGInputBase>();
            String class_string = sourceList.get(0).getClass().toString();
            int last_dot = class_string.lastIndexOf(".") + 1;
            String jscrib_string = "org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVG" + class_string.substring(last_dot);
            Class<?> c = Class.forName(jscrib_string);
            parameter = null;
            theConstructors = c.getConstructors();
            con = 0;
            int j = 0;
            while (j < theConstructors.length) {
                if (theConstructors[j].getParameterTypes().length == 3) {
                    parameter = theConstructors[j].getParameterTypes();
                    con = j;
                    break;
                }
                ++j;
            }
            if (parameter != null && parameter.length == 3) break block12;
            return null;
        }
        try {
            Constructor<?>[] itemConstructor = parameter[2].getConstructors();
            int defaultCon = 0;
            int k = 0;
            while (k < itemConstructor.length) {
                if (itemConstructor[k].getParameterTypes().length == 0) {
                    defaultCon = k;
                    break;
                }
                ++k;
            }
            int i = 0;
            while (i < sourceList.size()) {
                Object[] item_arg = new Object[]{};
                Object item = itemConstructor[defaultCon].newInstance(item_arg);
                Object[] argument = new Object[]{this._chart, this._dgraphic, item};
                SVGInputBase cell = (SVGInputBase)theConstructors[con].newInstance(argument);
                cell.assign(sourceList.get(i));
                newList.add(cell);
                ++i;
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println(e);
        }
        catch (InstantiationException e) {
            System.out.println(e);
        }
        catch (IllegalAccessException e) {
            System.out.println(e);
        }
        catch (IllegalArgumentException e) {
            System.out.println(e);
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
        }
        return newList;
    }

    protected String convertToHex(String colorId) {
        if (colorId.equals("white")) {
            return "#FFFFFF";
        }
        if (colorId.equals("blue")) {
            return "#0000FF";
        }
        if (colorId.equals("red")) {
            return "#FF0000";
        }
        if (colorId.equals("green")) {
            return "#008B00";
        }
        if (colorId.equals("yellow")) {
            return "#FFFF00";
        }
        if (colorId.equals("magenta")) {
            return "#FF00FF";
        }
        if (colorId.equals("cyan")) {
            return "#00FFFF";
        }
        if (colorId.equals("darkgrey")) {
            return "#555555";
        }
        if (colorId.equals("darkblue")) {
            return "#000080";
        }
        if (colorId.equals("darkred")) {
            return "#800000";
        }
        if (colorId.equals("darkgreen")) {
            return "#008000";
        }
        if (colorId.equals("darkyellow")) {
            return "#808000";
        }
        if (colorId.equals("darkmagenta")) {
            return "#800080";
        }
        if (colorId.equals("darkcyan")) {
            return "#008080";
        }
        if (colorId.equals("gold")) {
            return "#FFD700";
        }
        if (colorId.equals("lightgrey")) {
            return "#AAAAAA";
        }
        if (colorId.equals("lightblue")) {
            return "#8080FF";
        }
        if (colorId.equals("lightred")) {
            return "#FF8080";
        }
        if (colorId.equals("lightgreen")) {
            return "#80FF80";
        }
        if (colorId.equals("lightyellow")) {
            return "#FFFF80";
        }
        if (colorId.equals("lightmagenta")) {
            return "#FF80FF";
        }
        if (colorId.equals("lightcyan")) {
            return "#80FFFF";
        }
        if (colorId.equals("lilac")) {
            return "#EE82EE";
        }
        if (colorId.equals("turquoise")) {
            return "#40E0D0";
        }
        if (colorId.equals("aquamarine")) {
            return "#7FFFD4";
        }
        if (colorId.equals("khaki")) {
            return "#F0E68C";
        }
        if (colorId.equals("purple")) {
            return "#A020F0";
        }
        if (colorId.equals("yellowgreen")) {
            return "#9ACD32";
        }
        if (colorId.equals("pink")) {
            return "#FFC0CB";
        }
        if (colorId.equals("orange")) {
            return "#FFA500";
        }
        if (colorId.equals("orchid")) {
            return "#DA70D6";
        }
        if (colorId.equals("black")) {
            return "#000000";
        }
        return null;
    }

    protected String getColor(DColor color) {
        if (color == null) {
            return null;
        }
        Color c = new Color(color.getRed(), color.getGreen(), color.getBlue());
        return "#" + Integer.toHexString(c.getRGB() & 0xFFFFFF);
    }
}

