/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerLine;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

public class SVGMarkerLineImpl
extends SVGInputBase
implements MarkerLine {
    protected static final String COLOR_EDEFAULT = null;
    protected static final String ID_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = null;
    protected static final double THICKNESS_EDEFAULT = 0.0;
    protected boolean thicknessESet = false;
    protected static final double VALUE_EDEFAULT = 0.0;
    protected boolean valueESet = false;
    protected DMarkerLine markerline = null;

    protected SVGMarkerLineImpl() {
    }

    public SVGMarkerLineImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGMarkerLineImpl(Chart chart, DGraphic dgraphic, DMarkerLine markerline) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.markerline = markerline;
    }

    public void unsetThickness() {
        this.thicknessESet = false;
        this.setThickness(0.0);
    }

    public boolean isSetThickness() {
        if (!this.thicknessESet) {
            this.getThickness();
        }
        return this.thicknessESet;
    }

    public void unsetValue() {
        this.valueESet = false;
        this.setValue(0.0);
    }

    public boolean isSetValue() {
        if (!this.valueESet) {
            this.getValue();
        }
        return this.valueESet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (color: ");
        result.append(this.getColor());
        result.append(", id: ");
        result.append(this.getId());
        result.append(", label: ");
        result.append(this.getLabel());
        result.append(", thickness: ");
        if (this.thicknessESet) {
            result.append(this.getThickness());
        } else {
            result.append("<unset>");
        }
        result.append(", value: ");
        if (this.valueESet) {
            result.append(this.getValue());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public String getColor() {
        IDColor color = this.markerline.getColor();
        if (color != null) {
            return color.serializeToString();
        }
        return null;
    }

    public String getId() {
        return this.markerline.getId();
    }

    public String getLabel() {
        return this.markerline.getLabel();
    }

    public double getThickness() {
        if (this.markerline.getThickness() != 0.0) {
            this.thicknessESet = true;
        }
        return this.markerline.getThickness();
    }

    public double getValue() {
        Object value = this.markerline.getValue();
        if (value instanceof Double) {
            this.valueESet = true;
            return (Double)value;
        }
        return 0.0;
    }

    public void setColor(String newColor) {
        IDColor color;
        if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#")) {
            newColor = this.convertToHex(newColor);
        }
        if (newColor == null || newColor == "") {
            newColor = "#000000";
        }
        if ((color = this.markerline.getColor()) == null) {
            color = new DColor();
        }
        color.serializeFromString(newColor);
        this.markerline.setColor(color);
    }

    public void setId(String id) {
        this.markerline.setId(id);
    }

    public void setLabel(String label) {
        this.markerline.setLabel(label);
    }

    public void setThickness(double thickness) {
        this.markerline.setThickness(thickness);
    }

    public void setValue(double value) {
        this.markerline.setValue(new Double(value));
    }

    public DMarkerLine getDMarkerLine() {
        return this.markerline;
    }
}

