/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DMarkerRegion;
import org.eclipse.tptp.platform.report.core.internal.IDColor;

public class SVGMarkerRegionImpl
extends SVGInputBase
implements MarkerRegion {
    protected static final String COLOR_EDEFAULT = null;
    protected static final double FROM_VALUE_EDEFAULT = 0.0;
    protected boolean fromValueESet = false;
    protected static final String ID_EDEFAULT = null;
    protected static final String LABEL_EDEFAULT = null;
    protected static final double TO_VALUE_EDEFAULT = 0.0;
    protected boolean toValueESet = false;
    protected DMarkerRegion markerregion = null;

    public String getColor() {
        IDColor color = this.markerregion.getColor();
        if (color != null) {
            return color.serializeToString();
        }
        return null;
    }

    public double getFromValue() {
        Object value = this.markerregion.getFromValue();
        if (value instanceof Double) {
            this.fromValueESet = true;
            return (Double)value;
        }
        return 0.0;
    }

    public String getId() {
        return this.markerregion.getId();
    }

    public String getLabel() {
        return this.markerregion.getLabel();
    }

    public double getToValue() {
        Object value = this.markerregion.getToValue();
        if (value instanceof Double) {
            this.toValueESet = true;
            return (Double)value;
        }
        return 0.0;
    }

    public void setColor(String newColor) {
        IDColor color;
        if (newColor != null && newColor != "" && !newColor.substring(0, 1).equals("#")) {
            newColor = this.convertToHex(newColor);
        }
        if (newColor == null || newColor == "") {
            newColor = "#000000";
        }
        if ((color = this.markerregion.getColor()) == null) {
            color = new DColor();
        }
        color.serializeFromString(newColor);
        this.markerregion.setColor(color);
    }

    public void setFromValue(double fromValue) {
        this.markerregion.setFromValue(new Double(fromValue));
    }

    public void setId(String id) {
        this.markerregion.setId(id);
    }

    public void setLabel(String label) {
        this.markerregion.setLabel(label);
    }

    public void setToValue(double toValue) {
        this.markerregion.setToValue(new Double(toValue));
    }

    protected SVGMarkerRegionImpl() {
    }

    public SVGMarkerRegionImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGMarkerRegionImpl(Chart chart, DGraphic dgraphic, DMarkerRegion markerregion) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.markerregion = markerregion;
    }

    public void unsetFromValue() {
        this.fromValueESet = false;
        this.setFromValue(0.0);
    }

    public boolean isSetFromValue() {
        if (!this.fromValueESet) {
            this.getFromValue();
        }
        return this.fromValueESet;
    }

    public void unsetToValue() {
        this.toValueESet = false;
        this.setFromValue(0.0);
    }

    public boolean isSetToValue() {
        if (!this.toValueESet) {
            this.getToValue();
        }
        return this.toValueESet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (color: ");
        result.append(this.getColor());
        result.append(", fromValue: ");
        if (this.fromValueESet) {
            result.append(this.getFromValue());
        } else {
            result.append("<unset>");
        }
        result.append(", id: ");
        result.append(this.getId());
        result.append(", label: ");
        result.append(this.getLabel());
        result.append(", toValue: ");
        if (this.toValueESet) {
            result.append(this.getToValue());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public DMarkerRegion getDMarkerRegion() {
        return this.markerregion;
    }
}

