/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Palettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGDataSetColorImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DPalettes;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class SVGPalettesImpl
extends SVGInputBase
implements Palettes {
    protected static final String LOCATION_EDEFAULT = null;
    protected static final String PALETTE_ID_EDEFAULT = null;
    protected static final String PALETTE_SET_ID_EDEFAULT = null;
    protected String paletteSetId = PALETTE_SET_ID_EDEFAULT;
    protected List dataSetColor = null;
    protected DPalettes pal = null;

    protected SVGPalettesImpl() {
    }

    public SVGPalettesImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic());
    }

    public SVGPalettesImpl(Chart chart, DGraphic dgraphic) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.pal = (DPalettes)this._dgraphic.getChildOfClass(DPalettes.class);
        if (this.pal == null) {
            this.pal = new DPalettes();
        }
    }

    public List getDataSetColor() {
        if (this.dataSetColor == null) {
            if (this._dgraphic != null) {
                this.dataSetColor = new ArrayList();
                IDItem item = this._dgraphic.getFirstChild();
                while (item != null) {
                    if (item instanceof DCurve && SVGDataSetColorImpl.hasColor((DCurve)item)) {
                        this.dataSetColor.add(new SVGDataSetColorImpl(this._chart, this._dgraphic, (DCurve)item));
                    }
                    item = item.getNext();
                }
            } else {
                this.dataSetColor = new ArrayList();
            }
        }
        return this.dataSetColor;
    }

    public void setDataSetColor(List newDataSetColor) {
        this.dataSetColor = newDataSetColor;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.getLocation());
        result.append(", paletteId: ");
        result.append(this.getPaletteId());
        result.append(", paletteSetId: ");
        result.append(this.paletteSetId);
        result.append(')');
        return result.toString();
    }

    public String getLocation() {
        return this.pal.getLocation();
    }

    public String getPaletteId() {
        return this.pal.getPaletteId();
    }

    public void setLocation(String location) {
        this.pal.setLocation(location);
    }

    public void setPaletteId(String paletteId) {
        this.pal.setPaletteId(paletteId);
    }

    public String getPaletteSetId() {
        return this.pal.getPaletteSetId();
    }

    public void setPaletteSetId(String paletteSetId) {
        this.pal.setPaletteSetId(paletteSetId);
    }

    public void constructModel() {
        if (this._dgraphic.getChildOfClass(DPalettes.class) == null) {
            this._dgraphic.addChild(this.pal);
        }
    }
}

